/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes additional settings for a stateful rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleOption implements SdkPojo, Serializable, ToCopyableBuilder<RuleOption.Builder, RuleOption> {
    private static final SdkField<String> KEYWORD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Keyword")
            .getter(getter(RuleOption::keyword))
            .setter(setter(Builder::keyword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keyword")
                    .unmarshallLocationName("keyword").build()).build();

    private static final SdkField<List<String>> SETTINGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Settings")
            .getter(getter(RuleOption::settings))
            .setter(setter(Builder::settings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SettingSet")
                    .unmarshallLocationName("settingSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(KEYWORD_FIELD, SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String keyword;

    private final List<String> settings;

    private RuleOption(BuilderImpl builder) {
        this.keyword = builder.keyword;
        this.settings = builder.settings;
    }

    /**
     * <p>
     * The Suricata keyword.
     * </p>
     * 
     * @return The Suricata keyword.
     */
    public final String keyword() {
        return keyword;
    }

    /**
     * For responses, this returns true if the service returned a value for the Settings property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSettings() {
        return settings != null && !(settings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The settings for the keyword.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSettings} method.
     * </p>
     * 
     * @return The settings for the keyword.
     */
    public final List<String> settings() {
        return settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyword());
        hashCode = 31 * hashCode + Objects.hashCode(hasSettings() ? settings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleOption)) {
            return false;
        }
        RuleOption other = (RuleOption) obj;
        return Objects.equals(keyword(), other.keyword()) && hasSettings() == other.hasSettings()
                && Objects.equals(settings(), other.settings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleOption").add("Keyword", keyword()).add("Settings", hasSettings() ? settings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Keyword":
            return Optional.ofNullable(clazz.cast(keyword()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Keyword", KEYWORD_FIELD);
        map.put("SettingSet", SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleOption, T> g) {
        return obj -> g.apply((RuleOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleOption> {
        /**
         * <p>
         * The Suricata keyword.
         * </p>
         * 
         * @param keyword
         *        The Suricata keyword.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyword(String keyword);

        /**
         * <p>
         * The settings for the keyword.
         * </p>
         * 
         * @param settings
         *        The settings for the keyword.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(Collection<String> settings);

        /**
         * <p>
         * The settings for the keyword.
         * </p>
         * 
         * @param settings
         *        The settings for the keyword.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(String... settings);
    }

    static final class BuilderImpl implements Builder {
        private String keyword;

        private List<String> settings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleOption model) {
            keyword(model.keyword);
            settings(model.settings);
        }

        public final String getKeyword() {
            return keyword;
        }

        public final void setKeyword(String keyword) {
            this.keyword = keyword;
        }

        @Override
        public final Builder keyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        public final Collection<String> getSettings() {
            if (settings instanceof SdkAutoConstructList) {
                return null;
            }
            return settings;
        }

        public final void setSettings(Collection<String> settings) {
            this.settings = StringListCopier.copy(settings);
        }

        @Override
        @Transient
        public final Builder settings(Collection<String> settings) {
            this.settings = StringListCopier.copy(settings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder settings(String... settings) {
            settings(Arrays.asList(settings));
            return this;
        }

        @Override
        public RuleOption build() {
            return new RuleOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
