/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Region implements SdkPojo, Serializable, ToCopyableBuilder<Region.Builder, Region> {
    private static final SdkField<String> OPT_IN_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OptInStatus")
            .getter(getter(Region::optInStatus))
            .setter(setter(Builder::optInStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptInStatus")
                    .unmarshallLocationName("optInStatus").build()).build();

    private static final SdkField<List<RegionGeography>> GEOGRAPHY_FIELD = SdkField
            .<List<RegionGeography>> builder(MarshallingType.LIST)
            .memberName("Geography")
            .getter(getter(Region::geography))
            .setter(setter(Builder::geography))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeographySet")
                    .unmarshallLocationName("geographySet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<RegionGeography> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegionGeography::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> REGION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RegionName")
            .getter(getter(Region::regionName))
            .setter(setter(Builder::regionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName")
                    .unmarshallLocationName("regionName").build()).build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Endpoint")
            .getter(getter(Region::endpoint))
            .setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionEndpoint")
                    .unmarshallLocationName("regionEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPT_IN_STATUS_FIELD,
            GEOGRAPHY_FIELD, REGION_NAME_FIELD, ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String optInStatus;

    private final List<RegionGeography> geography;

    private final String regionName;

    private final String endpoint;

    private Region(BuilderImpl builder) {
        this.optInStatus = builder.optInStatus;
        this.geography = builder.geography;
        this.regionName = builder.regionName;
        this.endpoint = builder.endpoint;
    }

    /**
     * <p>
     * The Region opt-in status. The possible values are <code>opt-in-not-required</code>, <code>opted-in</code>, and
     * <code>not-opted-in</code>.
     * </p>
     * 
     * @return The Region opt-in status. The possible values are <code>opt-in-not-required</code>, <code>opted-in</code>
     *         , and <code>not-opted-in</code>.
     */
    public final String optInStatus() {
        return optInStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the Geography property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGeography() {
        return geography != null && !(geography instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The geography information for the Region. The geography is returned as a list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGeography} method.
     * </p>
     * 
     * @return The geography information for the Region. The geography is returned as a list.
     */
    public final List<RegionGeography> geography() {
        return geography;
    }

    /**
     * <p>
     * The name of the Region.
     * </p>
     * 
     * @return The name of the Region.
     */
    public final String regionName() {
        return regionName;
    }

    /**
     * <p>
     * The Region service endpoint.
     * </p>
     * 
     * @return The Region service endpoint.
     */
    public final String endpoint() {
        return endpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(optInStatus());
        hashCode = 31 * hashCode + Objects.hashCode(hasGeography() ? geography() : null);
        hashCode = 31 * hashCode + Objects.hashCode(regionName());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Region)) {
            return false;
        }
        Region other = (Region) obj;
        return Objects.equals(optInStatus(), other.optInStatus()) && hasGeography() == other.hasGeography()
                && Objects.equals(geography(), other.geography()) && Objects.equals(regionName(), other.regionName())
                && Objects.equals(endpoint(), other.endpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Region").add("OptInStatus", optInStatus()).add("Geography", hasGeography() ? geography() : null)
                .add("RegionName", regionName()).add("Endpoint", endpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OptInStatus":
            return Optional.ofNullable(clazz.cast(optInStatus()));
        case "Geography":
            return Optional.ofNullable(clazz.cast(geography()));
        case "RegionName":
            return Optional.ofNullable(clazz.cast(regionName()));
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OptInStatus", OPT_IN_STATUS_FIELD);
        map.put("GeographySet", GEOGRAPHY_FIELD);
        map.put("RegionName", REGION_NAME_FIELD);
        map.put("RegionEndpoint", ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Region, T> g) {
        return obj -> g.apply((Region) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Region> {
        /**
         * <p>
         * The Region opt-in status. The possible values are <code>opt-in-not-required</code>, <code>opted-in</code>,
         * and <code>not-opted-in</code>.
         * </p>
         * 
         * @param optInStatus
         *        The Region opt-in status. The possible values are <code>opt-in-not-required</code>,
         *        <code>opted-in</code>, and <code>not-opted-in</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optInStatus(String optInStatus);

        /**
         * <p>
         * The geography information for the Region. The geography is returned as a list.
         * </p>
         * 
         * @param geography
         *        The geography information for the Region. The geography is returned as a list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geography(Collection<RegionGeography> geography);

        /**
         * <p>
         * The geography information for the Region. The geography is returned as a list.
         * </p>
         * 
         * @param geography
         *        The geography information for the Region. The geography is returned as a list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geography(RegionGeography... geography);

        /**
         * <p>
         * The geography information for the Region. The geography is returned as a list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.RegionGeography.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.RegionGeography#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.RegionGeography.Builder#build()} is called immediately and
         * its result is passed to {@link #geography(List<RegionGeography>)}.
         * 
         * @param geography
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.RegionGeography.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geography(java.util.Collection<RegionGeography>)
         */
        Builder geography(Consumer<RegionGeography.Builder>... geography);

        /**
         * <p>
         * The name of the Region.
         * </p>
         * 
         * @param regionName
         *        The name of the Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);

        /**
         * <p>
         * The Region service endpoint.
         * </p>
         * 
         * @param endpoint
         *        The Region service endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);
    }

    static final class BuilderImpl implements Builder {
        private String optInStatus;

        private List<RegionGeography> geography = DefaultSdkAutoConstructList.getInstance();

        private String regionName;

        private String endpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(Region model) {
            optInStatus(model.optInStatus);
            geography(model.geography);
            regionName(model.regionName);
            endpoint(model.endpoint);
        }

        public final String getOptInStatus() {
            return optInStatus;
        }

        public final void setOptInStatus(String optInStatus) {
            this.optInStatus = optInStatus;
        }

        @Override
        public final Builder optInStatus(String optInStatus) {
            this.optInStatus = optInStatus;
            return this;
        }

        public final List<RegionGeography.Builder> getGeography() {
            List<RegionGeography.Builder> result = RegionGeographyListCopier.copyToBuilder(this.geography);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGeography(Collection<RegionGeography.BuilderImpl> geography) {
            this.geography = RegionGeographyListCopier.copyFromBuilder(geography);
        }

        @Override
        public final Builder geography(Collection<RegionGeography> geography) {
            this.geography = RegionGeographyListCopier.copy(geography);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geography(RegionGeography... geography) {
            geography(Arrays.asList(geography));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geography(Consumer<RegionGeography.Builder>... geography) {
            geography(Stream.of(geography).map(c -> RegionGeography.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getRegionName() {
            return regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public Region build() {
            return new Region(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
