/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum Metric {
    RESERVATION_TOTAL_CAPACITY_HRS_VCPU("reservation-total-capacity-hrs-vcpu"),

    RESERVATION_TOTAL_CAPACITY_HRS_INST("reservation-total-capacity-hrs-inst"),

    RESERVATION_MAX_SIZE_VCPU("reservation-max-size-vcpu"),

    RESERVATION_MAX_SIZE_INST("reservation-max-size-inst"),

    RESERVATION_MIN_SIZE_VCPU("reservation-min-size-vcpu"),

    RESERVATION_MIN_SIZE_INST("reservation-min-size-inst"),

    RESERVATION_UNUSED_TOTAL_CAPACITY_HRS_VCPU("reservation-unused-total-capacity-hrs-vcpu"),

    RESERVATION_UNUSED_TOTAL_CAPACITY_HRS_INST("reservation-unused-total-capacity-hrs-inst"),

    RESERVATION_UNUSED_TOTAL_ESTIMATED_COST("reservation-unused-total-estimated-cost"),

    RESERVATION_MAX_UNUSED_SIZE_VCPU("reservation-max-unused-size-vcpu"),

    RESERVATION_MAX_UNUSED_SIZE_INST("reservation-max-unused-size-inst"),

    RESERVATION_MIN_UNUSED_SIZE_VCPU("reservation-min-unused-size-vcpu"),

    RESERVATION_MIN_UNUSED_SIZE_INST("reservation-min-unused-size-inst"),

    RESERVATION_MAX_UTILIZATION("reservation-max-utilization"),

    RESERVATION_MIN_UTILIZATION("reservation-min-utilization"),

    RESERVATION_AVG_UTILIZATION_VCPU("reservation-avg-utilization-vcpu"),

    RESERVATION_AVG_UTILIZATION_INST("reservation-avg-utilization-inst"),

    RESERVATION_TOTAL_COUNT("reservation-total-count"),

    RESERVATION_TOTAL_ESTIMATED_COST("reservation-total-estimated-cost"),

    RESERVATION_AVG_FUTURE_SIZE_VCPU("reservation-avg-future-size-vcpu"),

    RESERVATION_AVG_FUTURE_SIZE_INST("reservation-avg-future-size-inst"),

    RESERVATION_MIN_FUTURE_SIZE_VCPU("reservation-min-future-size-vcpu"),

    RESERVATION_MIN_FUTURE_SIZE_INST("reservation-min-future-size-inst"),

    RESERVATION_MAX_FUTURE_SIZE_VCPU("reservation-max-future-size-vcpu"),

    RESERVATION_MAX_FUTURE_SIZE_INST("reservation-max-future-size-inst"),

    RESERVATION_AVG_COMMITTED_SIZE_VCPU("reservation-avg-committed-size-vcpu"),

    RESERVATION_AVG_COMMITTED_SIZE_INST("reservation-avg-committed-size-inst"),

    RESERVATION_MAX_COMMITTED_SIZE_VCPU("reservation-max-committed-size-vcpu"),

    RESERVATION_MAX_COMMITTED_SIZE_INST("reservation-max-committed-size-inst"),

    RESERVATION_MIN_COMMITTED_SIZE_VCPU("reservation-min-committed-size-vcpu"),

    RESERVATION_MIN_COMMITTED_SIZE_INST("reservation-min-committed-size-inst"),

    RESERVED_TOTAL_USAGE_HRS_VCPU("reserved-total-usage-hrs-vcpu"),

    RESERVED_TOTAL_USAGE_HRS_INST("reserved-total-usage-hrs-inst"),

    RESERVED_TOTAL_ESTIMATED_COST("reserved-total-estimated-cost"),

    UNRESERVED_TOTAL_USAGE_HRS_VCPU("unreserved-total-usage-hrs-vcpu"),

    UNRESERVED_TOTAL_USAGE_HRS_INST("unreserved-total-usage-hrs-inst"),

    UNRESERVED_TOTAL_ESTIMATED_COST("unreserved-total-estimated-cost"),

    SPOT_TOTAL_USAGE_HRS_VCPU("spot-total-usage-hrs-vcpu"),

    SPOT_TOTAL_USAGE_HRS_INST("spot-total-usage-hrs-inst"),

    SPOT_TOTAL_ESTIMATED_COST("spot-total-estimated-cost"),

    SPOT_AVG_RUN_TIME_BEFORE_INTERRUPTION_INST("spot-avg-run-time-before-interruption-inst"),

    SPOT_MAX_RUN_TIME_BEFORE_INTERRUPTION_INST("spot-max-run-time-before-interruption-inst"),

    SPOT_MIN_RUN_TIME_BEFORE_INTERRUPTION_INST("spot-min-run-time-before-interruption-inst"),

    SPOT_TOTAL_INTERRUPTIONS_INST("spot-total-interruptions-inst"),

    SPOT_TOTAL_INTERRUPTIONS_VCPU("spot-total-interruptions-vcpu"),

    SPOT_TOTAL_COUNT_INST("spot-total-count-inst"),

    SPOT_TOTAL_COUNT_VCPU("spot-total-count-vcpu"),

    SPOT_INTERRUPTION_RATE_INST("spot-interruption-rate-inst"),

    SPOT_INTERRUPTION_RATE_VCPU("spot-interruption-rate-vcpu"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Metric> VALUE_MAP = EnumUtils.uniqueIndex(Metric.class, Metric::toString);

    private final String value;

    private Metric(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return Metric corresponding to the value
     */
    public static Metric fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link Metric}s
     */
    public static Set<Metric> knownValues() {
        Set<Metric> knownValues = EnumSet.allOf(Metric.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
