/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an event in the history of an EC2 Fleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HistoryRecordEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<HistoryRecordEntry.Builder, HistoryRecordEntry> {
    private static final SdkField<EventInformation> EVENT_INFORMATION_FIELD = SdkField
            .<EventInformation> builder(MarshallingType.SDK_POJO)
            .memberName("EventInformation")
            .getter(getter(HistoryRecordEntry::eventInformation))
            .setter(setter(Builder::eventInformation))
            .constructor(EventInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventInformation")
                    .unmarshallLocationName("eventInformation").build()).build();

    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EventType")
            .getter(getter(HistoryRecordEntry::eventTypeAsString))
            .setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType")
                    .unmarshallLocationName("eventType").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp")
            .getter(getter(HistoryRecordEntry::timestamp))
            .setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp")
                    .unmarshallLocationName("timestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_INFORMATION_FIELD,
            EVENT_TYPE_FIELD, TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EventInformation eventInformation;

    private final String eventType;

    private final Instant timestamp;

    private HistoryRecordEntry(BuilderImpl builder) {
        this.eventInformation = builder.eventInformation;
        this.eventType = builder.eventType;
        this.timestamp = builder.timestamp;
    }

    /**
     * <p>
     * Information about the event.
     * </p>
     * 
     * @return Information about the event.
     */
    public final EventInformation eventInformation() {
        return eventInformation;
    }

    /**
     * <p>
     * The event type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link FleetEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The event type.
     * @see FleetEventType
     */
    public final FleetEventType eventType() {
        return FleetEventType.fromValue(eventType);
    }

    /**
     * <p>
     * The event type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link FleetEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The event type.
     * @see FleetEventType
     */
    public final String eventTypeAsString() {
        return eventType;
    }

    /**
     * <p>
     * The date and time of the event, in UTC format (for example,
     * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     * </p>
     * 
     * @return The date and time of the event, in UTC format (for example,
     *         <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     */
    public final Instant timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventInformation());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistoryRecordEntry)) {
            return false;
        }
        HistoryRecordEntry other = (HistoryRecordEntry) obj;
        return Objects.equals(eventInformation(), other.eventInformation())
                && Objects.equals(eventTypeAsString(), other.eventTypeAsString())
                && Objects.equals(timestamp(), other.timestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HistoryRecordEntry").add("EventInformation", eventInformation())
                .add("EventType", eventTypeAsString()).add("Timestamp", timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventInformation":
            return Optional.ofNullable(clazz.cast(eventInformation()));
        case "EventType":
            return Optional.ofNullable(clazz.cast(eventTypeAsString()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EventInformation", EVENT_INFORMATION_FIELD);
        map.put("EventType", EVENT_TYPE_FIELD);
        map.put("Timestamp", TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HistoryRecordEntry, T> g) {
        return obj -> g.apply((HistoryRecordEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HistoryRecordEntry> {
        /**
         * <p>
         * Information about the event.
         * </p>
         * 
         * @param eventInformation
         *        Information about the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventInformation(EventInformation eventInformation);

        /**
         * <p>
         * Information about the event.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventInformation.Builder} avoiding the
         * need to create one manually via {@link EventInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventInformation.Builder#build()} is called immediately and its
         * result is passed to {@link #eventInformation(EventInformation)}.
         * 
         * @param eventInformation
         *        a consumer that will call methods on {@link EventInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventInformation(EventInformation)
         */
        default Builder eventInformation(Consumer<EventInformation.Builder> eventInformation) {
            return eventInformation(EventInformation.builder().applyMutation(eventInformation).build());
        }

        /**
         * <p>
         * The event type.
         * </p>
         * 
         * @param eventType
         *        The event type.
         * @see FleetEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetEventType
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The event type.
         * </p>
         * 
         * @param eventType
         *        The event type.
         * @see FleetEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetEventType
         */
        Builder eventType(FleetEventType eventType);

        /**
         * <p>
         * The date and time of the event, in UTC format (for example,
         * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
         * </p>
         * 
         * @param timestamp
         *        The date and time of the event, in UTC format (for example,
         *        <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);
    }

    static final class BuilderImpl implements Builder {
        private EventInformation eventInformation;

        private String eventType;

        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(HistoryRecordEntry model) {
            eventInformation(model.eventInformation);
            eventType(model.eventType);
            timestamp(model.timestamp);
        }

        public final EventInformation.Builder getEventInformation() {
            return eventInformation != null ? eventInformation.toBuilder() : null;
        }

        public final void setEventInformation(EventInformation.BuilderImpl eventInformation) {
            this.eventInformation = eventInformation != null ? eventInformation.build() : null;
        }

        @Override
        public final Builder eventInformation(EventInformation eventInformation) {
            this.eventInformation = eventInformation;
            return this;
        }

        public final String getEventType() {
            return eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(FleetEventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public HistoryRecordEntry build() {
            return new HistoryRecordEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
