/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCapacityManagerMetricDimensionsResponse extends Ec2Response implements
        ToCopyableBuilder<GetCapacityManagerMetricDimensionsResponse.Builder, GetCapacityManagerMetricDimensionsResponse> {
    private static final SdkField<List<CapacityManagerDimension>> METRIC_DIMENSION_RESULTS_FIELD = SdkField
            .<List<CapacityManagerDimension>> builder(MarshallingType.LIST)
            .memberName("MetricDimensionResults")
            .getter(getter(GetCapacityManagerMetricDimensionsResponse::metricDimensionResults))
            .setter(setter(Builder::metricDimensionResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDimensionResultSet")
                    .unmarshallLocationName("metricDimensionResultSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<CapacityManagerDimension> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapacityManagerDimension::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(GetCapacityManagerMetricDimensionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            METRIC_DIMENSION_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CapacityManagerDimension> metricDimensionResults;

    private final String nextToken;

    private GetCapacityManagerMetricDimensionsResponse(BuilderImpl builder) {
        super(builder);
        this.metricDimensionResults = builder.metricDimensionResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricDimensionResults property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMetricDimensionResults() {
        return metricDimensionResults != null && !(metricDimensionResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The available dimension combinations that have data within the specified time range and filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricDimensionResults} method.
     * </p>
     * 
     * @return The available dimension combinations that have data within the specified time range and filters.
     */
    public final List<CapacityManagerDimension> metricDimensionResults() {
        return metricDimensionResults;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is null when there are no more results to
     * return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is null when there are no more results
     *         to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricDimensionResults() ? metricDimensionResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCapacityManagerMetricDimensionsResponse)) {
            return false;
        }
        GetCapacityManagerMetricDimensionsResponse other = (GetCapacityManagerMetricDimensionsResponse) obj;
        return hasMetricDimensionResults() == other.hasMetricDimensionResults()
                && Objects.equals(metricDimensionResults(), other.metricDimensionResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCapacityManagerMetricDimensionsResponse")
                .add("MetricDimensionResults", hasMetricDimensionResults() ? metricDimensionResults() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricDimensionResults":
            return Optional.ofNullable(clazz.cast(metricDimensionResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MetricDimensionResultSet", METRIC_DIMENSION_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCapacityManagerMetricDimensionsResponse, T> g) {
        return obj -> g.apply((GetCapacityManagerMetricDimensionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCapacityManagerMetricDimensionsResponse> {
        /**
         * <p>
         * The available dimension combinations that have data within the specified time range and filters.
         * </p>
         * 
         * @param metricDimensionResults
         *        The available dimension combinations that have data within the specified time range and filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDimensionResults(Collection<CapacityManagerDimension> metricDimensionResults);

        /**
         * <p>
         * The available dimension combinations that have data within the specified time range and filters.
         * </p>
         * 
         * @param metricDimensionResults
         *        The available dimension combinations that have data within the specified time range and filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDimensionResults(CapacityManagerDimension... metricDimensionResults);

        /**
         * <p>
         * The available dimension combinations that have data within the specified time range and filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.CapacityManagerDimension.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.ec2.model.CapacityManagerDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.CapacityManagerDimension.Builder#build()} is called
         * immediately and its result is passed to {@link #metricDimensionResults(List<CapacityManagerDimension>)}.
         * 
         * @param metricDimensionResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.CapacityManagerDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricDimensionResults(java.util.Collection<CapacityManagerDimension>)
         */
        Builder metricDimensionResults(Consumer<CapacityManagerDimension.Builder>... metricDimensionResults);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is null when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is null when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<CapacityManagerDimension> metricDimensionResults = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCapacityManagerMetricDimensionsResponse model) {
            super(model);
            metricDimensionResults(model.metricDimensionResults);
            nextToken(model.nextToken);
        }

        public final List<CapacityManagerDimension.Builder> getMetricDimensionResults() {
            List<CapacityManagerDimension.Builder> result = MetricDimensionResultSetCopier
                    .copyToBuilder(this.metricDimensionResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricDimensionResults(Collection<CapacityManagerDimension.BuilderImpl> metricDimensionResults) {
            this.metricDimensionResults = MetricDimensionResultSetCopier.copyFromBuilder(metricDimensionResults);
        }

        @Override
        public final Builder metricDimensionResults(Collection<CapacityManagerDimension> metricDimensionResults) {
            this.metricDimensionResults = MetricDimensionResultSetCopier.copy(metricDimensionResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDimensionResults(CapacityManagerDimension... metricDimensionResults) {
            metricDimensionResults(Arrays.asList(metricDimensionResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDimensionResults(Consumer<CapacityManagerDimension.Builder>... metricDimensionResults) {
            metricDimensionResults(Stream.of(metricDimensionResults)
                    .map(c -> CapacityManagerDimension.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetCapacityManagerMetricDimensionsResponse build() {
            return new GetCapacityManagerMetricDimensionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
