/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteSecondarySubnetResponse extends Ec2Response implements
        ToCopyableBuilder<DeleteSecondarySubnetResponse.Builder, DeleteSecondarySubnetResponse> {
    private static final SdkField<SecondarySubnet> SECONDARY_SUBNET_FIELD = SdkField
            .<SecondarySubnet> builder(MarshallingType.SDK_POJO)
            .memberName("SecondarySubnet")
            .getter(getter(DeleteSecondarySubnetResponse::secondarySubnet))
            .setter(setter(Builder::secondarySubnet))
            .constructor(SecondarySubnet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondarySubnet")
                    .unmarshallLocationName("secondarySubnet").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(DeleteSecondarySubnetResponse::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("clientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECONDARY_SUBNET_FIELD,
            CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SecondarySubnet secondarySubnet;

    private final String clientToken;

    private DeleteSecondarySubnetResponse(BuilderImpl builder) {
        super(builder);
        this.secondarySubnet = builder.secondarySubnet;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * Information about the secondary subnet being deleted.
     * </p>
     * 
     * @return Information about the secondary subnet being deleted.
     */
    public final SecondarySubnet secondarySubnet() {
        return secondarySubnet;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier to ensure the idempotency of the request. Only returned if a client token was
     * provided in the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier to ensure the idempotency of the request. Only returned if a client
     *         token was provided in the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(secondarySubnet());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSecondarySubnetResponse)) {
            return false;
        }
        DeleteSecondarySubnetResponse other = (DeleteSecondarySubnetResponse) obj;
        return Objects.equals(secondarySubnet(), other.secondarySubnet()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteSecondarySubnetResponse").add("SecondarySubnet", secondarySubnet())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecondarySubnet":
            return Optional.ofNullable(clazz.cast(secondarySubnet()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SecondarySubnet", SECONDARY_SUBNET_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteSecondarySubnetResponse, T> g) {
        return obj -> g.apply((DeleteSecondarySubnetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DeleteSecondarySubnetResponse> {
        /**
         * <p>
         * Information about the secondary subnet being deleted.
         * </p>
         * 
         * @param secondarySubnet
         *        Information about the secondary subnet being deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondarySubnet(SecondarySubnet secondarySubnet);

        /**
         * <p>
         * Information about the secondary subnet being deleted.
         * </p>
         * This is a convenience method that creates an instance of the {@link SecondarySubnet.Builder} avoiding the
         * need to create one manually via {@link SecondarySubnet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SecondarySubnet.Builder#build()} is called immediately and its
         * result is passed to {@link #secondarySubnet(SecondarySubnet)}.
         * 
         * @param secondarySubnet
         *        a consumer that will call methods on {@link SecondarySubnet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondarySubnet(SecondarySubnet)
         */
        default Builder secondarySubnet(Consumer<SecondarySubnet.Builder> secondarySubnet) {
            return secondarySubnet(SecondarySubnet.builder().applyMutation(secondarySubnet).build());
        }

        /**
         * <p>
         * Unique, case-sensitive identifier to ensure the idempotency of the request. Only returned if a client token
         * was provided in the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier to ensure the idempotency of the request. Only returned if a client
         *        token was provided in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private SecondarySubnet secondarySubnet;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSecondarySubnetResponse model) {
            super(model);
            secondarySubnet(model.secondarySubnet);
            clientToken(model.clientToken);
        }

        public final SecondarySubnet.Builder getSecondarySubnet() {
            return secondarySubnet != null ? secondarySubnet.toBuilder() : null;
        }

        public final void setSecondarySubnet(SecondarySubnet.BuilderImpl secondarySubnet) {
            this.secondarySubnet = secondarySubnet != null ? secondarySubnet.build() : null;
        }

        @Override
        public final Builder secondarySubnet(SecondarySubnet secondarySubnet) {
            this.secondarySubnet = secondarySubnet;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public DeleteSecondarySubnetResponse build() {
            return new DeleteSecondarySubnetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
