/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIpamPrefixListResolverTargetRequest extends Ec2Request implements
        ToCopyableBuilder<CreateIpamPrefixListResolverTargetRequest.Builder, CreateIpamPrefixListResolverTargetRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(CreateIpamPrefixListResolverTargetRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> IPAM_PREFIX_LIST_RESOLVER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamPrefixListResolverId")
            .getter(getter(CreateIpamPrefixListResolverTargetRequest::ipamPrefixListResolverId))
            .setter(setter(Builder::ipamPrefixListResolverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPrefixListResolverId")
                    .unmarshallLocationName("IpamPrefixListResolverId").build()).build();

    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrefixListId")
            .getter(getter(CreateIpamPrefixListResolverTargetRequest::prefixListId))
            .setter(setter(Builder::prefixListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId")
                    .unmarshallLocationName("PrefixListId").build()).build();

    private static final SdkField<String> PREFIX_LIST_REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrefixListRegion")
            .getter(getter(CreateIpamPrefixListResolverTargetRequest::prefixListRegion))
            .setter(setter(Builder::prefixListRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListRegion")
                    .unmarshallLocationName("PrefixListRegion").build()).build();

    private static final SdkField<Long> DESIRED_VERSION_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("DesiredVersion")
            .getter(getter(CreateIpamPrefixListResolverTargetRequest::desiredVersion))
            .setter(setter(Builder::desiredVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredVersion")
                    .unmarshallLocationName("DesiredVersion").build()).build();

    private static final SdkField<Boolean> TRACK_LATEST_VERSION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TrackLatestVersion")
            .getter(getter(CreateIpamPrefixListResolverTargetRequest::trackLatestVersion))
            .setter(setter(Builder::trackLatestVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackLatestVersion")
                    .unmarshallLocationName("TrackLatestVersion").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateIpamPrefixListResolverTargetRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateIpamPrefixListResolverTargetRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            IPAM_PREFIX_LIST_RESOLVER_ID_FIELD, PREFIX_LIST_ID_FIELD, PREFIX_LIST_REGION_FIELD, DESIRED_VERSION_FIELD,
            TRACK_LATEST_VERSION_FIELD, TAG_SPECIFICATIONS_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean dryRun;

    private final String ipamPrefixListResolverId;

    private final String prefixListId;

    private final String prefixListRegion;

    private final Long desiredVersion;

    private final Boolean trackLatestVersion;

    private final List<TagSpecification> tagSpecifications;

    private final String clientToken;

    private CreateIpamPrefixListResolverTargetRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.ipamPrefixListResolverId = builder.ipamPrefixListResolverId;
        this.prefixListId = builder.prefixListId;
        this.prefixListRegion = builder.prefixListRegion;
        this.desiredVersion = builder.desiredVersion;
        this.trackLatestVersion = builder.trackLatestVersion;
        this.tagSpecifications = builder.tagSpecifications;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * A check for whether you have the required permissions for the action without actually making the request and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return A check for whether you have the required permissions for the action without actually making the request
     *         and provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the IPAM prefix list resolver that will manage the synchronization of CIDRs to the target prefix list.
     * </p>
     * 
     * @return The ID of the IPAM prefix list resolver that will manage the synchronization of CIDRs to the target
     *         prefix list.
     */
    public final String ipamPrefixListResolverId() {
        return ipamPrefixListResolverId;
    }

    /**
     * <p>
     * The ID of the managed prefix list that will be synchronized with CIDRs selected by the IPAM prefix list resolver.
     * This prefix list becomes an IPAM managed prefix list.
     * </p>
     * <p>
     * An IPAM-managed prefix list is a customer-managed prefix list that has been associated with an IPAM prefix list
     * resolver target. When a prefix list becomes IPAM managed, its CIDRs are automatically synchronized based on the
     * IPAM prefix list resolver's CIDR selection rules, and direct CIDR modifications are restricted.
     * </p>
     * 
     * @return The ID of the managed prefix list that will be synchronized with CIDRs selected by the IPAM prefix list
     *         resolver. This prefix list becomes an IPAM managed prefix list.</p>
     *         <p>
     *         An IPAM-managed prefix list is a customer-managed prefix list that has been associated with an IPAM
     *         prefix list resolver target. When a prefix list becomes IPAM managed, its CIDRs are automatically
     *         synchronized based on the IPAM prefix list resolver's CIDR selection rules, and direct CIDR modifications
     *         are restricted.
     */
    public final String prefixListId() {
        return prefixListId;
    }

    /**
     * <p>
     * The Amazon Web Services Region where the prefix list is located. This is required when referencing a prefix list
     * in a different Region.
     * </p>
     * 
     * @return The Amazon Web Services Region where the prefix list is located. This is required when referencing a
     *         prefix list in a different Region.
     */
    public final String prefixListRegion() {
        return prefixListRegion;
    }

    /**
     * <p>
     * The specific version of the prefix list to target. If not specified, the resolver will target the latest version.
     * </p>
     * 
     * @return The specific version of the prefix list to target. If not specified, the resolver will target the latest
     *         version.
     */
    public final Long desiredVersion() {
        return desiredVersion;
    }

    /**
     * <p>
     * Indicates whether the resolver target should automatically track the latest version of the prefix list. When
     * enabled, the target will always synchronize with the most current version of the prefix list.
     * </p>
     * <p>
     * Choose this for automatic updates when you want your prefix lists to stay current with infrastructure changes
     * without manual intervention.
     * </p>
     * 
     * @return Indicates whether the resolver target should automatically track the latest version of the prefix list.
     *         When enabled, the target will always synchronize with the most current version of the prefix list.</p>
     *         <p>
     *         Choose this for automatic updates when you want your prefix lists to stay current with infrastructure
     *         changes without manual intervention.
     */
    public final Boolean trackLatestVersion() {
        return trackLatestVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the IPAM prefix list resolver target during creation. Tags help you organize and manage your
     * Amazon Web Services resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to apply to the IPAM prefix list resolver target during creation. Tags help you organize and
     *         manage your Amazon Web Services resources.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring
     * idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(ipamPrefixListResolverId());
        hashCode = 31 * hashCode + Objects.hashCode(prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(prefixListRegion());
        hashCode = 31 * hashCode + Objects.hashCode(desiredVersion());
        hashCode = 31 * hashCode + Objects.hashCode(trackLatestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIpamPrefixListResolverTargetRequest)) {
            return false;
        }
        CreateIpamPrefixListResolverTargetRequest other = (CreateIpamPrefixListResolverTargetRequest) obj;
        return Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(ipamPrefixListResolverId(), other.ipamPrefixListResolverId())
                && Objects.equals(prefixListId(), other.prefixListId())
                && Objects.equals(prefixListRegion(), other.prefixListRegion())
                && Objects.equals(desiredVersion(), other.desiredVersion())
                && Objects.equals(trackLatestVersion(), other.trackLatestVersion())
                && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIpamPrefixListResolverTargetRequest").add("DryRun", dryRun())
                .add("IpamPrefixListResolverId", ipamPrefixListResolverId()).add("PrefixListId", prefixListId())
                .add("PrefixListRegion", prefixListRegion()).add("DesiredVersion", desiredVersion())
                .add("TrackLatestVersion", trackLatestVersion())
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null).add("ClientToken", clientToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "IpamPrefixListResolverId":
            return Optional.ofNullable(clazz.cast(ipamPrefixListResolverId()));
        case "PrefixListId":
            return Optional.ofNullable(clazz.cast(prefixListId()));
        case "PrefixListRegion":
            return Optional.ofNullable(clazz.cast(prefixListRegion()));
        case "DesiredVersion":
            return Optional.ofNullable(clazz.cast(desiredVersion()));
        case "TrackLatestVersion":
            return Optional.ofNullable(clazz.cast(trackLatestVersion()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("IpamPrefixListResolverId", IPAM_PREFIX_LIST_RESOLVER_ID_FIELD);
        map.put("PrefixListId", PREFIX_LIST_ID_FIELD);
        map.put("PrefixListRegion", PREFIX_LIST_REGION_FIELD);
        map.put("DesiredVersion", DESIRED_VERSION_FIELD);
        map.put("TrackLatestVersion", TRACK_LATEST_VERSION_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIpamPrefixListResolverTargetRequest, T> g) {
        return obj -> g.apply((CreateIpamPrefixListResolverTargetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateIpamPrefixListResolverTargetRequest> {
        /**
         * <p>
         * A check for whether you have the required permissions for the action without actually making the request and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        A check for whether you have the required permissions for the action without actually making the
         *        request and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the IPAM prefix list resolver that will manage the synchronization of CIDRs to the target prefix
         * list.
         * </p>
         * 
         * @param ipamPrefixListResolverId
         *        The ID of the IPAM prefix list resolver that will manage the synchronization of CIDRs to the target
         *        prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPrefixListResolverId(String ipamPrefixListResolverId);

        /**
         * <p>
         * The ID of the managed prefix list that will be synchronized with CIDRs selected by the IPAM prefix list
         * resolver. This prefix list becomes an IPAM managed prefix list.
         * </p>
         * <p>
         * An IPAM-managed prefix list is a customer-managed prefix list that has been associated with an IPAM prefix
         * list resolver target. When a prefix list becomes IPAM managed, its CIDRs are automatically synchronized based
         * on the IPAM prefix list resolver's CIDR selection rules, and direct CIDR modifications are restricted.
         * </p>
         * 
         * @param prefixListId
         *        The ID of the managed prefix list that will be synchronized with CIDRs selected by the IPAM prefix
         *        list resolver. This prefix list becomes an IPAM managed prefix list.</p>
         *        <p>
         *        An IPAM-managed prefix list is a customer-managed prefix list that has been associated with an IPAM
         *        prefix list resolver target. When a prefix list becomes IPAM managed, its CIDRs are automatically
         *        synchronized based on the IPAM prefix list resolver's CIDR selection rules, and direct CIDR
         *        modifications are restricted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListId(String prefixListId);

        /**
         * <p>
         * The Amazon Web Services Region where the prefix list is located. This is required when referencing a prefix
         * list in a different Region.
         * </p>
         * 
         * @param prefixListRegion
         *        The Amazon Web Services Region where the prefix list is located. This is required when referencing a
         *        prefix list in a different Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListRegion(String prefixListRegion);

        /**
         * <p>
         * The specific version of the prefix list to target. If not specified, the resolver will target the latest
         * version.
         * </p>
         * 
         * @param desiredVersion
         *        The specific version of the prefix list to target. If not specified, the resolver will target the
         *        latest version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredVersion(Long desiredVersion);

        /**
         * <p>
         * Indicates whether the resolver target should automatically track the latest version of the prefix list. When
         * enabled, the target will always synchronize with the most current version of the prefix list.
         * </p>
         * <p>
         * Choose this for automatic updates when you want your prefix lists to stay current with infrastructure changes
         * without manual intervention.
         * </p>
         * 
         * @param trackLatestVersion
         *        Indicates whether the resolver target should automatically track the latest version of the prefix
         *        list. When enabled, the target will always synchronize with the most current version of the prefix
         *        list.</p>
         *        <p>
         *        Choose this for automatic updates when you want your prefix lists to stay current with infrastructure
         *        changes without manual intervention.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackLatestVersion(Boolean trackLatestVersion);

        /**
         * <p>
         * The tags to apply to the IPAM prefix list resolver target during creation. Tags help you organize and manage
         * your Amazon Web Services resources.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the IPAM prefix list resolver target during creation. Tags help you organize and
         *        manage your Amazon Web Services resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the IPAM prefix list resolver target during creation. Tags help you organize and manage
         * your Amazon Web Services resources.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the IPAM prefix list resolver target during creation. Tags help you organize and
         *        manage your Amazon Web Services resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the IPAM prefix list resolver target during creation. Tags help you organize and manage
         * your Amazon Web Services resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring
         * idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring
         *        idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String ipamPrefixListResolverId;

        private String prefixListId;

        private String prefixListRegion;

        private Long desiredVersion;

        private Boolean trackLatestVersion;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIpamPrefixListResolverTargetRequest model) {
            super(model);
            dryRun(model.dryRun);
            ipamPrefixListResolverId(model.ipamPrefixListResolverId);
            prefixListId(model.prefixListId);
            prefixListRegion(model.prefixListRegion);
            desiredVersion(model.desiredVersion);
            trackLatestVersion(model.trackLatestVersion);
            tagSpecifications(model.tagSpecifications);
            clientToken(model.clientToken);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getIpamPrefixListResolverId() {
            return ipamPrefixListResolverId;
        }

        public final void setIpamPrefixListResolverId(String ipamPrefixListResolverId) {
            this.ipamPrefixListResolverId = ipamPrefixListResolverId;
        }

        @Override
        public final Builder ipamPrefixListResolverId(String ipamPrefixListResolverId) {
            this.ipamPrefixListResolverId = ipamPrefixListResolverId;
            return this;
        }

        public final String getPrefixListId() {
            return prefixListId;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final String getPrefixListRegion() {
            return prefixListRegion;
        }

        public final void setPrefixListRegion(String prefixListRegion) {
            this.prefixListRegion = prefixListRegion;
        }

        @Override
        public final Builder prefixListRegion(String prefixListRegion) {
            this.prefixListRegion = prefixListRegion;
            return this;
        }

        public final Long getDesiredVersion() {
            return desiredVersion;
        }

        public final void setDesiredVersion(Long desiredVersion) {
            this.desiredVersion = desiredVersion;
        }

        @Override
        public final Builder desiredVersion(Long desiredVersion) {
            this.desiredVersion = desiredVersion;
            return this;
        }

        public final Boolean getTrackLatestVersion() {
            return trackLatestVersion;
        }

        public final void setTrackLatestVersion(Boolean trackLatestVersion) {
            this.trackLatestVersion = trackLatestVersion;
        }

        @Override
        public final Builder trackLatestVersion(Boolean trackLatestVersion) {
            this.trackLatestVersion = trackLatestVersion;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIpamPrefixListResolverTargetRequest build() {
            return new CreateIpamPrefixListResolverTargetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
