/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The CPU options for the instance. Both the core count and threads per core must be specified in the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CpuOptionsRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<CpuOptionsRequest.Builder, CpuOptionsRequest> {
    private static final SdkField<Integer> CORE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("CoreCount")
            .getter(getter(CpuOptionsRequest::coreCount))
            .setter(setter(Builder::coreCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreCount")
                    .unmarshallLocationName("CoreCount").build()).build();

    private static final SdkField<Integer> THREADS_PER_CORE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ThreadsPerCore")
            .getter(getter(CpuOptionsRequest::threadsPerCore))
            .setter(setter(Builder::threadsPerCore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreadsPerCore")
                    .unmarshallLocationName("ThreadsPerCore").build()).build();

    private static final SdkField<String> AMD_SEV_SNP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AmdSevSnp")
            .getter(getter(CpuOptionsRequest::amdSevSnpAsString))
            .setter(setter(Builder::amdSevSnp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmdSevSnp")
                    .unmarshallLocationName("AmdSevSnp").build()).build();

    private static final SdkField<String> NESTED_VIRTUALIZATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NestedVirtualization")
            .getter(getter(CpuOptionsRequest::nestedVirtualizationAsString))
            .setter(setter(Builder::nestedVirtualization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NestedVirtualization")
                    .unmarshallLocationName("NestedVirtualization").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_COUNT_FIELD,
            THREADS_PER_CORE_FIELD, AMD_SEV_SNP_FIELD, NESTED_VIRTUALIZATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer coreCount;

    private final Integer threadsPerCore;

    private final String amdSevSnp;

    private final String nestedVirtualization;

    private CpuOptionsRequest(BuilderImpl builder) {
        this.coreCount = builder.coreCount;
        this.threadsPerCore = builder.threadsPerCore;
        this.amdSevSnp = builder.amdSevSnp;
        this.nestedVirtualization = builder.nestedVirtualization;
    }

    /**
     * <p>
     * The number of CPU cores for the instance.
     * </p>
     * 
     * @return The number of CPU cores for the instance.
     */
    public final Integer coreCount() {
        return coreCount;
    }

    /**
     * <p>
     * The number of threads per CPU core. To disable multithreading for the instance, specify a value of <code>1</code>
     * . Otherwise, specify the default value of <code>2</code>.
     * </p>
     * 
     * @return The number of threads per CPU core. To disable multithreading for the instance, specify a value of
     *         <code>1</code>. Otherwise, specify the default value of <code>2</code>.
     */
    public final Integer threadsPerCore() {
        return threadsPerCore;
    }

    /**
     * <p>
     * Indicates whether to enable the instance for AMD SEV-SNP. AMD SEV-SNP is supported with M6a, R6a, and C6a
     * instance types only. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/sev-snp.html">AMD SEV-SNP</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #amdSevSnp} will
     * return {@link AmdSevSnpSpecification#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #amdSevSnpAsString}.
     * </p>
     * 
     * @return Indicates whether to enable the instance for AMD SEV-SNP. AMD SEV-SNP is supported with M6a, R6a, and C6a
     *         instance types only. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/sev-snp.html">AMD SEV-SNP</a>.
     * @see AmdSevSnpSpecification
     */
    public final AmdSevSnpSpecification amdSevSnp() {
        return AmdSevSnpSpecification.fromValue(amdSevSnp);
    }

    /**
     * <p>
     * Indicates whether to enable the instance for AMD SEV-SNP. AMD SEV-SNP is supported with M6a, R6a, and C6a
     * instance types only. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/sev-snp.html">AMD SEV-SNP</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #amdSevSnp} will
     * return {@link AmdSevSnpSpecification#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #amdSevSnpAsString}.
     * </p>
     * 
     * @return Indicates whether to enable the instance for AMD SEV-SNP. AMD SEV-SNP is supported with M6a, R6a, and C6a
     *         instance types only. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/sev-snp.html">AMD SEV-SNP</a>.
     * @see AmdSevSnpSpecification
     */
    public final String amdSevSnpAsString() {
        return amdSevSnp;
    }

    /**
     * <p>
     * Indicates whether to enable the instance for nested virtualization. Nested virtualization is supported only on
     * 8th generation Intel-based instance types (c8i, m8i, r8i, and their flex variants). When nested virtualization is
     * enabled, Virtual Secure Mode (VSM) is automatically disabled for the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nestedVirtualization} will return {@link NestedVirtualizationSpecification#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #nestedVirtualizationAsString}.
     * </p>
     * 
     * @return Indicates whether to enable the instance for nested virtualization. Nested virtualization is supported
     *         only on 8th generation Intel-based instance types (c8i, m8i, r8i, and their flex variants). When nested
     *         virtualization is enabled, Virtual Secure Mode (VSM) is automatically disabled for the instance.
     * @see NestedVirtualizationSpecification
     */
    public final NestedVirtualizationSpecification nestedVirtualization() {
        return NestedVirtualizationSpecification.fromValue(nestedVirtualization);
    }

    /**
     * <p>
     * Indicates whether to enable the instance for nested virtualization. Nested virtualization is supported only on
     * 8th generation Intel-based instance types (c8i, m8i, r8i, and their flex variants). When nested virtualization is
     * enabled, Virtual Secure Mode (VSM) is automatically disabled for the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nestedVirtualization} will return {@link NestedVirtualizationSpecification#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #nestedVirtualizationAsString}.
     * </p>
     * 
     * @return Indicates whether to enable the instance for nested virtualization. Nested virtualization is supported
     *         only on 8th generation Intel-based instance types (c8i, m8i, r8i, and their flex variants). When nested
     *         virtualization is enabled, Virtual Secure Mode (VSM) is automatically disabled for the instance.
     * @see NestedVirtualizationSpecification
     */
    public final String nestedVirtualizationAsString() {
        return nestedVirtualization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(coreCount());
        hashCode = 31 * hashCode + Objects.hashCode(threadsPerCore());
        hashCode = 31 * hashCode + Objects.hashCode(amdSevSnpAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nestedVirtualizationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CpuOptionsRequest)) {
            return false;
        }
        CpuOptionsRequest other = (CpuOptionsRequest) obj;
        return Objects.equals(coreCount(), other.coreCount()) && Objects.equals(threadsPerCore(), other.threadsPerCore())
                && Objects.equals(amdSevSnpAsString(), other.amdSevSnpAsString())
                && Objects.equals(nestedVirtualizationAsString(), other.nestedVirtualizationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CpuOptionsRequest").add("CoreCount", coreCount()).add("ThreadsPerCore", threadsPerCore())
                .add("AmdSevSnp", amdSevSnpAsString()).add("NestedVirtualization", nestedVirtualizationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoreCount":
            return Optional.ofNullable(clazz.cast(coreCount()));
        case "ThreadsPerCore":
            return Optional.ofNullable(clazz.cast(threadsPerCore()));
        case "AmdSevSnp":
            return Optional.ofNullable(clazz.cast(amdSevSnpAsString()));
        case "NestedVirtualization":
            return Optional.ofNullable(clazz.cast(nestedVirtualizationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CoreCount", CORE_COUNT_FIELD);
        map.put("ThreadsPerCore", THREADS_PER_CORE_FIELD);
        map.put("AmdSevSnp", AMD_SEV_SNP_FIELD);
        map.put("NestedVirtualization", NESTED_VIRTUALIZATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CpuOptionsRequest, T> g) {
        return obj -> g.apply((CpuOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CpuOptionsRequest> {
        /**
         * <p>
         * The number of CPU cores for the instance.
         * </p>
         * 
         * @param coreCount
         *        The number of CPU cores for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreCount(Integer coreCount);

        /**
         * <p>
         * The number of threads per CPU core. To disable multithreading for the instance, specify a value of
         * <code>1</code>. Otherwise, specify the default value of <code>2</code>.
         * </p>
         * 
         * @param threadsPerCore
         *        The number of threads per CPU core. To disable multithreading for the instance, specify a value of
         *        <code>1</code>. Otherwise, specify the default value of <code>2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threadsPerCore(Integer threadsPerCore);

        /**
         * <p>
         * Indicates whether to enable the instance for AMD SEV-SNP. AMD SEV-SNP is supported with M6a, R6a, and C6a
         * instance types only. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/sev-snp.html">AMD SEV-SNP</a>.
         * </p>
         * 
         * @param amdSevSnp
         *        Indicates whether to enable the instance for AMD SEV-SNP. AMD SEV-SNP is supported with M6a, R6a, and
         *        C6a instance types only. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/sev-snp.html">AMD SEV-SNP</a>.
         * @see AmdSevSnpSpecification
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AmdSevSnpSpecification
         */
        Builder amdSevSnp(String amdSevSnp);

        /**
         * <p>
         * Indicates whether to enable the instance for AMD SEV-SNP. AMD SEV-SNP is supported with M6a, R6a, and C6a
         * instance types only. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/sev-snp.html">AMD SEV-SNP</a>.
         * </p>
         * 
         * @param amdSevSnp
         *        Indicates whether to enable the instance for AMD SEV-SNP. AMD SEV-SNP is supported with M6a, R6a, and
         *        C6a instance types only. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/sev-snp.html">AMD SEV-SNP</a>.
         * @see AmdSevSnpSpecification
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AmdSevSnpSpecification
         */
        Builder amdSevSnp(AmdSevSnpSpecification amdSevSnp);

        /**
         * <p>
         * Indicates whether to enable the instance for nested virtualization. Nested virtualization is supported only
         * on 8th generation Intel-based instance types (c8i, m8i, r8i, and their flex variants). When nested
         * virtualization is enabled, Virtual Secure Mode (VSM) is automatically disabled for the instance.
         * </p>
         * 
         * @param nestedVirtualization
         *        Indicates whether to enable the instance for nested virtualization. Nested virtualization is supported
         *        only on 8th generation Intel-based instance types (c8i, m8i, r8i, and their flex variants). When
         *        nested virtualization is enabled, Virtual Secure Mode (VSM) is automatically disabled for the
         *        instance.
         * @see NestedVirtualizationSpecification
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NestedVirtualizationSpecification
         */
        Builder nestedVirtualization(String nestedVirtualization);

        /**
         * <p>
         * Indicates whether to enable the instance for nested virtualization. Nested virtualization is supported only
         * on 8th generation Intel-based instance types (c8i, m8i, r8i, and their flex variants). When nested
         * virtualization is enabled, Virtual Secure Mode (VSM) is automatically disabled for the instance.
         * </p>
         * 
         * @param nestedVirtualization
         *        Indicates whether to enable the instance for nested virtualization. Nested virtualization is supported
         *        only on 8th generation Intel-based instance types (c8i, m8i, r8i, and their flex variants). When
         *        nested virtualization is enabled, Virtual Secure Mode (VSM) is automatically disabled for the
         *        instance.
         * @see NestedVirtualizationSpecification
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NestedVirtualizationSpecification
         */
        Builder nestedVirtualization(NestedVirtualizationSpecification nestedVirtualization);
    }

    static final class BuilderImpl implements Builder {
        private Integer coreCount;

        private Integer threadsPerCore;

        private String amdSevSnp;

        private String nestedVirtualization;

        private BuilderImpl() {
        }

        private BuilderImpl(CpuOptionsRequest model) {
            coreCount(model.coreCount);
            threadsPerCore(model.threadsPerCore);
            amdSevSnp(model.amdSevSnp);
            nestedVirtualization(model.nestedVirtualization);
        }

        public final Integer getCoreCount() {
            return coreCount;
        }

        public final void setCoreCount(Integer coreCount) {
            this.coreCount = coreCount;
        }

        @Override
        public final Builder coreCount(Integer coreCount) {
            this.coreCount = coreCount;
            return this;
        }

        public final Integer getThreadsPerCore() {
            return threadsPerCore;
        }

        public final void setThreadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
        }

        @Override
        public final Builder threadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
            return this;
        }

        public final String getAmdSevSnp() {
            return amdSevSnp;
        }

        public final void setAmdSevSnp(String amdSevSnp) {
            this.amdSevSnp = amdSevSnp;
        }

        @Override
        public final Builder amdSevSnp(String amdSevSnp) {
            this.amdSevSnp = amdSevSnp;
            return this;
        }

        @Override
        public final Builder amdSevSnp(AmdSevSnpSpecification amdSevSnp) {
            this.amdSevSnp(amdSevSnp == null ? null : amdSevSnp.toString());
            return this;
        }

        public final String getNestedVirtualization() {
            return nestedVirtualization;
        }

        public final void setNestedVirtualization(String nestedVirtualization) {
            this.nestedVirtualization = nestedVirtualization;
        }

        @Override
        public final Builder nestedVirtualization(String nestedVirtualization) {
            this.nestedVirtualization = nestedVirtualization;
            return this;
        }

        @Override
        public final Builder nestedVirtualization(NestedVirtualizationSpecification nestedVirtualization) {
            this.nestedVirtualization(nestedVirtualization == null ? null : nestedVirtualization.toString());
            return this;
        }

        @Override
        public CpuOptionsRequest build() {
            return new CpuOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
