/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a connection notification for a VPC endpoint or VPC endpoint service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionNotification implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionNotification.Builder, ConnectionNotification> {
    private static final SdkField<String> CONNECTION_NOTIFICATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConnectionNotificationId")
            .getter(getter(ConnectionNotification::connectionNotificationId))
            .setter(setter(Builder::connectionNotificationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionNotificationId")
                    .unmarshallLocationName("connectionNotificationId").build()).build();

    private static final SdkField<String> SERVICE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServiceId")
            .getter(getter(ConnectionNotification::serviceId))
            .setter(setter(Builder::serviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId")
                    .unmarshallLocationName("serviceId").build()).build();

    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointId")
            .getter(getter(ConnectionNotification::vpcEndpointId))
            .setter(setter(Builder::vpcEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId")
                    .unmarshallLocationName("vpcEndpointId").build()).build();

    private static final SdkField<String> CONNECTION_NOTIFICATION_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConnectionNotificationType")
            .getter(getter(ConnectionNotification::connectionNotificationTypeAsString))
            .setter(setter(Builder::connectionNotificationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionNotificationType")
                    .unmarshallLocationName("connectionNotificationType").build()).build();

    private static final SdkField<String> CONNECTION_NOTIFICATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConnectionNotificationArn")
            .getter(getter(ConnectionNotification::connectionNotificationArn))
            .setter(setter(Builder::connectionNotificationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionNotificationArn")
                    .unmarshallLocationName("connectionNotificationArn").build()).build();

    private static final SdkField<List<String>> CONNECTION_EVENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ConnectionEvents")
            .getter(getter(ConnectionNotification::connectionEvents))
            .setter(setter(Builder::connectionEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionEvents")
                    .unmarshallLocationName("connectionEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> CONNECTION_NOTIFICATION_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConnectionNotificationState")
            .getter(getter(ConnectionNotification::connectionNotificationStateAsString))
            .setter(setter(Builder::connectionNotificationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionNotificationState")
                    .unmarshallLocationName("connectionNotificationState").build()).build();

    private static final SdkField<String> SERVICE_REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServiceRegion")
            .getter(getter(ConnectionNotification::serviceRegion))
            .setter(setter(Builder::serviceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRegion")
                    .unmarshallLocationName("serviceRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CONNECTION_NOTIFICATION_ID_FIELD, SERVICE_ID_FIELD, VPC_ENDPOINT_ID_FIELD,
                    CONNECTION_NOTIFICATION_TYPE_FIELD, CONNECTION_NOTIFICATION_ARN_FIELD, CONNECTION_EVENTS_FIELD,
                    CONNECTION_NOTIFICATION_STATE_FIELD, SERVICE_REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String connectionNotificationId;

    private final String serviceId;

    private final String vpcEndpointId;

    private final String connectionNotificationType;

    private final String connectionNotificationArn;

    private final List<String> connectionEvents;

    private final String connectionNotificationState;

    private final String serviceRegion;

    private ConnectionNotification(BuilderImpl builder) {
        this.connectionNotificationId = builder.connectionNotificationId;
        this.serviceId = builder.serviceId;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.connectionNotificationType = builder.connectionNotificationType;
        this.connectionNotificationArn = builder.connectionNotificationArn;
        this.connectionEvents = builder.connectionEvents;
        this.connectionNotificationState = builder.connectionNotificationState;
        this.serviceRegion = builder.serviceRegion;
    }

    /**
     * <p>
     * The ID of the notification.
     * </p>
     * 
     * @return The ID of the notification.
     */
    public final String connectionNotificationId() {
        return connectionNotificationId;
    }

    /**
     * <p>
     * The ID of the endpoint service.
     * </p>
     * 
     * @return The ID of the endpoint service.
     */
    public final String serviceId() {
        return serviceId;
    }

    /**
     * <p>
     * The ID of the VPC endpoint.
     * </p>
     * 
     * @return The ID of the VPC endpoint.
     */
    public final String vpcEndpointId() {
        return vpcEndpointId;
    }

    /**
     * <p>
     * The type of notification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #connectionNotificationType} will return {@link ConnectionNotificationType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #connectionNotificationTypeAsString}.
     * </p>
     * 
     * @return The type of notification.
     * @see ConnectionNotificationType
     */
    public final ConnectionNotificationType connectionNotificationType() {
        return ConnectionNotificationType.fromValue(connectionNotificationType);
    }

    /**
     * <p>
     * The type of notification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #connectionNotificationType} will return {@link ConnectionNotificationType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #connectionNotificationTypeAsString}.
     * </p>
     * 
     * @return The type of notification.
     * @see ConnectionNotificationType
     */
    public final String connectionNotificationTypeAsString() {
        return connectionNotificationType;
    }

    /**
     * <p>
     * The ARN of the SNS topic for the notification.
     * </p>
     * 
     * @return The ARN of the SNS topic for the notification.
     */
    public final String connectionNotificationArn() {
        return connectionNotificationArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectionEvents property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConnectionEvents() {
        return connectionEvents != null && !(connectionEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The events for the notification. Valid values are <code>Accept</code>, <code>Connect</code>, <code>Delete</code>,
     * and <code>Reject</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectionEvents} method.
     * </p>
     * 
     * @return The events for the notification. Valid values are <code>Accept</code>, <code>Connect</code>,
     *         <code>Delete</code>, and <code>Reject</code>.
     */
    public final List<String> connectionEvents() {
        return connectionEvents;
    }

    /**
     * <p>
     * The state of the notification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #connectionNotificationState} will return {@link ConnectionNotificationState#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #connectionNotificationStateAsString}.
     * </p>
     * 
     * @return The state of the notification.
     * @see ConnectionNotificationState
     */
    public final ConnectionNotificationState connectionNotificationState() {
        return ConnectionNotificationState.fromValue(connectionNotificationState);
    }

    /**
     * <p>
     * The state of the notification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #connectionNotificationState} will return {@link ConnectionNotificationState#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #connectionNotificationStateAsString}.
     * </p>
     * 
     * @return The state of the notification.
     * @see ConnectionNotificationState
     */
    public final String connectionNotificationStateAsString() {
        return connectionNotificationState;
    }

    /**
     * <p>
     * The Region for the endpoint service.
     * </p>
     * 
     * @return The Region for the endpoint service.
     */
    public final String serviceRegion() {
        return serviceRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectionNotificationId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(connectionNotificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectionNotificationArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectionEvents() ? connectionEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectionNotificationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionNotification)) {
            return false;
        }
        ConnectionNotification other = (ConnectionNotification) obj;
        return Objects.equals(connectionNotificationId(), other.connectionNotificationId())
                && Objects.equals(serviceId(), other.serviceId()) && Objects.equals(vpcEndpointId(), other.vpcEndpointId())
                && Objects.equals(connectionNotificationTypeAsString(), other.connectionNotificationTypeAsString())
                && Objects.equals(connectionNotificationArn(), other.connectionNotificationArn())
                && hasConnectionEvents() == other.hasConnectionEvents()
                && Objects.equals(connectionEvents(), other.connectionEvents())
                && Objects.equals(connectionNotificationStateAsString(), other.connectionNotificationStateAsString())
                && Objects.equals(serviceRegion(), other.serviceRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectionNotification").add("ConnectionNotificationId", connectionNotificationId())
                .add("ServiceId", serviceId()).add("VpcEndpointId", vpcEndpointId())
                .add("ConnectionNotificationType", connectionNotificationTypeAsString())
                .add("ConnectionNotificationArn", connectionNotificationArn())
                .add("ConnectionEvents", hasConnectionEvents() ? connectionEvents() : null)
                .add("ConnectionNotificationState", connectionNotificationStateAsString()).add("ServiceRegion", serviceRegion())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionNotificationId":
            return Optional.ofNullable(clazz.cast(connectionNotificationId()));
        case "ServiceId":
            return Optional.ofNullable(clazz.cast(serviceId()));
        case "VpcEndpointId":
            return Optional.ofNullable(clazz.cast(vpcEndpointId()));
        case "ConnectionNotificationType":
            return Optional.ofNullable(clazz.cast(connectionNotificationTypeAsString()));
        case "ConnectionNotificationArn":
            return Optional.ofNullable(clazz.cast(connectionNotificationArn()));
        case "ConnectionEvents":
            return Optional.ofNullable(clazz.cast(connectionEvents()));
        case "ConnectionNotificationState":
            return Optional.ofNullable(clazz.cast(connectionNotificationStateAsString()));
        case "ServiceRegion":
            return Optional.ofNullable(clazz.cast(serviceRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectionNotificationId", CONNECTION_NOTIFICATION_ID_FIELD);
        map.put("ServiceId", SERVICE_ID_FIELD);
        map.put("VpcEndpointId", VPC_ENDPOINT_ID_FIELD);
        map.put("ConnectionNotificationType", CONNECTION_NOTIFICATION_TYPE_FIELD);
        map.put("ConnectionNotificationArn", CONNECTION_NOTIFICATION_ARN_FIELD);
        map.put("ConnectionEvents", CONNECTION_EVENTS_FIELD);
        map.put("ConnectionNotificationState", CONNECTION_NOTIFICATION_STATE_FIELD);
        map.put("ServiceRegion", SERVICE_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionNotification, T> g) {
        return obj -> g.apply((ConnectionNotification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionNotification> {
        /**
         * <p>
         * The ID of the notification.
         * </p>
         * 
         * @param connectionNotificationId
         *        The ID of the notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionNotificationId(String connectionNotificationId);

        /**
         * <p>
         * The ID of the endpoint service.
         * </p>
         * 
         * @param serviceId
         *        The ID of the endpoint service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceId(String serviceId);

        /**
         * <p>
         * The ID of the VPC endpoint.
         * </p>
         * 
         * @param vpcEndpointId
         *        The ID of the VPC endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointId(String vpcEndpointId);

        /**
         * <p>
         * The type of notification.
         * </p>
         * 
         * @param connectionNotificationType
         *        The type of notification.
         * @see ConnectionNotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionNotificationType
         */
        Builder connectionNotificationType(String connectionNotificationType);

        /**
         * <p>
         * The type of notification.
         * </p>
         * 
         * @param connectionNotificationType
         *        The type of notification.
         * @see ConnectionNotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionNotificationType
         */
        Builder connectionNotificationType(ConnectionNotificationType connectionNotificationType);

        /**
         * <p>
         * The ARN of the SNS topic for the notification.
         * </p>
         * 
         * @param connectionNotificationArn
         *        The ARN of the SNS topic for the notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionNotificationArn(String connectionNotificationArn);

        /**
         * <p>
         * The events for the notification. Valid values are <code>Accept</code>, <code>Connect</code>,
         * <code>Delete</code>, and <code>Reject</code>.
         * </p>
         * 
         * @param connectionEvents
         *        The events for the notification. Valid values are <code>Accept</code>, <code>Connect</code>,
         *        <code>Delete</code>, and <code>Reject</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionEvents(Collection<String> connectionEvents);

        /**
         * <p>
         * The events for the notification. Valid values are <code>Accept</code>, <code>Connect</code>,
         * <code>Delete</code>, and <code>Reject</code>.
         * </p>
         * 
         * @param connectionEvents
         *        The events for the notification. Valid values are <code>Accept</code>, <code>Connect</code>,
         *        <code>Delete</code>, and <code>Reject</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionEvents(String... connectionEvents);

        /**
         * <p>
         * The state of the notification.
         * </p>
         * 
         * @param connectionNotificationState
         *        The state of the notification.
         * @see ConnectionNotificationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionNotificationState
         */
        Builder connectionNotificationState(String connectionNotificationState);

        /**
         * <p>
         * The state of the notification.
         * </p>
         * 
         * @param connectionNotificationState
         *        The state of the notification.
         * @see ConnectionNotificationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionNotificationState
         */
        Builder connectionNotificationState(ConnectionNotificationState connectionNotificationState);

        /**
         * <p>
         * The Region for the endpoint service.
         * </p>
         * 
         * @param serviceRegion
         *        The Region for the endpoint service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRegion(String serviceRegion);
    }

    static final class BuilderImpl implements Builder {
        private String connectionNotificationId;

        private String serviceId;

        private String vpcEndpointId;

        private String connectionNotificationType;

        private String connectionNotificationArn;

        private List<String> connectionEvents = DefaultSdkAutoConstructList.getInstance();

        private String connectionNotificationState;

        private String serviceRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionNotification model) {
            connectionNotificationId(model.connectionNotificationId);
            serviceId(model.serviceId);
            vpcEndpointId(model.vpcEndpointId);
            connectionNotificationType(model.connectionNotificationType);
            connectionNotificationArn(model.connectionNotificationArn);
            connectionEvents(model.connectionEvents);
            connectionNotificationState(model.connectionNotificationState);
            serviceRegion(model.serviceRegion);
        }

        public final String getConnectionNotificationId() {
            return connectionNotificationId;
        }

        public final void setConnectionNotificationId(String connectionNotificationId) {
            this.connectionNotificationId = connectionNotificationId;
        }

        @Override
        public final Builder connectionNotificationId(String connectionNotificationId) {
            this.connectionNotificationId = connectionNotificationId;
            return this;
        }

        public final String getServiceId() {
            return serviceId;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final String getVpcEndpointId() {
            return vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final String getConnectionNotificationType() {
            return connectionNotificationType;
        }

        public final void setConnectionNotificationType(String connectionNotificationType) {
            this.connectionNotificationType = connectionNotificationType;
        }

        @Override
        public final Builder connectionNotificationType(String connectionNotificationType) {
            this.connectionNotificationType = connectionNotificationType;
            return this;
        }

        @Override
        public final Builder connectionNotificationType(ConnectionNotificationType connectionNotificationType) {
            this.connectionNotificationType(connectionNotificationType == null ? null : connectionNotificationType.toString());
            return this;
        }

        public final String getConnectionNotificationArn() {
            return connectionNotificationArn;
        }

        public final void setConnectionNotificationArn(String connectionNotificationArn) {
            this.connectionNotificationArn = connectionNotificationArn;
        }

        @Override
        public final Builder connectionNotificationArn(String connectionNotificationArn) {
            this.connectionNotificationArn = connectionNotificationArn;
            return this;
        }

        public final Collection<String> getConnectionEvents() {
            if (connectionEvents instanceof SdkAutoConstructList) {
                return null;
            }
            return connectionEvents;
        }

        public final void setConnectionEvents(Collection<String> connectionEvents) {
            this.connectionEvents = ValueStringListCopier.copy(connectionEvents);
        }

        @Override
        public final Builder connectionEvents(Collection<String> connectionEvents) {
            this.connectionEvents = ValueStringListCopier.copy(connectionEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionEvents(String... connectionEvents) {
            connectionEvents(Arrays.asList(connectionEvents));
            return this;
        }

        public final String getConnectionNotificationState() {
            return connectionNotificationState;
        }

        public final void setConnectionNotificationState(String connectionNotificationState) {
            this.connectionNotificationState = connectionNotificationState;
        }

        @Override
        public final Builder connectionNotificationState(String connectionNotificationState) {
            this.connectionNotificationState = connectionNotificationState;
            return this;
        }

        @Override
        public final Builder connectionNotificationState(ConnectionNotificationState connectionNotificationState) {
            this.connectionNotificationState(connectionNotificationState == null ? null : connectionNotificationState.toString());
            return this;
        }

        public final String getServiceRegion() {
            return serviceRegion;
        }

        public final void setServiceRegion(String serviceRegion) {
            this.serviceRegion = serviceRegion;
        }

        @Override
        public final Builder serviceRegion(String serviceRegion) {
            this.serviceRegion = serviceRegion;
            return this;
        }

        @Override
        public ConnectionNotification build() {
            return new ConnectionNotification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
