/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.GetIpamPrefixListResolverVersionsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamPrefixListResolverVersionsResponse;
import software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverVersion;

public class GetIpamPrefixListResolverVersionsIterable
implements SdkIterable<GetIpamPrefixListResolverVersionsResponse> {
    private final Ec2Client client;
    private final GetIpamPrefixListResolverVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetIpamPrefixListResolverVersionsIterable(Ec2Client client, GetIpamPrefixListResolverVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetIpamPrefixListResolverVersionsResponseFetcher();
    }

    public Iterator<GetIpamPrefixListResolverVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IpamPrefixListResolverVersion> ipamPrefixListResolverVersions() {
        Function<GetIpamPrefixListResolverVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ipamPrefixListResolverVersions() != null) {
                return response.ipamPrefixListResolverVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetIpamPrefixListResolverVersionsResponseFetcher
    implements SyncPageFetcher<GetIpamPrefixListResolverVersionsResponse> {
        private GetIpamPrefixListResolverVersionsResponseFetcher() {
        }

        public boolean hasNextPage(GetIpamPrefixListResolverVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetIpamPrefixListResolverVersionsResponse nextPage(GetIpamPrefixListResolverVersionsResponse previousPage) {
            if (previousPage == null) {
                return GetIpamPrefixListResolverVersionsIterable.this.client.getIpamPrefixListResolverVersions(GetIpamPrefixListResolverVersionsIterable.this.firstRequest);
            }
            return GetIpamPrefixListResolverVersionsIterable.this.client.getIpamPrefixListResolverVersions((GetIpamPrefixListResolverVersionsRequest)((Object)GetIpamPrefixListResolverVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

