/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.VolumeRecycleBinInfo;
import software.amazon.awssdk.services.ec2.model.VolumeRecycleBinInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVolumesInRecycleBinResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, ListVolumesInRecycleBinResponse> {
    private static final SdkField<List<VolumeRecycleBinInfo>> VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Volumes").getter(ListVolumesInRecycleBinResponse.getter(ListVolumesInRecycleBinResponse::volumes)).setter(ListVolumesInRecycleBinResponse.setter(Builder::volumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSet").unmarshallLocationName("volumeSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VolumeRecycleBinInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListVolumesInRecycleBinResponse.getter(ListVolumesInRecycleBinResponse::nextToken)).setter(ListVolumesInRecycleBinResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUMES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListVolumesInRecycleBinResponse.memberNameToFieldInitializer();
    private final List<VolumeRecycleBinInfo> volumes;
    private final String nextToken;

    private ListVolumesInRecycleBinResponse(BuilderImpl builder) {
        super(builder);
        this.volumes = builder.volumes;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasVolumes() {
        return this.volumes != null && !(this.volumes instanceof SdkAutoConstructList);
    }

    public final List<VolumeRecycleBinInfo> volumes() {
        return this.volumes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumes() ? this.volumes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVolumesInRecycleBinResponse)) {
            return false;
        }
        ListVolumesInRecycleBinResponse other = (ListVolumesInRecycleBinResponse)((Object)obj);
        return this.hasVolumes() == other.hasVolumes() && Objects.equals(this.volumes(), other.volumes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListVolumesInRecycleBinResponse").add("Volumes", this.hasVolumes() ? this.volumes() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Volumes": {
                return Optional.ofNullable(clazz.cast(this.volumes()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VolumeSet", VOLUMES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListVolumesInRecycleBinResponse, T> g) {
        return obj -> g.apply((ListVolumesInRecycleBinResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<VolumeRecycleBinInfo> volumes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVolumesInRecycleBinResponse model) {
            super(model);
            this.volumes(model.volumes);
            this.nextToken(model.nextToken);
        }

        public final List<VolumeRecycleBinInfo.Builder> getVolumes() {
            List<VolumeRecycleBinInfo.Builder> result = VolumeRecycleBinInfoListCopier.copyToBuilder(this.volumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumes(Collection<VolumeRecycleBinInfo.BuilderImpl> volumes) {
            this.volumes = VolumeRecycleBinInfoListCopier.copyFromBuilder(volumes);
        }

        @Override
        public final Builder volumes(Collection<VolumeRecycleBinInfo> volumes) {
            this.volumes = VolumeRecycleBinInfoListCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(VolumeRecycleBinInfo ... volumes) {
            this.volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<VolumeRecycleBinInfo.Builder> ... volumes) {
            this.volumes(Stream.of(volumes).map(c -> (VolumeRecycleBinInfo)((VolumeRecycleBinInfo.Builder)VolumeRecycleBinInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListVolumesInRecycleBinResponse build() {
            return new ListVolumesInRecycleBinResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVolumesInRecycleBinResponse> {
        public Builder volumes(Collection<VolumeRecycleBinInfo> var1);

        public Builder volumes(VolumeRecycleBinInfo ... var1);

        public Builder volumes(Consumer<VolumeRecycleBinInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

