/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the exclusion configurations for various resource types in VPC Encryption Control.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-encryption-controls.html">Enforce VPC encryption in
 * transit</a> in the <i>Amazon VPC User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcEncryptionControlExclusions implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcEncryptionControlExclusions.Builder, VpcEncryptionControlExclusions> {
    private static final SdkField<VpcEncryptionControlExclusion> INTERNET_GATEWAY_FIELD = SdkField
            .<VpcEncryptionControlExclusion> builder(MarshallingType.SDK_POJO)
            .memberName("InternetGateway")
            .getter(getter(VpcEncryptionControlExclusions::internetGateway))
            .setter(setter(Builder::internetGateway))
            .constructor(VpcEncryptionControlExclusion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetGateway")
                    .unmarshallLocationName("internetGateway").build()).build();

    private static final SdkField<VpcEncryptionControlExclusion> EGRESS_ONLY_INTERNET_GATEWAY_FIELD = SdkField
            .<VpcEncryptionControlExclusion> builder(MarshallingType.SDK_POJO)
            .memberName("EgressOnlyInternetGateway")
            .getter(getter(VpcEncryptionControlExclusions::egressOnlyInternetGateway))
            .setter(setter(Builder::egressOnlyInternetGateway))
            .constructor(VpcEncryptionControlExclusion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EgressOnlyInternetGateway")
                    .unmarshallLocationName("egressOnlyInternetGateway").build()).build();

    private static final SdkField<VpcEncryptionControlExclusion> NAT_GATEWAY_FIELD = SdkField
            .<VpcEncryptionControlExclusion> builder(MarshallingType.SDK_POJO)
            .memberName("NatGateway")
            .getter(getter(VpcEncryptionControlExclusions::natGateway))
            .setter(setter(Builder::natGateway))
            .constructor(VpcEncryptionControlExclusion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGateway")
                    .unmarshallLocationName("natGateway").build()).build();

    private static final SdkField<VpcEncryptionControlExclusion> VIRTUAL_PRIVATE_GATEWAY_FIELD = SdkField
            .<VpcEncryptionControlExclusion> builder(MarshallingType.SDK_POJO)
            .memberName("VirtualPrivateGateway")
            .getter(getter(VpcEncryptionControlExclusions::virtualPrivateGateway))
            .setter(setter(Builder::virtualPrivateGateway))
            .constructor(VpcEncryptionControlExclusion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualPrivateGateway")
                    .unmarshallLocationName("virtualPrivateGateway").build()).build();

    private static final SdkField<VpcEncryptionControlExclusion> VPC_PEERING_FIELD = SdkField
            .<VpcEncryptionControlExclusion> builder(MarshallingType.SDK_POJO)
            .memberName("VpcPeering")
            .getter(getter(VpcEncryptionControlExclusions::vpcPeering))
            .setter(setter(Builder::vpcPeering))
            .constructor(VpcEncryptionControlExclusion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeering")
                    .unmarshallLocationName("vpcPeering").build()).build();

    private static final SdkField<VpcEncryptionControlExclusion> LAMBDA_FIELD = SdkField
            .<VpcEncryptionControlExclusion> builder(MarshallingType.SDK_POJO)
            .memberName("Lambda")
            .getter(getter(VpcEncryptionControlExclusions::lambda))
            .setter(setter(Builder::lambda))
            .constructor(VpcEncryptionControlExclusion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lambda")
                    .unmarshallLocationName("lambda").build()).build();

    private static final SdkField<VpcEncryptionControlExclusion> VPC_LATTICE_FIELD = SdkField
            .<VpcEncryptionControlExclusion> builder(MarshallingType.SDK_POJO)
            .memberName("VpcLattice")
            .getter(getter(VpcEncryptionControlExclusions::vpcLattice))
            .setter(setter(Builder::vpcLattice))
            .constructor(VpcEncryptionControlExclusion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcLattice")
                    .unmarshallLocationName("vpcLattice").build()).build();

    private static final SdkField<VpcEncryptionControlExclusion> ELASTIC_FILE_SYSTEM_FIELD = SdkField
            .<VpcEncryptionControlExclusion> builder(MarshallingType.SDK_POJO)
            .memberName("ElasticFileSystem")
            .getter(getter(VpcEncryptionControlExclusions::elasticFileSystem))
            .setter(setter(Builder::elasticFileSystem))
            .constructor(VpcEncryptionControlExclusion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticFileSystem")
                    .unmarshallLocationName("elasticFileSystem").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERNET_GATEWAY_FIELD,
            EGRESS_ONLY_INTERNET_GATEWAY_FIELD, NAT_GATEWAY_FIELD, VIRTUAL_PRIVATE_GATEWAY_FIELD, VPC_PEERING_FIELD,
            LAMBDA_FIELD, VPC_LATTICE_FIELD, ELASTIC_FILE_SYSTEM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final VpcEncryptionControlExclusion internetGateway;

    private final VpcEncryptionControlExclusion egressOnlyInternetGateway;

    private final VpcEncryptionControlExclusion natGateway;

    private final VpcEncryptionControlExclusion virtualPrivateGateway;

    private final VpcEncryptionControlExclusion vpcPeering;

    private final VpcEncryptionControlExclusion lambda;

    private final VpcEncryptionControlExclusion vpcLattice;

    private final VpcEncryptionControlExclusion elasticFileSystem;

    private VpcEncryptionControlExclusions(BuilderImpl builder) {
        this.internetGateway = builder.internetGateway;
        this.egressOnlyInternetGateway = builder.egressOnlyInternetGateway;
        this.natGateway = builder.natGateway;
        this.virtualPrivateGateway = builder.virtualPrivateGateway;
        this.vpcPeering = builder.vpcPeering;
        this.lambda = builder.lambda;
        this.vpcLattice = builder.vpcLattice;
        this.elasticFileSystem = builder.elasticFileSystem;
    }

    /**
     * <p>
     * The exclusion configuration for internet gateway traffic.
     * </p>
     * 
     * @return The exclusion configuration for internet gateway traffic.
     */
    public final VpcEncryptionControlExclusion internetGateway() {
        return internetGateway;
    }

    /**
     * <p>
     * The exclusion configuration for egress-only internet gateway traffic.
     * </p>
     * 
     * @return The exclusion configuration for egress-only internet gateway traffic.
     */
    public final VpcEncryptionControlExclusion egressOnlyInternetGateway() {
        return egressOnlyInternetGateway;
    }

    /**
     * <p>
     * The exclusion configuration for NAT gateway traffic.
     * </p>
     * 
     * @return The exclusion configuration for NAT gateway traffic.
     */
    public final VpcEncryptionControlExclusion natGateway() {
        return natGateway;
    }

    /**
     * <p>
     * The exclusion configuration for virtual private gateway traffic.
     * </p>
     * 
     * @return The exclusion configuration for virtual private gateway traffic.
     */
    public final VpcEncryptionControlExclusion virtualPrivateGateway() {
        return virtualPrivateGateway;
    }

    /**
     * <p>
     * The exclusion configuration for VPC peering connection traffic.
     * </p>
     * 
     * @return The exclusion configuration for VPC peering connection traffic.
     */
    public final VpcEncryptionControlExclusion vpcPeering() {
        return vpcPeering;
    }

    /**
     * <p>
     * The exclusion configuration for Lambda function traffic.
     * </p>
     * 
     * @return The exclusion configuration for Lambda function traffic.
     */
    public final VpcEncryptionControlExclusion lambda() {
        return lambda;
    }

    /**
     * <p>
     * The exclusion configuration for VPC Lattice traffic.
     * </p>
     * 
     * @return The exclusion configuration for VPC Lattice traffic.
     */
    public final VpcEncryptionControlExclusion vpcLattice() {
        return vpcLattice;
    }

    /**
     * <p>
     * The exclusion configuration for Elastic File System traffic.
     * </p>
     * 
     * @return The exclusion configuration for Elastic File System traffic.
     */
    public final VpcEncryptionControlExclusion elasticFileSystem() {
        return elasticFileSystem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(internetGateway());
        hashCode = 31 * hashCode + Objects.hashCode(egressOnlyInternetGateway());
        hashCode = 31 * hashCode + Objects.hashCode(natGateway());
        hashCode = 31 * hashCode + Objects.hashCode(virtualPrivateGateway());
        hashCode = 31 * hashCode + Objects.hashCode(vpcPeering());
        hashCode = 31 * hashCode + Objects.hashCode(lambda());
        hashCode = 31 * hashCode + Objects.hashCode(vpcLattice());
        hashCode = 31 * hashCode + Objects.hashCode(elasticFileSystem());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcEncryptionControlExclusions)) {
            return false;
        }
        VpcEncryptionControlExclusions other = (VpcEncryptionControlExclusions) obj;
        return Objects.equals(internetGateway(), other.internetGateway())
                && Objects.equals(egressOnlyInternetGateway(), other.egressOnlyInternetGateway())
                && Objects.equals(natGateway(), other.natGateway())
                && Objects.equals(virtualPrivateGateway(), other.virtualPrivateGateway())
                && Objects.equals(vpcPeering(), other.vpcPeering()) && Objects.equals(lambda(), other.lambda())
                && Objects.equals(vpcLattice(), other.vpcLattice())
                && Objects.equals(elasticFileSystem(), other.elasticFileSystem());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcEncryptionControlExclusions").add("InternetGateway", internetGateway())
                .add("EgressOnlyInternetGateway", egressOnlyInternetGateway()).add("NatGateway", natGateway())
                .add("VirtualPrivateGateway", virtualPrivateGateway()).add("VpcPeering", vpcPeering()).add("Lambda", lambda())
                .add("VpcLattice", vpcLattice()).add("ElasticFileSystem", elasticFileSystem()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InternetGateway":
            return Optional.ofNullable(clazz.cast(internetGateway()));
        case "EgressOnlyInternetGateway":
            return Optional.ofNullable(clazz.cast(egressOnlyInternetGateway()));
        case "NatGateway":
            return Optional.ofNullable(clazz.cast(natGateway()));
        case "VirtualPrivateGateway":
            return Optional.ofNullable(clazz.cast(virtualPrivateGateway()));
        case "VpcPeering":
            return Optional.ofNullable(clazz.cast(vpcPeering()));
        case "Lambda":
            return Optional.ofNullable(clazz.cast(lambda()));
        case "VpcLattice":
            return Optional.ofNullable(clazz.cast(vpcLattice()));
        case "ElasticFileSystem":
            return Optional.ofNullable(clazz.cast(elasticFileSystem()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InternetGateway", INTERNET_GATEWAY_FIELD);
        map.put("EgressOnlyInternetGateway", EGRESS_ONLY_INTERNET_GATEWAY_FIELD);
        map.put("NatGateway", NAT_GATEWAY_FIELD);
        map.put("VirtualPrivateGateway", VIRTUAL_PRIVATE_GATEWAY_FIELD);
        map.put("VpcPeering", VPC_PEERING_FIELD);
        map.put("Lambda", LAMBDA_FIELD);
        map.put("VpcLattice", VPC_LATTICE_FIELD);
        map.put("ElasticFileSystem", ELASTIC_FILE_SYSTEM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcEncryptionControlExclusions, T> g) {
        return obj -> g.apply((VpcEncryptionControlExclusions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcEncryptionControlExclusions> {
        /**
         * <p>
         * The exclusion configuration for internet gateway traffic.
         * </p>
         * 
         * @param internetGateway
         *        The exclusion configuration for internet gateway traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internetGateway(VpcEncryptionControlExclusion internetGateway);

        /**
         * <p>
         * The exclusion configuration for internet gateway traffic.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcEncryptionControlExclusion.Builder}
         * avoiding the need to create one manually via {@link VpcEncryptionControlExclusion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcEncryptionControlExclusion.Builder#build()} is called
         * immediately and its result is passed to {@link #internetGateway(VpcEncryptionControlExclusion)}.
         * 
         * @param internetGateway
         *        a consumer that will call methods on {@link VpcEncryptionControlExclusion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #internetGateway(VpcEncryptionControlExclusion)
         */
        default Builder internetGateway(Consumer<VpcEncryptionControlExclusion.Builder> internetGateway) {
            return internetGateway(VpcEncryptionControlExclusion.builder().applyMutation(internetGateway).build());
        }

        /**
         * <p>
         * The exclusion configuration for egress-only internet gateway traffic.
         * </p>
         * 
         * @param egressOnlyInternetGateway
         *        The exclusion configuration for egress-only internet gateway traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressOnlyInternetGateway(VpcEncryptionControlExclusion egressOnlyInternetGateway);

        /**
         * <p>
         * The exclusion configuration for egress-only internet gateway traffic.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcEncryptionControlExclusion.Builder}
         * avoiding the need to create one manually via {@link VpcEncryptionControlExclusion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcEncryptionControlExclusion.Builder#build()} is called
         * immediately and its result is passed to {@link #egressOnlyInternetGateway(VpcEncryptionControlExclusion)}.
         * 
         * @param egressOnlyInternetGateway
         *        a consumer that will call methods on {@link VpcEncryptionControlExclusion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #egressOnlyInternetGateway(VpcEncryptionControlExclusion)
         */
        default Builder egressOnlyInternetGateway(Consumer<VpcEncryptionControlExclusion.Builder> egressOnlyInternetGateway) {
            return egressOnlyInternetGateway(VpcEncryptionControlExclusion.builder().applyMutation(egressOnlyInternetGateway)
                    .build());
        }

        /**
         * <p>
         * The exclusion configuration for NAT gateway traffic.
         * </p>
         * 
         * @param natGateway
         *        The exclusion configuration for NAT gateway traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder natGateway(VpcEncryptionControlExclusion natGateway);

        /**
         * <p>
         * The exclusion configuration for NAT gateway traffic.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcEncryptionControlExclusion.Builder}
         * avoiding the need to create one manually via {@link VpcEncryptionControlExclusion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcEncryptionControlExclusion.Builder#build()} is called
         * immediately and its result is passed to {@link #natGateway(VpcEncryptionControlExclusion)}.
         * 
         * @param natGateway
         *        a consumer that will call methods on {@link VpcEncryptionControlExclusion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #natGateway(VpcEncryptionControlExclusion)
         */
        default Builder natGateway(Consumer<VpcEncryptionControlExclusion.Builder> natGateway) {
            return natGateway(VpcEncryptionControlExclusion.builder().applyMutation(natGateway).build());
        }

        /**
         * <p>
         * The exclusion configuration for virtual private gateway traffic.
         * </p>
         * 
         * @param virtualPrivateGateway
         *        The exclusion configuration for virtual private gateway traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualPrivateGateway(VpcEncryptionControlExclusion virtualPrivateGateway);

        /**
         * <p>
         * The exclusion configuration for virtual private gateway traffic.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcEncryptionControlExclusion.Builder}
         * avoiding the need to create one manually via {@link VpcEncryptionControlExclusion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcEncryptionControlExclusion.Builder#build()} is called
         * immediately and its result is passed to {@link #virtualPrivateGateway(VpcEncryptionControlExclusion)}.
         * 
         * @param virtualPrivateGateway
         *        a consumer that will call methods on {@link VpcEncryptionControlExclusion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #virtualPrivateGateway(VpcEncryptionControlExclusion)
         */
        default Builder virtualPrivateGateway(Consumer<VpcEncryptionControlExclusion.Builder> virtualPrivateGateway) {
            return virtualPrivateGateway(VpcEncryptionControlExclusion.builder().applyMutation(virtualPrivateGateway).build());
        }

        /**
         * <p>
         * The exclusion configuration for VPC peering connection traffic.
         * </p>
         * 
         * @param vpcPeering
         *        The exclusion configuration for VPC peering connection traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeering(VpcEncryptionControlExclusion vpcPeering);

        /**
         * <p>
         * The exclusion configuration for VPC peering connection traffic.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcEncryptionControlExclusion.Builder}
         * avoiding the need to create one manually via {@link VpcEncryptionControlExclusion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcEncryptionControlExclusion.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcPeering(VpcEncryptionControlExclusion)}.
         * 
         * @param vpcPeering
         *        a consumer that will call methods on {@link VpcEncryptionControlExclusion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcPeering(VpcEncryptionControlExclusion)
         */
        default Builder vpcPeering(Consumer<VpcEncryptionControlExclusion.Builder> vpcPeering) {
            return vpcPeering(VpcEncryptionControlExclusion.builder().applyMutation(vpcPeering).build());
        }

        /**
         * <p>
         * The exclusion configuration for Lambda function traffic.
         * </p>
         * 
         * @param lambda
         *        The exclusion configuration for Lambda function traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambda(VpcEncryptionControlExclusion lambda);

        /**
         * <p>
         * The exclusion configuration for Lambda function traffic.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcEncryptionControlExclusion.Builder}
         * avoiding the need to create one manually via {@link VpcEncryptionControlExclusion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcEncryptionControlExclusion.Builder#build()} is called
         * immediately and its result is passed to {@link #lambda(VpcEncryptionControlExclusion)}.
         * 
         * @param lambda
         *        a consumer that will call methods on {@link VpcEncryptionControlExclusion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambda(VpcEncryptionControlExclusion)
         */
        default Builder lambda(Consumer<VpcEncryptionControlExclusion.Builder> lambda) {
            return lambda(VpcEncryptionControlExclusion.builder().applyMutation(lambda).build());
        }

        /**
         * <p>
         * The exclusion configuration for VPC Lattice traffic.
         * </p>
         * 
         * @param vpcLattice
         *        The exclusion configuration for VPC Lattice traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcLattice(VpcEncryptionControlExclusion vpcLattice);

        /**
         * <p>
         * The exclusion configuration for VPC Lattice traffic.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcEncryptionControlExclusion.Builder}
         * avoiding the need to create one manually via {@link VpcEncryptionControlExclusion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcEncryptionControlExclusion.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcLattice(VpcEncryptionControlExclusion)}.
         * 
         * @param vpcLattice
         *        a consumer that will call methods on {@link VpcEncryptionControlExclusion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcLattice(VpcEncryptionControlExclusion)
         */
        default Builder vpcLattice(Consumer<VpcEncryptionControlExclusion.Builder> vpcLattice) {
            return vpcLattice(VpcEncryptionControlExclusion.builder().applyMutation(vpcLattice).build());
        }

        /**
         * <p>
         * The exclusion configuration for Elastic File System traffic.
         * </p>
         * 
         * @param elasticFileSystem
         *        The exclusion configuration for Elastic File System traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticFileSystem(VpcEncryptionControlExclusion elasticFileSystem);

        /**
         * <p>
         * The exclusion configuration for Elastic File System traffic.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcEncryptionControlExclusion.Builder}
         * avoiding the need to create one manually via {@link VpcEncryptionControlExclusion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcEncryptionControlExclusion.Builder#build()} is called
         * immediately and its result is passed to {@link #elasticFileSystem(VpcEncryptionControlExclusion)}.
         * 
         * @param elasticFileSystem
         *        a consumer that will call methods on {@link VpcEncryptionControlExclusion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticFileSystem(VpcEncryptionControlExclusion)
         */
        default Builder elasticFileSystem(Consumer<VpcEncryptionControlExclusion.Builder> elasticFileSystem) {
            return elasticFileSystem(VpcEncryptionControlExclusion.builder().applyMutation(elasticFileSystem).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VpcEncryptionControlExclusion internetGateway;

        private VpcEncryptionControlExclusion egressOnlyInternetGateway;

        private VpcEncryptionControlExclusion natGateway;

        private VpcEncryptionControlExclusion virtualPrivateGateway;

        private VpcEncryptionControlExclusion vpcPeering;

        private VpcEncryptionControlExclusion lambda;

        private VpcEncryptionControlExclusion vpcLattice;

        private VpcEncryptionControlExclusion elasticFileSystem;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcEncryptionControlExclusions model) {
            internetGateway(model.internetGateway);
            egressOnlyInternetGateway(model.egressOnlyInternetGateway);
            natGateway(model.natGateway);
            virtualPrivateGateway(model.virtualPrivateGateway);
            vpcPeering(model.vpcPeering);
            lambda(model.lambda);
            vpcLattice(model.vpcLattice);
            elasticFileSystem(model.elasticFileSystem);
        }

        public final VpcEncryptionControlExclusion.Builder getInternetGateway() {
            return internetGateway != null ? internetGateway.toBuilder() : null;
        }

        public final void setInternetGateway(VpcEncryptionControlExclusion.BuilderImpl internetGateway) {
            this.internetGateway = internetGateway != null ? internetGateway.build() : null;
        }

        @Override
        public final Builder internetGateway(VpcEncryptionControlExclusion internetGateway) {
            this.internetGateway = internetGateway;
            return this;
        }

        public final VpcEncryptionControlExclusion.Builder getEgressOnlyInternetGateway() {
            return egressOnlyInternetGateway != null ? egressOnlyInternetGateway.toBuilder() : null;
        }

        public final void setEgressOnlyInternetGateway(VpcEncryptionControlExclusion.BuilderImpl egressOnlyInternetGateway) {
            this.egressOnlyInternetGateway = egressOnlyInternetGateway != null ? egressOnlyInternetGateway.build() : null;
        }

        @Override
        public final Builder egressOnlyInternetGateway(VpcEncryptionControlExclusion egressOnlyInternetGateway) {
            this.egressOnlyInternetGateway = egressOnlyInternetGateway;
            return this;
        }

        public final VpcEncryptionControlExclusion.Builder getNatGateway() {
            return natGateway != null ? natGateway.toBuilder() : null;
        }

        public final void setNatGateway(VpcEncryptionControlExclusion.BuilderImpl natGateway) {
            this.natGateway = natGateway != null ? natGateway.build() : null;
        }

        @Override
        public final Builder natGateway(VpcEncryptionControlExclusion natGateway) {
            this.natGateway = natGateway;
            return this;
        }

        public final VpcEncryptionControlExclusion.Builder getVirtualPrivateGateway() {
            return virtualPrivateGateway != null ? virtualPrivateGateway.toBuilder() : null;
        }

        public final void setVirtualPrivateGateway(VpcEncryptionControlExclusion.BuilderImpl virtualPrivateGateway) {
            this.virtualPrivateGateway = virtualPrivateGateway != null ? virtualPrivateGateway.build() : null;
        }

        @Override
        public final Builder virtualPrivateGateway(VpcEncryptionControlExclusion virtualPrivateGateway) {
            this.virtualPrivateGateway = virtualPrivateGateway;
            return this;
        }

        public final VpcEncryptionControlExclusion.Builder getVpcPeering() {
            return vpcPeering != null ? vpcPeering.toBuilder() : null;
        }

        public final void setVpcPeering(VpcEncryptionControlExclusion.BuilderImpl vpcPeering) {
            this.vpcPeering = vpcPeering != null ? vpcPeering.build() : null;
        }

        @Override
        public final Builder vpcPeering(VpcEncryptionControlExclusion vpcPeering) {
            this.vpcPeering = vpcPeering;
            return this;
        }

        public final VpcEncryptionControlExclusion.Builder getLambda() {
            return lambda != null ? lambda.toBuilder() : null;
        }

        public final void setLambda(VpcEncryptionControlExclusion.BuilderImpl lambda) {
            this.lambda = lambda != null ? lambda.build() : null;
        }

        @Override
        public final Builder lambda(VpcEncryptionControlExclusion lambda) {
            this.lambda = lambda;
            return this;
        }

        public final VpcEncryptionControlExclusion.Builder getVpcLattice() {
            return vpcLattice != null ? vpcLattice.toBuilder() : null;
        }

        public final void setVpcLattice(VpcEncryptionControlExclusion.BuilderImpl vpcLattice) {
            this.vpcLattice = vpcLattice != null ? vpcLattice.build() : null;
        }

        @Override
        public final Builder vpcLattice(VpcEncryptionControlExclusion vpcLattice) {
            this.vpcLattice = vpcLattice;
            return this;
        }

        public final VpcEncryptionControlExclusion.Builder getElasticFileSystem() {
            return elasticFileSystem != null ? elasticFileSystem.toBuilder() : null;
        }

        public final void setElasticFileSystem(VpcEncryptionControlExclusion.BuilderImpl elasticFileSystem) {
            this.elasticFileSystem = elasticFileSystem != null ? elasticFileSystem.build() : null;
        }

        @Override
        public final Builder elasticFileSystem(VpcEncryptionControlExclusion elasticFileSystem) {
            this.elasticFileSystem = elasticFileSystem;
            return this;
        }

        @Override
        public VpcEncryptionControlExclusions build() {
            return new VpcEncryptionControlExclusions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
