/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a block device mapping for a Scheduled Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduledInstancesBlockDeviceMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduledInstancesBlockDeviceMapping.Builder, ScheduledInstancesBlockDeviceMapping> {
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DeviceName")
            .getter(getter(ScheduledInstancesBlockDeviceMapping::deviceName))
            .setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName")
                    .unmarshallLocationName("DeviceName").build()).build();

    private static final SdkField<ScheduledInstancesEbs> EBS_FIELD = SdkField
            .<ScheduledInstancesEbs> builder(MarshallingType.SDK_POJO)
            .memberName("Ebs")
            .getter(getter(ScheduledInstancesBlockDeviceMapping::ebs))
            .setter(setter(Builder::ebs))
            .constructor(ScheduledInstancesEbs::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ebs").unmarshallLocationName("Ebs")
                    .build()).build();

    private static final SdkField<String> NO_DEVICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NoDevice")
            .getter(getter(ScheduledInstancesBlockDeviceMapping::noDevice))
            .setter(setter(Builder::noDevice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoDevice")
                    .unmarshallLocationName("NoDevice").build()).build();

    private static final SdkField<String> VIRTUAL_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VirtualName")
            .getter(getter(ScheduledInstancesBlockDeviceMapping::virtualName))
            .setter(setter(Builder::virtualName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualName")
                    .unmarshallLocationName("VirtualName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_NAME_FIELD, EBS_FIELD,
            NO_DEVICE_FIELD, VIRTUAL_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String deviceName;

    private final ScheduledInstancesEbs ebs;

    private final String noDevice;

    private final String virtualName;

    private ScheduledInstancesBlockDeviceMapping(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.ebs = builder.ebs;
        this.noDevice = builder.noDevice;
        this.virtualName = builder.virtualName;
    }

    /**
     * <p>
     * The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
     * </p>
     * 
     * @return The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
     */
    public final String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * Parameters used to set up EBS volumes automatically when the instance is launched.
     * </p>
     * 
     * @return Parameters used to set up EBS volumes automatically when the instance is launched.
     */
    public final ScheduledInstancesEbs ebs() {
        return ebs;
    }

    /**
     * <p>
     * To omit the device from the block device mapping, specify an empty string.
     * </p>
     * 
     * @return To omit the device from the block device mapping, specify an empty string.
     */
    public final String noDevice() {
        return noDevice;
    }

    /**
     * <p>
     * The virtual device name (<code>ephemeral</code>N). Instance store volumes are numbered starting from 0. An
     * instance type with two available instance store volumes can specify mappings for <code>ephemeral0</code> and
     * <code>ephemeral1</code>. The number of available instance store volumes depends on the instance type. After you
     * connect to the instance, you must mount the volume.
     * </p>
     * <p>
     * Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for the
     * instance. When you launch an M3 instance, we ignore any instance store volumes specified in the block device
     * mapping for the AMI.
     * </p>
     * 
     * @return The virtual device name (<code>ephemeral</code>N). Instance store volumes are numbered starting from 0.
     *         An instance type with two available instance store volumes can specify mappings for
     *         <code>ephemeral0</code> and <code>ephemeral1</code>. The number of available instance store volumes
     *         depends on the instance type. After you connect to the instance, you must mount the volume.</p>
     *         <p>
     *         Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for
     *         the instance. When you launch an M3 instance, we ignore any instance store volumes specified in the block
     *         device mapping for the AMI.
     */
    public final String virtualName() {
        return virtualName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(ebs());
        hashCode = 31 * hashCode + Objects.hashCode(noDevice());
        hashCode = 31 * hashCode + Objects.hashCode(virtualName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstancesBlockDeviceMapping)) {
            return false;
        }
        ScheduledInstancesBlockDeviceMapping other = (ScheduledInstancesBlockDeviceMapping) obj;
        return Objects.equals(deviceName(), other.deviceName()) && Objects.equals(ebs(), other.ebs())
                && Objects.equals(noDevice(), other.noDevice()) && Objects.equals(virtualName(), other.virtualName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduledInstancesBlockDeviceMapping").add("DeviceName", deviceName()).add("Ebs", ebs())
                .add("NoDevice", noDevice()).add("VirtualName", virtualName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "Ebs":
            return Optional.ofNullable(clazz.cast(ebs()));
        case "NoDevice":
            return Optional.ofNullable(clazz.cast(noDevice()));
        case "VirtualName":
            return Optional.ofNullable(clazz.cast(virtualName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeviceName", DEVICE_NAME_FIELD);
        map.put("Ebs", EBS_FIELD);
        map.put("NoDevice", NO_DEVICE_FIELD);
        map.put("VirtualName", VIRTUAL_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduledInstancesBlockDeviceMapping, T> g) {
        return obj -> g.apply((ScheduledInstancesBlockDeviceMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduledInstancesBlockDeviceMapping> {
        /**
         * <p>
         * The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * </p>
         * 
         * @param deviceName
         *        The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * Parameters used to set up EBS volumes automatically when the instance is launched.
         * </p>
         * 
         * @param ebs
         *        Parameters used to set up EBS volumes automatically when the instance is launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebs(ScheduledInstancesEbs ebs);

        /**
         * <p>
         * Parameters used to set up EBS volumes automatically when the instance is launched.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScheduledInstancesEbs.Builder} avoiding
         * the need to create one manually via {@link ScheduledInstancesEbs#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScheduledInstancesEbs.Builder#build()} is called immediately and
         * its result is passed to {@link #ebs(ScheduledInstancesEbs)}.
         * 
         * @param ebs
         *        a consumer that will call methods on {@link ScheduledInstancesEbs.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebs(ScheduledInstancesEbs)
         */
        default Builder ebs(Consumer<ScheduledInstancesEbs.Builder> ebs) {
            return ebs(ScheduledInstancesEbs.builder().applyMutation(ebs).build());
        }

        /**
         * <p>
         * To omit the device from the block device mapping, specify an empty string.
         * </p>
         * 
         * @param noDevice
         *        To omit the device from the block device mapping, specify an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noDevice(String noDevice);

        /**
         * <p>
         * The virtual device name (<code>ephemeral</code>N). Instance store volumes are numbered starting from 0. An
         * instance type with two available instance store volumes can specify mappings for <code>ephemeral0</code> and
         * <code>ephemeral1</code>. The number of available instance store volumes depends on the instance type. After
         * you connect to the instance, you must mount the volume.
         * </p>
         * <p>
         * Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for the
         * instance. When you launch an M3 instance, we ignore any instance store volumes specified in the block device
         * mapping for the AMI.
         * </p>
         * 
         * @param virtualName
         *        The virtual device name (<code>ephemeral</code>N). Instance store volumes are numbered starting from
         *        0. An instance type with two available instance store volumes can specify mappings for
         *        <code>ephemeral0</code> and <code>ephemeral1</code>. The number of available instance store volumes
         *        depends on the instance type. After you connect to the instance, you must mount the volume.</p>
         *        <p>
         *        Constraints: For M3 instances, you must specify instance store volumes in the block device mapping for
         *        the instance. When you launch an M3 instance, we ignore any instance store volumes specified in the
         *        block device mapping for the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualName(String virtualName);
    }

    static final class BuilderImpl implements Builder {
        private String deviceName;

        private ScheduledInstancesEbs ebs;

        private String noDevice;

        private String virtualName;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstancesBlockDeviceMapping model) {
            deviceName(model.deviceName);
            ebs(model.ebs);
            noDevice(model.noDevice);
            virtualName(model.virtualName);
        }

        public final String getDeviceName() {
            return deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final ScheduledInstancesEbs.Builder getEbs() {
            return ebs != null ? ebs.toBuilder() : null;
        }

        public final void setEbs(ScheduledInstancesEbs.BuilderImpl ebs) {
            this.ebs = ebs != null ? ebs.build() : null;
        }

        @Override
        public final Builder ebs(ScheduledInstancesEbs ebs) {
            this.ebs = ebs;
            return this;
        }

        public final String getNoDevice() {
            return noDevice;
        }

        public final void setNoDevice(String noDevice) {
            this.noDevice = noDevice;
        }

        @Override
        public final Builder noDevice(String noDevice) {
            this.noDevice = noDevice;
            return this;
        }

        public final String getVirtualName() {
            return virtualName;
        }

        public final void setVirtualName(String virtualName) {
            this.virtualName = virtualName;
        }

        @Override
        public final Builder virtualName(String virtualName) {
            this.virtualName = virtualName;
            return this;
        }

        @Override
        public ScheduledInstancesBlockDeviceMapping build() {
            return new ScheduledInstancesBlockDeviceMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
