/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the network card support of the instance type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkCardInfo implements SdkPojo, Serializable, ToCopyableBuilder<NetworkCardInfo.Builder, NetworkCardInfo> {
    private static final SdkField<Integer> NETWORK_CARD_INDEX_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NetworkCardIndex")
            .getter(getter(NetworkCardInfo::networkCardIndex))
            .setter(setter(Builder::networkCardIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkCardIndex")
                    .unmarshallLocationName("networkCardIndex").build()).build();

    private static final SdkField<String> NETWORK_PERFORMANCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkPerformance")
            .getter(getter(NetworkCardInfo::networkPerformance))
            .setter(setter(Builder::networkPerformance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkPerformance")
                    .unmarshallLocationName("networkPerformance").build()).build();

    private static final SdkField<Integer> MAXIMUM_NETWORK_INTERFACES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumNetworkInterfaces")
            .getter(getter(NetworkCardInfo::maximumNetworkInterfaces))
            .setter(setter(Builder::maximumNetworkInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumNetworkInterfaces")
                    .unmarshallLocationName("maximumNetworkInterfaces").build()).build();

    private static final SdkField<Integer> ADDITIONAL_FLEXIBLE_NETWORK_INTERFACES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AdditionalFlexibleNetworkInterfaces")
            .getter(getter(NetworkCardInfo::additionalFlexibleNetworkInterfaces))
            .setter(setter(Builder::additionalFlexibleNetworkInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AdditionalFlexibleNetworkInterfaces")
                    .unmarshallLocationName("additionalFlexibleNetworkInterfaces").build()).build();

    private static final SdkField<Double> BASELINE_BANDWIDTH_IN_GBPS_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("BaselineBandwidthInGbps")
            .getter(getter(NetworkCardInfo::baselineBandwidthInGbps))
            .setter(setter(Builder::baselineBandwidthInGbps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineBandwidthInGbps")
                    .unmarshallLocationName("baselineBandwidthInGbps").build()).build();

    private static final SdkField<Double> PEAK_BANDWIDTH_IN_GBPS_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("PeakBandwidthInGbps")
            .getter(getter(NetworkCardInfo::peakBandwidthInGbps))
            .setter(setter(Builder::peakBandwidthInGbps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeakBandwidthInGbps")
                    .unmarshallLocationName("peakBandwidthInGbps").build()).build();

    private static final SdkField<Integer> DEFAULT_ENA_QUEUE_COUNT_PER_INTERFACE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DefaultEnaQueueCountPerInterface")
            .getter(getter(NetworkCardInfo::defaultEnaQueueCountPerInterface))
            .setter(setter(Builder::defaultEnaQueueCountPerInterface))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultEnaQueueCountPerInterface")
                    .unmarshallLocationName("defaultEnaQueueCountPerInterface").build()).build();

    private static final SdkField<Integer> MAXIMUM_ENA_QUEUE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumEnaQueueCount")
            .getter(getter(NetworkCardInfo::maximumEnaQueueCount))
            .setter(setter(Builder::maximumEnaQueueCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumEnaQueueCount")
                    .unmarshallLocationName("maximumEnaQueueCount").build()).build();

    private static final SdkField<Integer> MAXIMUM_ENA_QUEUE_COUNT_PER_INTERFACE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumEnaQueueCountPerInterface")
            .getter(getter(NetworkCardInfo::maximumEnaQueueCountPerInterface))
            .setter(setter(Builder::maximumEnaQueueCountPerInterface))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumEnaQueueCountPerInterface")
                    .unmarshallLocationName("maximumEnaQueueCountPerInterface").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_CARD_INDEX_FIELD,
            NETWORK_PERFORMANCE_FIELD, MAXIMUM_NETWORK_INTERFACES_FIELD, ADDITIONAL_FLEXIBLE_NETWORK_INTERFACES_FIELD,
            BASELINE_BANDWIDTH_IN_GBPS_FIELD, PEAK_BANDWIDTH_IN_GBPS_FIELD, DEFAULT_ENA_QUEUE_COUNT_PER_INTERFACE_FIELD,
            MAXIMUM_ENA_QUEUE_COUNT_FIELD, MAXIMUM_ENA_QUEUE_COUNT_PER_INTERFACE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer networkCardIndex;

    private final String networkPerformance;

    private final Integer maximumNetworkInterfaces;

    private final Integer additionalFlexibleNetworkInterfaces;

    private final Double baselineBandwidthInGbps;

    private final Double peakBandwidthInGbps;

    private final Integer defaultEnaQueueCountPerInterface;

    private final Integer maximumEnaQueueCount;

    private final Integer maximumEnaQueueCountPerInterface;

    private NetworkCardInfo(BuilderImpl builder) {
        this.networkCardIndex = builder.networkCardIndex;
        this.networkPerformance = builder.networkPerformance;
        this.maximumNetworkInterfaces = builder.maximumNetworkInterfaces;
        this.additionalFlexibleNetworkInterfaces = builder.additionalFlexibleNetworkInterfaces;
        this.baselineBandwidthInGbps = builder.baselineBandwidthInGbps;
        this.peakBandwidthInGbps = builder.peakBandwidthInGbps;
        this.defaultEnaQueueCountPerInterface = builder.defaultEnaQueueCountPerInterface;
        this.maximumEnaQueueCount = builder.maximumEnaQueueCount;
        this.maximumEnaQueueCountPerInterface = builder.maximumEnaQueueCountPerInterface;
    }

    /**
     * <p>
     * The index of the network card.
     * </p>
     * 
     * @return The index of the network card.
     */
    public final Integer networkCardIndex() {
        return networkCardIndex;
    }

    /**
     * <p>
     * The network performance of the network card.
     * </p>
     * 
     * @return The network performance of the network card.
     */
    public final String networkPerformance() {
        return networkPerformance;
    }

    /**
     * <p>
     * The maximum number of network interfaces for the network card.
     * </p>
     * 
     * @return The maximum number of network interfaces for the network card.
     */
    public final Integer maximumNetworkInterfaces() {
        return maximumNetworkInterfaces;
    }

    /**
     * <p>
     * The number of additional network interfaces that can be attached to an instance when using flexible Elastic
     * Network Adapter (ENA) queues. This number is in addition to the base number specified by
     * <code>maximumNetworkInterfaces</code>.
     * </p>
     * 
     * @return The number of additional network interfaces that can be attached to an instance when using flexible
     *         Elastic Network Adapter (ENA) queues. This number is in addition to the base number specified by
     *         <code>maximumNetworkInterfaces</code>.
     */
    public final Integer additionalFlexibleNetworkInterfaces() {
        return additionalFlexibleNetworkInterfaces;
    }

    /**
     * <p>
     * The baseline network performance of the network card, in Gbps.
     * </p>
     * 
     * @return The baseline network performance of the network card, in Gbps.
     */
    public final Double baselineBandwidthInGbps() {
        return baselineBandwidthInGbps;
    }

    /**
     * <p>
     * The peak (burst) network performance of the network card, in Gbps.
     * </p>
     * 
     * @return The peak (burst) network performance of the network card, in Gbps.
     */
    public final Double peakBandwidthInGbps() {
        return peakBandwidthInGbps;
    }

    /**
     * <p>
     * The default number of the ENA queues for each interface.
     * </p>
     * 
     * @return The default number of the ENA queues for each interface.
     */
    public final Integer defaultEnaQueueCountPerInterface() {
        return defaultEnaQueueCountPerInterface;
    }

    /**
     * <p>
     * The maximum number of the ENA queues.
     * </p>
     * 
     * @return The maximum number of the ENA queues.
     */
    public final Integer maximumEnaQueueCount() {
        return maximumEnaQueueCount;
    }

    /**
     * <p>
     * The maximum number of the ENA queues for each interface.
     * </p>
     * 
     * @return The maximum number of the ENA queues for each interface.
     */
    public final Integer maximumEnaQueueCountPerInterface() {
        return maximumEnaQueueCountPerInterface;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkCardIndex());
        hashCode = 31 * hashCode + Objects.hashCode(networkPerformance());
        hashCode = 31 * hashCode + Objects.hashCode(maximumNetworkInterfaces());
        hashCode = 31 * hashCode + Objects.hashCode(additionalFlexibleNetworkInterfaces());
        hashCode = 31 * hashCode + Objects.hashCode(baselineBandwidthInGbps());
        hashCode = 31 * hashCode + Objects.hashCode(peakBandwidthInGbps());
        hashCode = 31 * hashCode + Objects.hashCode(defaultEnaQueueCountPerInterface());
        hashCode = 31 * hashCode + Objects.hashCode(maximumEnaQueueCount());
        hashCode = 31 * hashCode + Objects.hashCode(maximumEnaQueueCountPerInterface());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkCardInfo)) {
            return false;
        }
        NetworkCardInfo other = (NetworkCardInfo) obj;
        return Objects.equals(networkCardIndex(), other.networkCardIndex())
                && Objects.equals(networkPerformance(), other.networkPerformance())
                && Objects.equals(maximumNetworkInterfaces(), other.maximumNetworkInterfaces())
                && Objects.equals(additionalFlexibleNetworkInterfaces(), other.additionalFlexibleNetworkInterfaces())
                && Objects.equals(baselineBandwidthInGbps(), other.baselineBandwidthInGbps())
                && Objects.equals(peakBandwidthInGbps(), other.peakBandwidthInGbps())
                && Objects.equals(defaultEnaQueueCountPerInterface(), other.defaultEnaQueueCountPerInterface())
                && Objects.equals(maximumEnaQueueCount(), other.maximumEnaQueueCount())
                && Objects.equals(maximumEnaQueueCountPerInterface(), other.maximumEnaQueueCountPerInterface());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkCardInfo").add("NetworkCardIndex", networkCardIndex())
                .add("NetworkPerformance", networkPerformance()).add("MaximumNetworkInterfaces", maximumNetworkInterfaces())
                .add("AdditionalFlexibleNetworkInterfaces", additionalFlexibleNetworkInterfaces())
                .add("BaselineBandwidthInGbps", baselineBandwidthInGbps()).add("PeakBandwidthInGbps", peakBandwidthInGbps())
                .add("DefaultEnaQueueCountPerInterface", defaultEnaQueueCountPerInterface())
                .add("MaximumEnaQueueCount", maximumEnaQueueCount())
                .add("MaximumEnaQueueCountPerInterface", maximumEnaQueueCountPerInterface()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkCardIndex":
            return Optional.ofNullable(clazz.cast(networkCardIndex()));
        case "NetworkPerformance":
            return Optional.ofNullable(clazz.cast(networkPerformance()));
        case "MaximumNetworkInterfaces":
            return Optional.ofNullable(clazz.cast(maximumNetworkInterfaces()));
        case "AdditionalFlexibleNetworkInterfaces":
            return Optional.ofNullable(clazz.cast(additionalFlexibleNetworkInterfaces()));
        case "BaselineBandwidthInGbps":
            return Optional.ofNullable(clazz.cast(baselineBandwidthInGbps()));
        case "PeakBandwidthInGbps":
            return Optional.ofNullable(clazz.cast(peakBandwidthInGbps()));
        case "DefaultEnaQueueCountPerInterface":
            return Optional.ofNullable(clazz.cast(defaultEnaQueueCountPerInterface()));
        case "MaximumEnaQueueCount":
            return Optional.ofNullable(clazz.cast(maximumEnaQueueCount()));
        case "MaximumEnaQueueCountPerInterface":
            return Optional.ofNullable(clazz.cast(maximumEnaQueueCountPerInterface()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NetworkCardIndex", NETWORK_CARD_INDEX_FIELD);
        map.put("NetworkPerformance", NETWORK_PERFORMANCE_FIELD);
        map.put("MaximumNetworkInterfaces", MAXIMUM_NETWORK_INTERFACES_FIELD);
        map.put("AdditionalFlexibleNetworkInterfaces", ADDITIONAL_FLEXIBLE_NETWORK_INTERFACES_FIELD);
        map.put("BaselineBandwidthInGbps", BASELINE_BANDWIDTH_IN_GBPS_FIELD);
        map.put("PeakBandwidthInGbps", PEAK_BANDWIDTH_IN_GBPS_FIELD);
        map.put("DefaultEnaQueueCountPerInterface", DEFAULT_ENA_QUEUE_COUNT_PER_INTERFACE_FIELD);
        map.put("MaximumEnaQueueCount", MAXIMUM_ENA_QUEUE_COUNT_FIELD);
        map.put("MaximumEnaQueueCountPerInterface", MAXIMUM_ENA_QUEUE_COUNT_PER_INTERFACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkCardInfo, T> g) {
        return obj -> g.apply((NetworkCardInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkCardInfo> {
        /**
         * <p>
         * The index of the network card.
         * </p>
         * 
         * @param networkCardIndex
         *        The index of the network card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkCardIndex(Integer networkCardIndex);

        /**
         * <p>
         * The network performance of the network card.
         * </p>
         * 
         * @param networkPerformance
         *        The network performance of the network card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkPerformance(String networkPerformance);

        /**
         * <p>
         * The maximum number of network interfaces for the network card.
         * </p>
         * 
         * @param maximumNetworkInterfaces
         *        The maximum number of network interfaces for the network card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumNetworkInterfaces(Integer maximumNetworkInterfaces);

        /**
         * <p>
         * The number of additional network interfaces that can be attached to an instance when using flexible Elastic
         * Network Adapter (ENA) queues. This number is in addition to the base number specified by
         * <code>maximumNetworkInterfaces</code>.
         * </p>
         * 
         * @param additionalFlexibleNetworkInterfaces
         *        The number of additional network interfaces that can be attached to an instance when using flexible
         *        Elastic Network Adapter (ENA) queues. This number is in addition to the base number specified by
         *        <code>maximumNetworkInterfaces</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalFlexibleNetworkInterfaces(Integer additionalFlexibleNetworkInterfaces);

        /**
         * <p>
         * The baseline network performance of the network card, in Gbps.
         * </p>
         * 
         * @param baselineBandwidthInGbps
         *        The baseline network performance of the network card, in Gbps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineBandwidthInGbps(Double baselineBandwidthInGbps);

        /**
         * <p>
         * The peak (burst) network performance of the network card, in Gbps.
         * </p>
         * 
         * @param peakBandwidthInGbps
         *        The peak (burst) network performance of the network card, in Gbps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peakBandwidthInGbps(Double peakBandwidthInGbps);

        /**
         * <p>
         * The default number of the ENA queues for each interface.
         * </p>
         * 
         * @param defaultEnaQueueCountPerInterface
         *        The default number of the ENA queues for each interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultEnaQueueCountPerInterface(Integer defaultEnaQueueCountPerInterface);

        /**
         * <p>
         * The maximum number of the ENA queues.
         * </p>
         * 
         * @param maximumEnaQueueCount
         *        The maximum number of the ENA queues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumEnaQueueCount(Integer maximumEnaQueueCount);

        /**
         * <p>
         * The maximum number of the ENA queues for each interface.
         * </p>
         * 
         * @param maximumEnaQueueCountPerInterface
         *        The maximum number of the ENA queues for each interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumEnaQueueCountPerInterface(Integer maximumEnaQueueCountPerInterface);
    }

    static final class BuilderImpl implements Builder {
        private Integer networkCardIndex;

        private String networkPerformance;

        private Integer maximumNetworkInterfaces;

        private Integer additionalFlexibleNetworkInterfaces;

        private Double baselineBandwidthInGbps;

        private Double peakBandwidthInGbps;

        private Integer defaultEnaQueueCountPerInterface;

        private Integer maximumEnaQueueCount;

        private Integer maximumEnaQueueCountPerInterface;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkCardInfo model) {
            networkCardIndex(model.networkCardIndex);
            networkPerformance(model.networkPerformance);
            maximumNetworkInterfaces(model.maximumNetworkInterfaces);
            additionalFlexibleNetworkInterfaces(model.additionalFlexibleNetworkInterfaces);
            baselineBandwidthInGbps(model.baselineBandwidthInGbps);
            peakBandwidthInGbps(model.peakBandwidthInGbps);
            defaultEnaQueueCountPerInterface(model.defaultEnaQueueCountPerInterface);
            maximumEnaQueueCount(model.maximumEnaQueueCount);
            maximumEnaQueueCountPerInterface(model.maximumEnaQueueCountPerInterface);
        }

        public final Integer getNetworkCardIndex() {
            return networkCardIndex;
        }

        public final void setNetworkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
        }

        @Override
        public final Builder networkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
            return this;
        }

        public final String getNetworkPerformance() {
            return networkPerformance;
        }

        public final void setNetworkPerformance(String networkPerformance) {
            this.networkPerformance = networkPerformance;
        }

        @Override
        public final Builder networkPerformance(String networkPerformance) {
            this.networkPerformance = networkPerformance;
            return this;
        }

        public final Integer getMaximumNetworkInterfaces() {
            return maximumNetworkInterfaces;
        }

        public final void setMaximumNetworkInterfaces(Integer maximumNetworkInterfaces) {
            this.maximumNetworkInterfaces = maximumNetworkInterfaces;
        }

        @Override
        public final Builder maximumNetworkInterfaces(Integer maximumNetworkInterfaces) {
            this.maximumNetworkInterfaces = maximumNetworkInterfaces;
            return this;
        }

        public final Integer getAdditionalFlexibleNetworkInterfaces() {
            return additionalFlexibleNetworkInterfaces;
        }

        public final void setAdditionalFlexibleNetworkInterfaces(Integer additionalFlexibleNetworkInterfaces) {
            this.additionalFlexibleNetworkInterfaces = additionalFlexibleNetworkInterfaces;
        }

        @Override
        public final Builder additionalFlexibleNetworkInterfaces(Integer additionalFlexibleNetworkInterfaces) {
            this.additionalFlexibleNetworkInterfaces = additionalFlexibleNetworkInterfaces;
            return this;
        }

        public final Double getBaselineBandwidthInGbps() {
            return baselineBandwidthInGbps;
        }

        public final void setBaselineBandwidthInGbps(Double baselineBandwidthInGbps) {
            this.baselineBandwidthInGbps = baselineBandwidthInGbps;
        }

        @Override
        public final Builder baselineBandwidthInGbps(Double baselineBandwidthInGbps) {
            this.baselineBandwidthInGbps = baselineBandwidthInGbps;
            return this;
        }

        public final Double getPeakBandwidthInGbps() {
            return peakBandwidthInGbps;
        }

        public final void setPeakBandwidthInGbps(Double peakBandwidthInGbps) {
            this.peakBandwidthInGbps = peakBandwidthInGbps;
        }

        @Override
        public final Builder peakBandwidthInGbps(Double peakBandwidthInGbps) {
            this.peakBandwidthInGbps = peakBandwidthInGbps;
            return this;
        }

        public final Integer getDefaultEnaQueueCountPerInterface() {
            return defaultEnaQueueCountPerInterface;
        }

        public final void setDefaultEnaQueueCountPerInterface(Integer defaultEnaQueueCountPerInterface) {
            this.defaultEnaQueueCountPerInterface = defaultEnaQueueCountPerInterface;
        }

        @Override
        public final Builder defaultEnaQueueCountPerInterface(Integer defaultEnaQueueCountPerInterface) {
            this.defaultEnaQueueCountPerInterface = defaultEnaQueueCountPerInterface;
            return this;
        }

        public final Integer getMaximumEnaQueueCount() {
            return maximumEnaQueueCount;
        }

        public final void setMaximumEnaQueueCount(Integer maximumEnaQueueCount) {
            this.maximumEnaQueueCount = maximumEnaQueueCount;
        }

        @Override
        public final Builder maximumEnaQueueCount(Integer maximumEnaQueueCount) {
            this.maximumEnaQueueCount = maximumEnaQueueCount;
            return this;
        }

        public final Integer getMaximumEnaQueueCountPerInterface() {
            return maximumEnaQueueCountPerInterface;
        }

        public final void setMaximumEnaQueueCountPerInterface(Integer maximumEnaQueueCountPerInterface) {
            this.maximumEnaQueueCountPerInterface = maximumEnaQueueCountPerInterface;
        }

        @Override
        public final Builder maximumEnaQueueCountPerInterface(Integer maximumEnaQueueCountPerInterface) {
            this.maximumEnaQueueCountPerInterface = maximumEnaQueueCountPerInterface;
            return this;
        }

        @Override
        public NetworkCardInfo build() {
            return new NetworkCardInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
