/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a secondary interface attached to an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceSecondaryInterface implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceSecondaryInterface.Builder, InstanceSecondaryInterface> {
    private static final SdkField<InstanceSecondaryInterfaceAttachment> ATTACHMENT_FIELD = SdkField
            .<InstanceSecondaryInterfaceAttachment> builder(MarshallingType.SDK_POJO)
            .memberName("Attachment")
            .getter(getter(InstanceSecondaryInterface::attachment))
            .setter(setter(Builder::attachment))
            .constructor(InstanceSecondaryInterfaceAttachment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment")
                    .unmarshallLocationName("attachment").build()).build();

    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MacAddress")
            .getter(getter(InstanceSecondaryInterface::macAddress))
            .setter(setter(Builder::macAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacAddress")
                    .unmarshallLocationName("macAddress").build()).build();

    private static final SdkField<String> SECONDARY_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecondaryInterfaceId")
            .getter(getter(InstanceSecondaryInterface::secondaryInterfaceId))
            .setter(setter(Builder::secondaryInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryInterfaceId")
                    .unmarshallLocationName("secondaryInterfaceId").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(InstanceSecondaryInterface::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<List<InstanceSecondaryInterfacePrivateIpAddress>> PRIVATE_IP_ADDRESSES_FIELD = SdkField
            .<List<InstanceSecondaryInterfacePrivateIpAddress>> builder(MarshallingType.LIST)
            .memberName("PrivateIpAddresses")
            .getter(getter(InstanceSecondaryInterface::privateIpAddresses))
            .setter(setter(Builder::privateIpAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddressSet")
                    .unmarshallLocationName("privateIpAddressSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceSecondaryInterfacePrivateIpAddress> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceSecondaryInterfacePrivateIpAddress::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> SOURCE_DEST_CHECK_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SourceDestCheck")
            .getter(getter(InstanceSecondaryInterface::sourceDestCheck))
            .setter(setter(Builder::sourceDestCheck))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDestCheck")
                    .unmarshallLocationName("sourceDestCheck").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(InstanceSecondaryInterface::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final SdkField<String> SECONDARY_SUBNET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecondarySubnetId")
            .getter(getter(InstanceSecondaryInterface::secondarySubnetId))
            .setter(setter(Builder::secondarySubnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondarySubnetId")
                    .unmarshallLocationName("secondarySubnetId").build()).build();

    private static final SdkField<String> SECONDARY_NETWORK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecondaryNetworkId")
            .getter(getter(InstanceSecondaryInterface::secondaryNetworkId))
            .setter(setter(Builder::secondaryNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryNetworkId")
                    .unmarshallLocationName("secondaryNetworkId").build()).build();

    private static final SdkField<String> INTERFACE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InterfaceType")
            .getter(getter(InstanceSecondaryInterface::interfaceTypeAsString))
            .setter(setter(Builder::interfaceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterfaceType")
                    .unmarshallLocationName("interfaceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_FIELD,
            MAC_ADDRESS_FIELD, SECONDARY_INTERFACE_ID_FIELD, OWNER_ID_FIELD, PRIVATE_IP_ADDRESSES_FIELD, SOURCE_DEST_CHECK_FIELD,
            STATUS_FIELD, SECONDARY_SUBNET_ID_FIELD, SECONDARY_NETWORK_ID_FIELD, INTERFACE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final InstanceSecondaryInterfaceAttachment attachment;

    private final String macAddress;

    private final String secondaryInterfaceId;

    private final String ownerId;

    private final List<InstanceSecondaryInterfacePrivateIpAddress> privateIpAddresses;

    private final Boolean sourceDestCheck;

    private final String status;

    private final String secondarySubnetId;

    private final String secondaryNetworkId;

    private final String interfaceType;

    private InstanceSecondaryInterface(BuilderImpl builder) {
        this.attachment = builder.attachment;
        this.macAddress = builder.macAddress;
        this.secondaryInterfaceId = builder.secondaryInterfaceId;
        this.ownerId = builder.ownerId;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.status = builder.status;
        this.secondarySubnetId = builder.secondarySubnetId;
        this.secondaryNetworkId = builder.secondaryNetworkId;
        this.interfaceType = builder.interfaceType;
    }

    /**
     * <p>
     * The attachment information for the secondary interface.
     * </p>
     * 
     * @return The attachment information for the secondary interface.
     */
    public final InstanceSecondaryInterfaceAttachment attachment() {
        return attachment;
    }

    /**
     * <p>
     * The MAC address of the secondary interface.
     * </p>
     * 
     * @return The MAC address of the secondary interface.
     */
    public final String macAddress() {
        return macAddress;
    }

    /**
     * <p>
     * The ID of the secondary interface.
     * </p>
     * 
     * @return The ID of the secondary interface.
     */
    public final String secondaryInterfaceId() {
        return secondaryInterfaceId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the owner of the secondary interface.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the owner of the secondary interface.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrivateIpAddresses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrivateIpAddresses() {
        return privateIpAddresses != null && !(privateIpAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The private IPv4 addresses associated with the secondary interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrivateIpAddresses} method.
     * </p>
     * 
     * @return The private IPv4 addresses associated with the secondary interface.
     */
    public final List<InstanceSecondaryInterfacePrivateIpAddress> privateIpAddresses() {
        return privateIpAddresses;
    }

    /**
     * <p>
     * Indicates whether source/destination checking is enabled.
     * </p>
     * 
     * @return Indicates whether source/destination checking is enabled.
     */
    public final Boolean sourceDestCheck() {
        return sourceDestCheck;
    }

    /**
     * <p>
     * The status of the secondary interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SecondaryInterfaceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the secondary interface.
     * @see SecondaryInterfaceStatus
     */
    public final SecondaryInterfaceStatus status() {
        return SecondaryInterfaceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the secondary interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SecondaryInterfaceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the secondary interface.
     * @see SecondaryInterfaceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The ID of the secondary subnet.
     * </p>
     * 
     * @return The ID of the secondary subnet.
     */
    public final String secondarySubnetId() {
        return secondarySubnetId;
    }

    /**
     * <p>
     * The ID of the secondary network.
     * </p>
     * 
     * @return The ID of the secondary network.
     */
    public final String secondaryNetworkId() {
        return secondaryNetworkId;
    }

    /**
     * <p>
     * The type of secondary interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interfaceType}
     * will return {@link SecondaryInterfaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #interfaceTypeAsString}.
     * </p>
     * 
     * @return The type of secondary interface.
     * @see SecondaryInterfaceType
     */
    public final SecondaryInterfaceType interfaceType() {
        return SecondaryInterfaceType.fromValue(interfaceType);
    }

    /**
     * <p>
     * The type of secondary interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interfaceType}
     * will return {@link SecondaryInterfaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #interfaceTypeAsString}.
     * </p>
     * 
     * @return The type of secondary interface.
     * @see SecondaryInterfaceType
     */
    public final String interfaceTypeAsString() {
        return interfaceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachment());
        hashCode = 31 * hashCode + Objects.hashCode(macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrivateIpAddresses() ? privateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourceDestCheck());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(secondarySubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(interfaceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceSecondaryInterface)) {
            return false;
        }
        InstanceSecondaryInterface other = (InstanceSecondaryInterface) obj;
        return Objects.equals(attachment(), other.attachment()) && Objects.equals(macAddress(), other.macAddress())
                && Objects.equals(secondaryInterfaceId(), other.secondaryInterfaceId())
                && Objects.equals(ownerId(), other.ownerId()) && hasPrivateIpAddresses() == other.hasPrivateIpAddresses()
                && Objects.equals(privateIpAddresses(), other.privateIpAddresses())
                && Objects.equals(sourceDestCheck(), other.sourceDestCheck())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(secondarySubnetId(), other.secondarySubnetId())
                && Objects.equals(secondaryNetworkId(), other.secondaryNetworkId())
                && Objects.equals(interfaceTypeAsString(), other.interfaceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceSecondaryInterface").add("Attachment", attachment()).add("MacAddress", macAddress())
                .add("SecondaryInterfaceId", secondaryInterfaceId()).add("OwnerId", ownerId())
                .add("PrivateIpAddresses", hasPrivateIpAddresses() ? privateIpAddresses() : null)
                .add("SourceDestCheck", sourceDestCheck()).add("Status", statusAsString())
                .add("SecondarySubnetId", secondarySubnetId()).add("SecondaryNetworkId", secondaryNetworkId())
                .add("InterfaceType", interfaceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attachment":
            return Optional.ofNullable(clazz.cast(attachment()));
        case "MacAddress":
            return Optional.ofNullable(clazz.cast(macAddress()));
        case "SecondaryInterfaceId":
            return Optional.ofNullable(clazz.cast(secondaryInterfaceId()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "PrivateIpAddresses":
            return Optional.ofNullable(clazz.cast(privateIpAddresses()));
        case "SourceDestCheck":
            return Optional.ofNullable(clazz.cast(sourceDestCheck()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "SecondarySubnetId":
            return Optional.ofNullable(clazz.cast(secondarySubnetId()));
        case "SecondaryNetworkId":
            return Optional.ofNullable(clazz.cast(secondaryNetworkId()));
        case "InterfaceType":
            return Optional.ofNullable(clazz.cast(interfaceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Attachment", ATTACHMENT_FIELD);
        map.put("MacAddress", MAC_ADDRESS_FIELD);
        map.put("SecondaryInterfaceId", SECONDARY_INTERFACE_ID_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("PrivateIpAddressSet", PRIVATE_IP_ADDRESSES_FIELD);
        map.put("SourceDestCheck", SOURCE_DEST_CHECK_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("SecondarySubnetId", SECONDARY_SUBNET_ID_FIELD);
        map.put("SecondaryNetworkId", SECONDARY_NETWORK_ID_FIELD);
        map.put("InterfaceType", INTERFACE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceSecondaryInterface, T> g) {
        return obj -> g.apply((InstanceSecondaryInterface) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceSecondaryInterface> {
        /**
         * <p>
         * The attachment information for the secondary interface.
         * </p>
         * 
         * @param attachment
         *        The attachment information for the secondary interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachment(InstanceSecondaryInterfaceAttachment attachment);

        /**
         * <p>
         * The attachment information for the secondary interface.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InstanceSecondaryInterfaceAttachment.Builder} avoiding the need to create one manually via
         * {@link InstanceSecondaryInterfaceAttachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceSecondaryInterfaceAttachment.Builder#build()} is called
         * immediately and its result is passed to {@link #attachment(InstanceSecondaryInterfaceAttachment)}.
         * 
         * @param attachment
         *        a consumer that will call methods on {@link InstanceSecondaryInterfaceAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachment(InstanceSecondaryInterfaceAttachment)
         */
        default Builder attachment(Consumer<InstanceSecondaryInterfaceAttachment.Builder> attachment) {
            return attachment(InstanceSecondaryInterfaceAttachment.builder().applyMutation(attachment).build());
        }

        /**
         * <p>
         * The MAC address of the secondary interface.
         * </p>
         * 
         * @param macAddress
         *        The MAC address of the secondary interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macAddress(String macAddress);

        /**
         * <p>
         * The ID of the secondary interface.
         * </p>
         * 
         * @param secondaryInterfaceId
         *        The ID of the secondary interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryInterfaceId(String secondaryInterfaceId);

        /**
         * <p>
         * The Amazon Web Services account ID of the owner of the secondary interface.
         * </p>
         * 
         * @param ownerId
         *        The Amazon Web Services account ID of the owner of the secondary interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The private IPv4 addresses associated with the secondary interface.
         * </p>
         * 
         * @param privateIpAddresses
         *        The private IPv4 addresses associated with the secondary interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(Collection<InstanceSecondaryInterfacePrivateIpAddress> privateIpAddresses);

        /**
         * <p>
         * The private IPv4 addresses associated with the secondary interface.
         * </p>
         * 
         * @param privateIpAddresses
         *        The private IPv4 addresses associated with the secondary interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(InstanceSecondaryInterfacePrivateIpAddress... privateIpAddresses);

        /**
         * <p>
         * The private IPv4 addresses associated with the secondary interface.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.InstanceSecondaryInterfacePrivateIpAddress.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.InstanceSecondaryInterfacePrivateIpAddress#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.InstanceSecondaryInterfacePrivateIpAddress.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #privateIpAddresses(List<InstanceSecondaryInterfacePrivateIpAddress>)}.
         * 
         * @param privateIpAddresses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.InstanceSecondaryInterfacePrivateIpAddress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateIpAddresses(java.util.Collection<InstanceSecondaryInterfacePrivateIpAddress>)
         */
        Builder privateIpAddresses(Consumer<InstanceSecondaryInterfacePrivateIpAddress.Builder>... privateIpAddresses);

        /**
         * <p>
         * Indicates whether source/destination checking is enabled.
         * </p>
         * 
         * @param sourceDestCheck
         *        Indicates whether source/destination checking is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDestCheck(Boolean sourceDestCheck);

        /**
         * <p>
         * The status of the secondary interface.
         * </p>
         * 
         * @param status
         *        The status of the secondary interface.
         * @see SecondaryInterfaceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecondaryInterfaceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the secondary interface.
         * </p>
         * 
         * @param status
         *        The status of the secondary interface.
         * @see SecondaryInterfaceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecondaryInterfaceStatus
         */
        Builder status(SecondaryInterfaceStatus status);

        /**
         * <p>
         * The ID of the secondary subnet.
         * </p>
         * 
         * @param secondarySubnetId
         *        The ID of the secondary subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondarySubnetId(String secondarySubnetId);

        /**
         * <p>
         * The ID of the secondary network.
         * </p>
         * 
         * @param secondaryNetworkId
         *        The ID of the secondary network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryNetworkId(String secondaryNetworkId);

        /**
         * <p>
         * The type of secondary interface.
         * </p>
         * 
         * @param interfaceType
         *        The type of secondary interface.
         * @see SecondaryInterfaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecondaryInterfaceType
         */
        Builder interfaceType(String interfaceType);

        /**
         * <p>
         * The type of secondary interface.
         * </p>
         * 
         * @param interfaceType
         *        The type of secondary interface.
         * @see SecondaryInterfaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecondaryInterfaceType
         */
        Builder interfaceType(SecondaryInterfaceType interfaceType);
    }

    static final class BuilderImpl implements Builder {
        private InstanceSecondaryInterfaceAttachment attachment;

        private String macAddress;

        private String secondaryInterfaceId;

        private String ownerId;

        private List<InstanceSecondaryInterfacePrivateIpAddress> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();

        private Boolean sourceDestCheck;

        private String status;

        private String secondarySubnetId;

        private String secondaryNetworkId;

        private String interfaceType;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceSecondaryInterface model) {
            attachment(model.attachment);
            macAddress(model.macAddress);
            secondaryInterfaceId(model.secondaryInterfaceId);
            ownerId(model.ownerId);
            privateIpAddresses(model.privateIpAddresses);
            sourceDestCheck(model.sourceDestCheck);
            status(model.status);
            secondarySubnetId(model.secondarySubnetId);
            secondaryNetworkId(model.secondaryNetworkId);
            interfaceType(model.interfaceType);
        }

        public final InstanceSecondaryInterfaceAttachment.Builder getAttachment() {
            return attachment != null ? attachment.toBuilder() : null;
        }

        public final void setAttachment(InstanceSecondaryInterfaceAttachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        @Override
        public final Builder attachment(InstanceSecondaryInterfaceAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final String getMacAddress() {
            return macAddress;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final String getSecondaryInterfaceId() {
            return secondaryInterfaceId;
        }

        public final void setSecondaryInterfaceId(String secondaryInterfaceId) {
            this.secondaryInterfaceId = secondaryInterfaceId;
        }

        @Override
        public final Builder secondaryInterfaceId(String secondaryInterfaceId) {
            this.secondaryInterfaceId = secondaryInterfaceId;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final List<InstanceSecondaryInterfacePrivateIpAddress.Builder> getPrivateIpAddresses() {
            List<InstanceSecondaryInterfacePrivateIpAddress.Builder> result = InstanceSecondaryInterfacePrivateIpAddressListCopier
                    .copyToBuilder(this.privateIpAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrivateIpAddresses(
                Collection<InstanceSecondaryInterfacePrivateIpAddress.BuilderImpl> privateIpAddresses) {
            this.privateIpAddresses = InstanceSecondaryInterfacePrivateIpAddressListCopier.copyFromBuilder(privateIpAddresses);
        }

        @Override
        public final Builder privateIpAddresses(Collection<InstanceSecondaryInterfacePrivateIpAddress> privateIpAddresses) {
            this.privateIpAddresses = InstanceSecondaryInterfacePrivateIpAddressListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(InstanceSecondaryInterfacePrivateIpAddress... privateIpAddresses) {
            privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(
                Consumer<InstanceSecondaryInterfacePrivateIpAddress.Builder>... privateIpAddresses) {
            privateIpAddresses(Stream.of(privateIpAddresses)
                    .map(c -> InstanceSecondaryInterfacePrivateIpAddress.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getSourceDestCheck() {
            return sourceDestCheck;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SecondaryInterfaceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSecondarySubnetId() {
            return secondarySubnetId;
        }

        public final void setSecondarySubnetId(String secondarySubnetId) {
            this.secondarySubnetId = secondarySubnetId;
        }

        @Override
        public final Builder secondarySubnetId(String secondarySubnetId) {
            this.secondarySubnetId = secondarySubnetId;
            return this;
        }

        public final String getSecondaryNetworkId() {
            return secondaryNetworkId;
        }

        public final void setSecondaryNetworkId(String secondaryNetworkId) {
            this.secondaryNetworkId = secondaryNetworkId;
        }

        @Override
        public final Builder secondaryNetworkId(String secondaryNetworkId) {
            this.secondaryNetworkId = secondaryNetworkId;
            return this;
        }

        public final String getInterfaceType() {
            return interfaceType;
        }

        public final void setInterfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
        }

        @Override
        public final Builder interfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
            return this;
        }

        @Override
        public final Builder interfaceType(SecondaryInterfaceType interfaceType) {
            this.interfaceType(interfaceType == null ? null : interfaceType.toString());
            return this;
        }

        @Override
        public InstanceSecondaryInterface build() {
            return new InstanceSecondaryInterface(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
