/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The DNS names of the endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceConnectEndpointDnsNames implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceConnectEndpointDnsNames.Builder, InstanceConnectEndpointDnsNames> {
    private static final SdkField<String> DNS_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DnsName")
            .getter(getter(InstanceConnectEndpointDnsNames::dnsName))
            .setter(setter(Builder::dnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsName")
                    .unmarshallLocationName("dnsName").build()).build();

    private static final SdkField<String> FIPS_DNS_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FipsDnsName")
            .getter(getter(InstanceConnectEndpointDnsNames::fipsDnsName))
            .setter(setter(Builder::fipsDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FipsDnsName")
                    .unmarshallLocationName("fipsDnsName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DNS_NAME_FIELD,
            FIPS_DNS_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dnsName;

    private final String fipsDnsName;

    private InstanceConnectEndpointDnsNames(BuilderImpl builder) {
        this.dnsName = builder.dnsName;
        this.fipsDnsName = builder.fipsDnsName;
    }

    /**
     * <p>
     * The DNS name of the EC2 Instance Connect Endpoint.
     * </p>
     * 
     * @return The DNS name of the EC2 Instance Connect Endpoint.
     */
    public final String dnsName() {
        return dnsName;
    }

    /**
     * <p>
     * The Federal Information Processing Standards (FIPS) compliant DNS name of the EC2 Instance Connect Endpoint.
     * </p>
     * 
     * @return The Federal Information Processing Standards (FIPS) compliant DNS name of the EC2 Instance Connect
     *         Endpoint.
     */
    public final String fipsDnsName() {
        return fipsDnsName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(fipsDnsName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceConnectEndpointDnsNames)) {
            return false;
        }
        InstanceConnectEndpointDnsNames other = (InstanceConnectEndpointDnsNames) obj;
        return Objects.equals(dnsName(), other.dnsName()) && Objects.equals(fipsDnsName(), other.fipsDnsName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceConnectEndpointDnsNames").add("DnsName", dnsName()).add("FipsDnsName", fipsDnsName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DnsName":
            return Optional.ofNullable(clazz.cast(dnsName()));
        case "FipsDnsName":
            return Optional.ofNullable(clazz.cast(fipsDnsName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DnsName", DNS_NAME_FIELD);
        map.put("FipsDnsName", FIPS_DNS_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceConnectEndpointDnsNames, T> g) {
        return obj -> g.apply((InstanceConnectEndpointDnsNames) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceConnectEndpointDnsNames> {
        /**
         * <p>
         * The DNS name of the EC2 Instance Connect Endpoint.
         * </p>
         * 
         * @param dnsName
         *        The DNS name of the EC2 Instance Connect Endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsName(String dnsName);

        /**
         * <p>
         * The Federal Information Processing Standards (FIPS) compliant DNS name of the EC2 Instance Connect Endpoint.
         * </p>
         * 
         * @param fipsDnsName
         *        The Federal Information Processing Standards (FIPS) compliant DNS name of the EC2 Instance Connect
         *        Endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fipsDnsName(String fipsDnsName);
    }

    static final class BuilderImpl implements Builder {
        private String dnsName;

        private String fipsDnsName;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceConnectEndpointDnsNames model) {
            dnsName(model.dnsName);
            fipsDnsName(model.fipsDnsName);
        }

        public final String getDnsName() {
            return dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final String getFipsDnsName() {
            return fipsDnsName;
        }

        public final void setFipsDnsName(String fipsDnsName) {
            this.fipsDnsName = fipsDnsName;
        }

        @Override
        public final Builder fipsDnsName(String fipsDnsName) {
            this.fipsDnsName = fipsDnsName;
            return this;
        }

        @Override
        public InstanceConnectEndpointDnsNames build() {
            return new InstanceConnectEndpointDnsNames(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
