/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum FilterByDimension {
    RESOURCE_REGION("resource-region"),

    AVAILABILITY_ZONE_ID("availability-zone-id"),

    ACCOUNT_ID("account-id"),

    INSTANCE_FAMILY("instance-family"),

    INSTANCE_TYPE("instance-type"),

    INSTANCE_PLATFORM("instance-platform"),

    RESERVATION_ARN("reservation-arn"),

    RESERVATION_ID("reservation-id"),

    RESERVATION_TYPE("reservation-type"),

    RESERVATION_CREATE_TIMESTAMP("reservation-create-timestamp"),

    RESERVATION_START_TIMESTAMP("reservation-start-timestamp"),

    RESERVATION_END_TIMESTAMP("reservation-end-timestamp"),

    RESERVATION_END_DATE_TYPE("reservation-end-date-type"),

    TENANCY("tenancy"),

    RESERVATION_STATE("reservation-state"),

    RESERVATION_INSTANCE_MATCH_CRITERIA("reservation-instance-match-criteria"),

    RESERVATION_UNUSED_FINANCIAL_OWNER("reservation-unused-financial-owner"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FilterByDimension> VALUE_MAP = EnumUtils.uniqueIndex(FilterByDimension.class,
            FilterByDimension::toString);

    private final String value;

    private FilterByDimension(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return FilterByDimension corresponding to the value
     */
    public static FilterByDimension fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link FilterByDimension}s
     */
    public static Set<FilterByDimension> knownValues() {
        Set<FilterByDimension> knownValues = EnumSet.allOf(FilterByDimension.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
