/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrafficMirrorFilterRuleRequest extends Ec2Request implements
        ToCopyableBuilder<CreateTrafficMirrorFilterRuleRequest.Builder, CreateTrafficMirrorFilterRuleRequest> {
    private static final SdkField<String> TRAFFIC_MIRROR_FILTER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrafficMirrorFilterId")
            .getter(getter(CreateTrafficMirrorFilterRuleRequest::trafficMirrorFilterId))
            .setter(setter(Builder::trafficMirrorFilterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterId")
                    .unmarshallLocationName("TrafficMirrorFilterId").build()).build();

    private static final SdkField<String> TRAFFIC_DIRECTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrafficDirection")
            .getter(getter(CreateTrafficMirrorFilterRuleRequest::trafficDirectionAsString))
            .setter(setter(Builder::trafficDirection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficDirection")
                    .unmarshallLocationName("TrafficDirection").build()).build();

    private static final SdkField<Integer> RULE_NUMBER_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("RuleNumber")
            .getter(getter(CreateTrafficMirrorFilterRuleRequest::ruleNumber))
            .setter(setter(Builder::ruleNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleNumber")
                    .unmarshallLocationName("RuleNumber").build()).build();

    private static final SdkField<String> RULE_ACTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RuleAction")
            .getter(getter(CreateTrafficMirrorFilterRuleRequest::ruleActionAsString))
            .setter(setter(Builder::ruleAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleAction")
                    .unmarshallLocationName("RuleAction").build()).build();

    private static final SdkField<TrafficMirrorPortRangeRequest> DESTINATION_PORT_RANGE_FIELD = SdkField
            .<TrafficMirrorPortRangeRequest> builder(MarshallingType.SDK_POJO)
            .memberName("DestinationPortRange")
            .getter(getter(CreateTrafficMirrorFilterRuleRequest::destinationPortRange))
            .setter(setter(Builder::destinationPortRange))
            .constructor(TrafficMirrorPortRangeRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPortRange")
                    .unmarshallLocationName("DestinationPortRange").build()).build();

    private static final SdkField<TrafficMirrorPortRangeRequest> SOURCE_PORT_RANGE_FIELD = SdkField
            .<TrafficMirrorPortRangeRequest> builder(MarshallingType.SDK_POJO)
            .memberName("SourcePortRange")
            .getter(getter(CreateTrafficMirrorFilterRuleRequest::sourcePortRange))
            .setter(setter(Builder::sourcePortRange))
            .constructor(TrafficMirrorPortRangeRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePortRange")
                    .unmarshallLocationName("SourcePortRange").build()).build();

    private static final SdkField<Integer> PROTOCOL_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Protocol")
            .getter(getter(CreateTrafficMirrorFilterRuleRequest::protocol))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol")
                    .unmarshallLocationName("Protocol").build()).build();

    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationCidrBlock")
            .getter(getter(CreateTrafficMirrorFilterRuleRequest::destinationCidrBlock))
            .setter(setter(Builder::destinationCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock")
                    .unmarshallLocationName("DestinationCidrBlock").build()).build();

    private static final SdkField<String> SOURCE_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceCidrBlock")
            .getter(getter(CreateTrafficMirrorFilterRuleRequest::sourceCidrBlock))
            .setter(setter(Builder::sourceCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCidrBlock")
                    .unmarshallLocationName("SourceCidrBlock").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(CreateTrafficMirrorFilterRuleRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(CreateTrafficMirrorFilterRuleRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateTrafficMirrorFilterRuleRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateTrafficMirrorFilterRuleRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRAFFIC_MIRROR_FILTER_ID_FIELD, TRAFFIC_DIRECTION_FIELD, RULE_NUMBER_FIELD, RULE_ACTION_FIELD,
            DESTINATION_PORT_RANGE_FIELD, SOURCE_PORT_RANGE_FIELD, PROTOCOL_FIELD, DESTINATION_CIDR_BLOCK_FIELD,
            SOURCE_CIDR_BLOCK_FIELD, DESCRIPTION_FIELD, DRY_RUN_FIELD, CLIENT_TOKEN_FIELD, TAG_SPECIFICATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String trafficMirrorFilterId;

    private final String trafficDirection;

    private final Integer ruleNumber;

    private final String ruleAction;

    private final TrafficMirrorPortRangeRequest destinationPortRange;

    private final TrafficMirrorPortRangeRequest sourcePortRange;

    private final Integer protocol;

    private final String destinationCidrBlock;

    private final String sourceCidrBlock;

    private final String description;

    private final Boolean dryRun;

    private final String clientToken;

    private final List<TagSpecification> tagSpecifications;

    private CreateTrafficMirrorFilterRuleRequest(BuilderImpl builder) {
        super(builder);
        this.trafficMirrorFilterId = builder.trafficMirrorFilterId;
        this.trafficDirection = builder.trafficDirection;
        this.ruleNumber = builder.ruleNumber;
        this.ruleAction = builder.ruleAction;
        this.destinationPortRange = builder.destinationPortRange;
        this.sourcePortRange = builder.sourcePortRange;
        this.protocol = builder.protocol;
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.sourceCidrBlock = builder.sourceCidrBlock;
        this.description = builder.description;
        this.dryRun = builder.dryRun;
        this.clientToken = builder.clientToken;
        this.tagSpecifications = builder.tagSpecifications;
    }

    /**
     * <p>
     * The ID of the filter that this rule is associated with.
     * </p>
     * 
     * @return The ID of the filter that this rule is associated with.
     */
    public final String trafficMirrorFilterId() {
        return trafficMirrorFilterId;
    }

    /**
     * <p>
     * The type of traffic.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trafficDirection}
     * will return {@link TrafficDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #trafficDirectionAsString}.
     * </p>
     * 
     * @return The type of traffic.
     * @see TrafficDirection
     */
    public final TrafficDirection trafficDirection() {
        return TrafficDirection.fromValue(trafficDirection);
    }

    /**
     * <p>
     * The type of traffic.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trafficDirection}
     * will return {@link TrafficDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #trafficDirectionAsString}.
     * </p>
     * 
     * @return The type of traffic.
     * @see TrafficDirection
     */
    public final String trafficDirectionAsString() {
        return trafficDirection;
    }

    /**
     * <p>
     * The number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given
     * direction. The rules are processed in ascending order by rule number.
     * </p>
     * 
     * @return The number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given
     *         direction. The rules are processed in ascending order by rule number.
     */
    public final Integer ruleNumber() {
        return ruleNumber;
    }

    /**
     * <p>
     * The action to take on the filtered traffic.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleAction} will
     * return {@link TrafficMirrorRuleAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ruleActionAsString}.
     * </p>
     * 
     * @return The action to take on the filtered traffic.
     * @see TrafficMirrorRuleAction
     */
    public final TrafficMirrorRuleAction ruleAction() {
        return TrafficMirrorRuleAction.fromValue(ruleAction);
    }

    /**
     * <p>
     * The action to take on the filtered traffic.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleAction} will
     * return {@link TrafficMirrorRuleAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ruleActionAsString}.
     * </p>
     * 
     * @return The action to take on the filtered traffic.
     * @see TrafficMirrorRuleAction
     */
    public final String ruleActionAsString() {
        return ruleAction;
    }

    /**
     * <p>
     * The destination port range.
     * </p>
     * 
     * @return The destination port range.
     */
    public final TrafficMirrorPortRangeRequest destinationPortRange() {
        return destinationPortRange;
    }

    /**
     * <p>
     * The source port range.
     * </p>
     * 
     * @return The source port range.
     */
    public final TrafficMirrorPortRangeRequest sourcePortRange() {
        return sourcePortRange;
    }

    /**
     * <p>
     * The protocol, for example UDP, to assign to the Traffic Mirror rule.
     * </p>
     * <p>
     * For information about the protocol value, see <a
     * href="https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a> on the
     * Internet Assigned Numbers Authority (IANA) website.
     * </p>
     * 
     * @return The protocol, for example UDP, to assign to the Traffic Mirror rule.</p>
     *         <p>
     *         For information about the protocol value, see <a
     *         href="https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a> on
     *         the Internet Assigned Numbers Authority (IANA) website.
     */
    public final Integer protocol() {
        return protocol;
    }

    /**
     * <p>
     * The destination CIDR block to assign to the Traffic Mirror rule.
     * </p>
     * 
     * @return The destination CIDR block to assign to the Traffic Mirror rule.
     */
    public final String destinationCidrBlock() {
        return destinationCidrBlock;
    }

    /**
     * <p>
     * The source CIDR block to assign to the Traffic Mirror rule.
     * </p>
     * 
     * @return The source CIDR block to assign to the Traffic Mirror rule.
     */
    public final String sourceCidrBlock() {
        return sourceCidrBlock;
    }

    /**
     * <p>
     * The description of the Traffic Mirror rule.
     * </p>
     * 
     * @return The description of the Traffic Mirror rule.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">How to ensure
     * idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">How
     *         to ensure idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Traffic Mirroring tags specifications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return Traffic Mirroring tags specifications.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorFilterId());
        hashCode = 31 * hashCode + Objects.hashCode(trafficDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ruleNumber());
        hashCode = 31 * hashCode + Objects.hashCode(ruleActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPortRange());
        hashCode = 31 * hashCode + Objects.hashCode(sourcePortRange());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficMirrorFilterRuleRequest)) {
            return false;
        }
        CreateTrafficMirrorFilterRuleRequest other = (CreateTrafficMirrorFilterRuleRequest) obj;
        return Objects.equals(trafficMirrorFilterId(), other.trafficMirrorFilterId())
                && Objects.equals(trafficDirectionAsString(), other.trafficDirectionAsString())
                && Objects.equals(ruleNumber(), other.ruleNumber())
                && Objects.equals(ruleActionAsString(), other.ruleActionAsString())
                && Objects.equals(destinationPortRange(), other.destinationPortRange())
                && Objects.equals(sourcePortRange(), other.sourcePortRange()) && Objects.equals(protocol(), other.protocol())
                && Objects.equals(destinationCidrBlock(), other.destinationCidrBlock())
                && Objects.equals(sourceCidrBlock(), other.sourceCidrBlock())
                && Objects.equals(description(), other.description()) && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(clientToken(), other.clientToken()) && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTrafficMirrorFilterRuleRequest").add("TrafficMirrorFilterId", trafficMirrorFilterId())
                .add("TrafficDirection", trafficDirectionAsString()).add("RuleNumber", ruleNumber())
                .add("RuleAction", ruleActionAsString()).add("DestinationPortRange", destinationPortRange())
                .add("SourcePortRange", sourcePortRange()).add("Protocol", protocol())
                .add("DestinationCidrBlock", destinationCidrBlock()).add("SourceCidrBlock", sourceCidrBlock())
                .add("Description", description()).add("DryRun", dryRun()).add("ClientToken", clientToken())
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficMirrorFilterId":
            return Optional.ofNullable(clazz.cast(trafficMirrorFilterId()));
        case "TrafficDirection":
            return Optional.ofNullable(clazz.cast(trafficDirectionAsString()));
        case "RuleNumber":
            return Optional.ofNullable(clazz.cast(ruleNumber()));
        case "RuleAction":
            return Optional.ofNullable(clazz.cast(ruleActionAsString()));
        case "DestinationPortRange":
            return Optional.ofNullable(clazz.cast(destinationPortRange()));
        case "SourcePortRange":
            return Optional.ofNullable(clazz.cast(sourcePortRange()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "DestinationCidrBlock":
            return Optional.ofNullable(clazz.cast(destinationCidrBlock()));
        case "SourceCidrBlock":
            return Optional.ofNullable(clazz.cast(sourceCidrBlock()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrafficMirrorFilterId", TRAFFIC_MIRROR_FILTER_ID_FIELD);
        map.put("TrafficDirection", TRAFFIC_DIRECTION_FIELD);
        map.put("RuleNumber", RULE_NUMBER_FIELD);
        map.put("RuleAction", RULE_ACTION_FIELD);
        map.put("DestinationPortRange", DESTINATION_PORT_RANGE_FIELD);
        map.put("SourcePortRange", SOURCE_PORT_RANGE_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("DestinationCidrBlock", DESTINATION_CIDR_BLOCK_FIELD);
        map.put("SourceCidrBlock", SOURCE_CIDR_BLOCK_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTrafficMirrorFilterRuleRequest, T> g) {
        return obj -> g.apply((CreateTrafficMirrorFilterRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateTrafficMirrorFilterRuleRequest> {
        /**
         * <p>
         * The ID of the filter that this rule is associated with.
         * </p>
         * 
         * @param trafficMirrorFilterId
         *        The ID of the filter that this rule is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorFilterId(String trafficMirrorFilterId);

        /**
         * <p>
         * The type of traffic.
         * </p>
         * 
         * @param trafficDirection
         *        The type of traffic.
         * @see TrafficDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficDirection
         */
        Builder trafficDirection(String trafficDirection);

        /**
         * <p>
         * The type of traffic.
         * </p>
         * 
         * @param trafficDirection
         *        The type of traffic.
         * @see TrafficDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficDirection
         */
        Builder trafficDirection(TrafficDirection trafficDirection);

        /**
         * <p>
         * The number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given
         * direction. The rules are processed in ascending order by rule number.
         * </p>
         * 
         * @param ruleNumber
         *        The number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a
         *        given direction. The rules are processed in ascending order by rule number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleNumber(Integer ruleNumber);

        /**
         * <p>
         * The action to take on the filtered traffic.
         * </p>
         * 
         * @param ruleAction
         *        The action to take on the filtered traffic.
         * @see TrafficMirrorRuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficMirrorRuleAction
         */
        Builder ruleAction(String ruleAction);

        /**
         * <p>
         * The action to take on the filtered traffic.
         * </p>
         * 
         * @param ruleAction
         *        The action to take on the filtered traffic.
         * @see TrafficMirrorRuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficMirrorRuleAction
         */
        Builder ruleAction(TrafficMirrorRuleAction ruleAction);

        /**
         * <p>
         * The destination port range.
         * </p>
         * 
         * @param destinationPortRange
         *        The destination port range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPortRange(TrafficMirrorPortRangeRequest destinationPortRange);

        /**
         * <p>
         * The destination port range.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrafficMirrorPortRangeRequest.Builder}
         * avoiding the need to create one manually via {@link TrafficMirrorPortRangeRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrafficMirrorPortRangeRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #destinationPortRange(TrafficMirrorPortRangeRequest)}.
         * 
         * @param destinationPortRange
         *        a consumer that will call methods on {@link TrafficMirrorPortRangeRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationPortRange(TrafficMirrorPortRangeRequest)
         */
        default Builder destinationPortRange(Consumer<TrafficMirrorPortRangeRequest.Builder> destinationPortRange) {
            return destinationPortRange(TrafficMirrorPortRangeRequest.builder().applyMutation(destinationPortRange).build());
        }

        /**
         * <p>
         * The source port range.
         * </p>
         * 
         * @param sourcePortRange
         *        The source port range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePortRange(TrafficMirrorPortRangeRequest sourcePortRange);

        /**
         * <p>
         * The source port range.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrafficMirrorPortRangeRequest.Builder}
         * avoiding the need to create one manually via {@link TrafficMirrorPortRangeRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrafficMirrorPortRangeRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #sourcePortRange(TrafficMirrorPortRangeRequest)}.
         * 
         * @param sourcePortRange
         *        a consumer that will call methods on {@link TrafficMirrorPortRangeRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourcePortRange(TrafficMirrorPortRangeRequest)
         */
        default Builder sourcePortRange(Consumer<TrafficMirrorPortRangeRequest.Builder> sourcePortRange) {
            return sourcePortRange(TrafficMirrorPortRangeRequest.builder().applyMutation(sourcePortRange).build());
        }

        /**
         * <p>
         * The protocol, for example UDP, to assign to the Traffic Mirror rule.
         * </p>
         * <p>
         * For information about the protocol value, see <a
         * href="https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a> on the
         * Internet Assigned Numbers Authority (IANA) website.
         * </p>
         * 
         * @param protocol
         *        The protocol, for example UDP, to assign to the Traffic Mirror rule.</p>
         *        <p>
         *        For information about the protocol value, see <a
         *        href="https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>
         *        on the Internet Assigned Numbers Authority (IANA) website.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(Integer protocol);

        /**
         * <p>
         * The destination CIDR block to assign to the Traffic Mirror rule.
         * </p>
         * 
         * @param destinationCidrBlock
         *        The destination CIDR block to assign to the Traffic Mirror rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidrBlock(String destinationCidrBlock);

        /**
         * <p>
         * The source CIDR block to assign to the Traffic Mirror rule.
         * </p>
         * 
         * @param sourceCidrBlock
         *        The source CIDR block to assign to the Traffic Mirror rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCidrBlock(String sourceCidrBlock);

        /**
         * <p>
         * The description of the Traffic Mirror rule.
         * </p>
         * 
         * @param description
         *        The description of the Traffic Mirror rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">How to
         * ensure idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">How to ensure
         *        idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Traffic Mirroring tags specifications.
         * </p>
         * 
         * @param tagSpecifications
         *        Traffic Mirroring tags specifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * Traffic Mirroring tags specifications.
         * </p>
         * 
         * @param tagSpecifications
         *        Traffic Mirroring tags specifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * Traffic Mirroring tags specifications.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String trafficMirrorFilterId;

        private String trafficDirection;

        private Integer ruleNumber;

        private String ruleAction;

        private TrafficMirrorPortRangeRequest destinationPortRange;

        private TrafficMirrorPortRangeRequest sourcePortRange;

        private Integer protocol;

        private String destinationCidrBlock;

        private String sourceCidrBlock;

        private String description;

        private Boolean dryRun;

        private String clientToken;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrafficMirrorFilterRuleRequest model) {
            super(model);
            trafficMirrorFilterId(model.trafficMirrorFilterId);
            trafficDirection(model.trafficDirection);
            ruleNumber(model.ruleNumber);
            ruleAction(model.ruleAction);
            destinationPortRange(model.destinationPortRange);
            sourcePortRange(model.sourcePortRange);
            protocol(model.protocol);
            destinationCidrBlock(model.destinationCidrBlock);
            sourceCidrBlock(model.sourceCidrBlock);
            description(model.description);
            dryRun(model.dryRun);
            clientToken(model.clientToken);
            tagSpecifications(model.tagSpecifications);
        }

        public final String getTrafficMirrorFilterId() {
            return trafficMirrorFilterId;
        }

        public final void setTrafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
        }

        @Override
        public final Builder trafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
            return this;
        }

        public final String getTrafficDirection() {
            return trafficDirection;
        }

        public final void setTrafficDirection(String trafficDirection) {
            this.trafficDirection = trafficDirection;
        }

        @Override
        public final Builder trafficDirection(String trafficDirection) {
            this.trafficDirection = trafficDirection;
            return this;
        }

        @Override
        public final Builder trafficDirection(TrafficDirection trafficDirection) {
            this.trafficDirection(trafficDirection == null ? null : trafficDirection.toString());
            return this;
        }

        public final Integer getRuleNumber() {
            return ruleNumber;
        }

        public final void setRuleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
        }

        @Override
        public final Builder ruleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        public final String getRuleAction() {
            return ruleAction;
        }

        public final void setRuleAction(String ruleAction) {
            this.ruleAction = ruleAction;
        }

        @Override
        public final Builder ruleAction(String ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        @Override
        public final Builder ruleAction(TrafficMirrorRuleAction ruleAction) {
            this.ruleAction(ruleAction == null ? null : ruleAction.toString());
            return this;
        }

        public final TrafficMirrorPortRangeRequest.Builder getDestinationPortRange() {
            return destinationPortRange != null ? destinationPortRange.toBuilder() : null;
        }

        public final void setDestinationPortRange(TrafficMirrorPortRangeRequest.BuilderImpl destinationPortRange) {
            this.destinationPortRange = destinationPortRange != null ? destinationPortRange.build() : null;
        }

        @Override
        public final Builder destinationPortRange(TrafficMirrorPortRangeRequest destinationPortRange) {
            this.destinationPortRange = destinationPortRange;
            return this;
        }

        public final TrafficMirrorPortRangeRequest.Builder getSourcePortRange() {
            return sourcePortRange != null ? sourcePortRange.toBuilder() : null;
        }

        public final void setSourcePortRange(TrafficMirrorPortRangeRequest.BuilderImpl sourcePortRange) {
            this.sourcePortRange = sourcePortRange != null ? sourcePortRange.build() : null;
        }

        @Override
        public final Builder sourcePortRange(TrafficMirrorPortRangeRequest sourcePortRange) {
            this.sourcePortRange = sourcePortRange;
            return this;
        }

        public final Integer getProtocol() {
            return protocol;
        }

        public final void setProtocol(Integer protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(Integer protocol) {
            this.protocol = protocol;
            return this;
        }

        public final String getDestinationCidrBlock() {
            return destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final String getSourceCidrBlock() {
            return sourceCidrBlock;
        }

        public final void setSourceCidrBlock(String sourceCidrBlock) {
            this.sourceCidrBlock = sourceCidrBlock;
        }

        @Override
        public final Builder sourceCidrBlock(String sourceCidrBlock) {
            this.sourceCidrBlock = sourceCidrBlock;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrafficMirrorFilterRuleRequest build() {
            return new CreateTrafficMirrorFilterRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
