/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.GetIpamPrefixListResolverVersionEntriesRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamPrefixListResolverVersionEntriesResponse;
import software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverVersionEntry;

public class GetIpamPrefixListResolverVersionEntriesPublisher
implements SdkPublisher<GetIpamPrefixListResolverVersionEntriesResponse> {
    private final Ec2AsyncClient client;
    private final GetIpamPrefixListResolverVersionEntriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetIpamPrefixListResolverVersionEntriesPublisher(Ec2AsyncClient client, GetIpamPrefixListResolverVersionEntriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetIpamPrefixListResolverVersionEntriesPublisher(Ec2AsyncClient client, GetIpamPrefixListResolverVersionEntriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetIpamPrefixListResolverVersionEntriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetIpamPrefixListResolverVersionEntriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IpamPrefixListResolverVersionEntry> entries() {
        return this.flatMapIterable(response -> response.entries());
    }

    private class GetIpamPrefixListResolverVersionEntriesResponseFetcher
    implements AsyncPageFetcher<GetIpamPrefixListResolverVersionEntriesResponse> {
        private GetIpamPrefixListResolverVersionEntriesResponseFetcher() {
        }

        public boolean hasNextPage(GetIpamPrefixListResolverVersionEntriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetIpamPrefixListResolverVersionEntriesResponse> nextPage(GetIpamPrefixListResolverVersionEntriesResponse previousPage) {
            if (previousPage == null) {
                return GetIpamPrefixListResolverVersionEntriesPublisher.this.client.getIpamPrefixListResolverVersionEntries(GetIpamPrefixListResolverVersionEntriesPublisher.this.firstRequest);
            }
            return GetIpamPrefixListResolverVersionEntriesPublisher.this.client.getIpamPrefixListResolverVersionEntries((GetIpamPrefixListResolverVersionEntriesRequest)((Object)GetIpamPrefixListResolverVersionEntriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

