/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.InstanceSecondaryInterfaceAttachment;
import software.amazon.awssdk.services.ec2.model.InstanceSecondaryInterfacePrivateIpAddress;
import software.amazon.awssdk.services.ec2.model.InstanceSecondaryInterfacePrivateIpAddressListCopier;
import software.amazon.awssdk.services.ec2.model.SecondaryInterfaceStatus;
import software.amazon.awssdk.services.ec2.model.SecondaryInterfaceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceSecondaryInterface
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceSecondaryInterface> {
    private static final SdkField<InstanceSecondaryInterfaceAttachment> ATTACHMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Attachment").getter(InstanceSecondaryInterface.getter(InstanceSecondaryInterface::attachment)).setter(InstanceSecondaryInterface.setter(Builder::attachment)).constructor(InstanceSecondaryInterfaceAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment").unmarshallLocationName("attachment").build()}).build();
    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MacAddress").getter(InstanceSecondaryInterface.getter(InstanceSecondaryInterface::macAddress)).setter(InstanceSecondaryInterface.setter(Builder::macAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacAddress").unmarshallLocationName("macAddress").build()}).build();
    private static final SdkField<String> SECONDARY_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecondaryInterfaceId").getter(InstanceSecondaryInterface.getter(InstanceSecondaryInterface::secondaryInterfaceId)).setter(InstanceSecondaryInterface.setter(Builder::secondaryInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryInterfaceId").unmarshallLocationName("secondaryInterfaceId").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(InstanceSecondaryInterface.getter(InstanceSecondaryInterface::ownerId)).setter(InstanceSecondaryInterface.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<List<InstanceSecondaryInterfacePrivateIpAddress>> PRIVATE_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrivateIpAddresses").getter(InstanceSecondaryInterface.getter(InstanceSecondaryInterface::privateIpAddresses)).setter(InstanceSecondaryInterface.setter(Builder::privateIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddressSet").unmarshallLocationName("privateIpAddressSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceSecondaryInterfacePrivateIpAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SOURCE_DEST_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SourceDestCheck").getter(InstanceSecondaryInterface.getter(InstanceSecondaryInterface::sourceDestCheck)).setter(InstanceSecondaryInterface.setter(Builder::sourceDestCheck)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDestCheck").unmarshallLocationName("sourceDestCheck").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(InstanceSecondaryInterface.getter(InstanceSecondaryInterface::statusAsString)).setter(InstanceSecondaryInterface.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> SECONDARY_SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecondarySubnetId").getter(InstanceSecondaryInterface.getter(InstanceSecondaryInterface::secondarySubnetId)).setter(InstanceSecondaryInterface.setter(Builder::secondarySubnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondarySubnetId").unmarshallLocationName("secondarySubnetId").build()}).build();
    private static final SdkField<String> SECONDARY_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecondaryNetworkId").getter(InstanceSecondaryInterface.getter(InstanceSecondaryInterface::secondaryNetworkId)).setter(InstanceSecondaryInterface.setter(Builder::secondaryNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryNetworkId").unmarshallLocationName("secondaryNetworkId").build()}).build();
    private static final SdkField<String> INTERFACE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InterfaceType").getter(InstanceSecondaryInterface.getter(InstanceSecondaryInterface::interfaceTypeAsString)).setter(InstanceSecondaryInterface.setter(Builder::interfaceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterfaceType").unmarshallLocationName("interfaceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_FIELD, MAC_ADDRESS_FIELD, SECONDARY_INTERFACE_ID_FIELD, OWNER_ID_FIELD, PRIVATE_IP_ADDRESSES_FIELD, SOURCE_DEST_CHECK_FIELD, STATUS_FIELD, SECONDARY_SUBNET_ID_FIELD, SECONDARY_NETWORK_ID_FIELD, INTERFACE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceSecondaryInterface.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final InstanceSecondaryInterfaceAttachment attachment;
    private final String macAddress;
    private final String secondaryInterfaceId;
    private final String ownerId;
    private final List<InstanceSecondaryInterfacePrivateIpAddress> privateIpAddresses;
    private final Boolean sourceDestCheck;
    private final String status;
    private final String secondarySubnetId;
    private final String secondaryNetworkId;
    private final String interfaceType;

    private InstanceSecondaryInterface(BuilderImpl builder) {
        this.attachment = builder.attachment;
        this.macAddress = builder.macAddress;
        this.secondaryInterfaceId = builder.secondaryInterfaceId;
        this.ownerId = builder.ownerId;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.status = builder.status;
        this.secondarySubnetId = builder.secondarySubnetId;
        this.secondaryNetworkId = builder.secondaryNetworkId;
        this.interfaceType = builder.interfaceType;
    }

    public final InstanceSecondaryInterfaceAttachment attachment() {
        return this.attachment;
    }

    public final String macAddress() {
        return this.macAddress;
    }

    public final String secondaryInterfaceId() {
        return this.secondaryInterfaceId;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final boolean hasPrivateIpAddresses() {
        return this.privateIpAddresses != null && !(this.privateIpAddresses instanceof SdkAutoConstructList);
    }

    public final List<InstanceSecondaryInterfacePrivateIpAddress> privateIpAddresses() {
        return this.privateIpAddresses;
    }

    public final Boolean sourceDestCheck() {
        return this.sourceDestCheck;
    }

    public final SecondaryInterfaceStatus status() {
        return SecondaryInterfaceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String secondarySubnetId() {
        return this.secondarySubnetId;
    }

    public final String secondaryNetworkId() {
        return this.secondaryNetworkId;
    }

    public final SecondaryInterfaceType interfaceType() {
        return SecondaryInterfaceType.fromValue(this.interfaceType);
    }

    public final String interfaceTypeAsString() {
        return this.interfaceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachment());
        hashCode = 31 * hashCode + Objects.hashCode(this.macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrivateIpAddresses() ? this.privateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDestCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondarySubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.interfaceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceSecondaryInterface)) {
            return false;
        }
        InstanceSecondaryInterface other = (InstanceSecondaryInterface)obj;
        return Objects.equals(this.attachment(), other.attachment()) && Objects.equals(this.macAddress(), other.macAddress()) && Objects.equals(this.secondaryInterfaceId(), other.secondaryInterfaceId()) && Objects.equals(this.ownerId(), other.ownerId()) && this.hasPrivateIpAddresses() == other.hasPrivateIpAddresses() && Objects.equals(this.privateIpAddresses(), other.privateIpAddresses()) && Objects.equals(this.sourceDestCheck(), other.sourceDestCheck()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.secondarySubnetId(), other.secondarySubnetId()) && Objects.equals(this.secondaryNetworkId(), other.secondaryNetworkId()) && Objects.equals(this.interfaceTypeAsString(), other.interfaceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceSecondaryInterface").add("Attachment", (Object)this.attachment()).add("MacAddress", (Object)this.macAddress()).add("SecondaryInterfaceId", (Object)this.secondaryInterfaceId()).add("OwnerId", (Object)this.ownerId()).add("PrivateIpAddresses", this.hasPrivateIpAddresses() ? this.privateIpAddresses() : null).add("SourceDestCheck", (Object)this.sourceDestCheck()).add("Status", (Object)this.statusAsString()).add("SecondarySubnetId", (Object)this.secondarySubnetId()).add("SecondaryNetworkId", (Object)this.secondaryNetworkId()).add("InterfaceType", (Object)this.interfaceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attachment": {
                return Optional.ofNullable(clazz.cast(this.attachment()));
            }
            case "MacAddress": {
                return Optional.ofNullable(clazz.cast(this.macAddress()));
            }
            case "SecondaryInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.secondaryInterfaceId()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "PrivateIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddresses()));
            }
            case "SourceDestCheck": {
                return Optional.ofNullable(clazz.cast(this.sourceDestCheck()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "SecondarySubnetId": {
                return Optional.ofNullable(clazz.cast(this.secondarySubnetId()));
            }
            case "SecondaryNetworkId": {
                return Optional.ofNullable(clazz.cast(this.secondaryNetworkId()));
            }
            case "InterfaceType": {
                return Optional.ofNullable(clazz.cast(this.interfaceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Attachment", ATTACHMENT_FIELD);
        map.put("MacAddress", MAC_ADDRESS_FIELD);
        map.put("SecondaryInterfaceId", SECONDARY_INTERFACE_ID_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("PrivateIpAddressSet", PRIVATE_IP_ADDRESSES_FIELD);
        map.put("SourceDestCheck", SOURCE_DEST_CHECK_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("SecondarySubnetId", SECONDARY_SUBNET_ID_FIELD);
        map.put("SecondaryNetworkId", SECONDARY_NETWORK_ID_FIELD);
        map.put("InterfaceType", INTERFACE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceSecondaryInterface, T> g) {
        return obj -> g.apply((InstanceSecondaryInterface)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private InstanceSecondaryInterfaceAttachment attachment;
        private String macAddress;
        private String secondaryInterfaceId;
        private String ownerId;
        private List<InstanceSecondaryInterfacePrivateIpAddress> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();
        private Boolean sourceDestCheck;
        private String status;
        private String secondarySubnetId;
        private String secondaryNetworkId;
        private String interfaceType;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceSecondaryInterface model) {
            this.attachment(model.attachment);
            this.macAddress(model.macAddress);
            this.secondaryInterfaceId(model.secondaryInterfaceId);
            this.ownerId(model.ownerId);
            this.privateIpAddresses(model.privateIpAddresses);
            this.sourceDestCheck(model.sourceDestCheck);
            this.status(model.status);
            this.secondarySubnetId(model.secondarySubnetId);
            this.secondaryNetworkId(model.secondaryNetworkId);
            this.interfaceType(model.interfaceType);
        }

        public final InstanceSecondaryInterfaceAttachment.Builder getAttachment() {
            return this.attachment != null ? this.attachment.toBuilder() : null;
        }

        public final void setAttachment(InstanceSecondaryInterfaceAttachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        @Override
        public final Builder attachment(InstanceSecondaryInterfaceAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final String getMacAddress() {
            return this.macAddress;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final String getSecondaryInterfaceId() {
            return this.secondaryInterfaceId;
        }

        public final void setSecondaryInterfaceId(String secondaryInterfaceId) {
            this.secondaryInterfaceId = secondaryInterfaceId;
        }

        @Override
        public final Builder secondaryInterfaceId(String secondaryInterfaceId) {
            this.secondaryInterfaceId = secondaryInterfaceId;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final List<InstanceSecondaryInterfacePrivateIpAddress.Builder> getPrivateIpAddresses() {
            List<InstanceSecondaryInterfacePrivateIpAddress.Builder> result = InstanceSecondaryInterfacePrivateIpAddressListCopier.copyToBuilder(this.privateIpAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrivateIpAddresses(Collection<InstanceSecondaryInterfacePrivateIpAddress.BuilderImpl> privateIpAddresses) {
            this.privateIpAddresses = InstanceSecondaryInterfacePrivateIpAddressListCopier.copyFromBuilder(privateIpAddresses);
        }

        @Override
        public final Builder privateIpAddresses(Collection<InstanceSecondaryInterfacePrivateIpAddress> privateIpAddresses) {
            this.privateIpAddresses = InstanceSecondaryInterfacePrivateIpAddressListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(InstanceSecondaryInterfacePrivateIpAddress ... privateIpAddresses) {
            this.privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(Consumer<InstanceSecondaryInterfacePrivateIpAddress.Builder> ... privateIpAddresses) {
            this.privateIpAddresses(Stream.of(privateIpAddresses).map(c -> (InstanceSecondaryInterfacePrivateIpAddress)((InstanceSecondaryInterfacePrivateIpAddress.Builder)InstanceSecondaryInterfacePrivateIpAddress.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SecondaryInterfaceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSecondarySubnetId() {
            return this.secondarySubnetId;
        }

        public final void setSecondarySubnetId(String secondarySubnetId) {
            this.secondarySubnetId = secondarySubnetId;
        }

        @Override
        public final Builder secondarySubnetId(String secondarySubnetId) {
            this.secondarySubnetId = secondarySubnetId;
            return this;
        }

        public final String getSecondaryNetworkId() {
            return this.secondaryNetworkId;
        }

        public final void setSecondaryNetworkId(String secondaryNetworkId) {
            this.secondaryNetworkId = secondaryNetworkId;
        }

        @Override
        public final Builder secondaryNetworkId(String secondaryNetworkId) {
            this.secondaryNetworkId = secondaryNetworkId;
            return this;
        }

        public final String getInterfaceType() {
            return this.interfaceType;
        }

        public final void setInterfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
        }

        @Override
        public final Builder interfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
            return this;
        }

        @Override
        public final Builder interfaceType(SecondaryInterfaceType interfaceType) {
            this.interfaceType(interfaceType == null ? null : interfaceType.toString());
            return this;
        }

        public InstanceSecondaryInterface build() {
            return new InstanceSecondaryInterface(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceSecondaryInterface> {
        public Builder attachment(InstanceSecondaryInterfaceAttachment var1);

        default public Builder attachment(Consumer<InstanceSecondaryInterfaceAttachment.Builder> attachment) {
            return this.attachment((InstanceSecondaryInterfaceAttachment)((InstanceSecondaryInterfaceAttachment.Builder)InstanceSecondaryInterfaceAttachment.builder().applyMutation(attachment)).build());
        }

        public Builder macAddress(String var1);

        public Builder secondaryInterfaceId(String var1);

        public Builder ownerId(String var1);

        public Builder privateIpAddresses(Collection<InstanceSecondaryInterfacePrivateIpAddress> var1);

        public Builder privateIpAddresses(InstanceSecondaryInterfacePrivateIpAddress ... var1);

        public Builder privateIpAddresses(Consumer<InstanceSecondaryInterfacePrivateIpAddress.Builder> ... var1);

        public Builder sourceDestCheck(Boolean var1);

        public Builder status(String var1);

        public Builder status(SecondaryInterfaceStatus var1);

        public Builder secondarySubnetId(String var1);

        public Builder secondaryNetworkId(String var1);

        public Builder interfaceType(String var1);

        public Builder interfaceType(SecondaryInterfaceType var1);
    }
}

