/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.CapacityManagerStatus;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnableCapacityManagerResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, EnableCapacityManagerResponse> {
    private static final SdkField<String> CAPACITY_MANAGER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityManagerStatus").getter(EnableCapacityManagerResponse.getter(EnableCapacityManagerResponse::capacityManagerStatusAsString)).setter(EnableCapacityManagerResponse.setter(Builder::capacityManagerStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityManagerStatus").unmarshallLocationName("capacityManagerStatus").build()}).build();
    private static final SdkField<Boolean> ORGANIZATIONS_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("OrganizationsAccess").getter(EnableCapacityManagerResponse.getter(EnableCapacityManagerResponse::organizationsAccess)).setter(EnableCapacityManagerResponse.setter(Builder::organizationsAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationsAccess").unmarshallLocationName("organizationsAccess").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_MANAGER_STATUS_FIELD, ORGANIZATIONS_ACCESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnableCapacityManagerResponse.memberNameToFieldInitializer();
    private final String capacityManagerStatus;
    private final Boolean organizationsAccess;

    private EnableCapacityManagerResponse(BuilderImpl builder) {
        super(builder);
        this.capacityManagerStatus = builder.capacityManagerStatus;
        this.organizationsAccess = builder.organizationsAccess;
    }

    public final CapacityManagerStatus capacityManagerStatus() {
        return CapacityManagerStatus.fromValue(this.capacityManagerStatus);
    }

    public final String capacityManagerStatusAsString() {
        return this.capacityManagerStatus;
    }

    public final Boolean organizationsAccess() {
        return this.organizationsAccess;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityManagerStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationsAccess());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableCapacityManagerResponse)) {
            return false;
        }
        EnableCapacityManagerResponse other = (EnableCapacityManagerResponse)((Object)obj);
        return Objects.equals(this.capacityManagerStatusAsString(), other.capacityManagerStatusAsString()) && Objects.equals(this.organizationsAccess(), other.organizationsAccess());
    }

    public final String toString() {
        return ToString.builder((String)"EnableCapacityManagerResponse").add("CapacityManagerStatus", (Object)this.capacityManagerStatusAsString()).add("OrganizationsAccess", (Object)this.organizationsAccess()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityManagerStatus": {
                return Optional.ofNullable(clazz.cast(this.capacityManagerStatusAsString()));
            }
            case "OrganizationsAccess": {
                return Optional.ofNullable(clazz.cast(this.organizationsAccess()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityManagerStatus", CAPACITY_MANAGER_STATUS_FIELD);
        map.put("OrganizationsAccess", ORGANIZATIONS_ACCESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableCapacityManagerResponse, T> g) {
        return obj -> g.apply((EnableCapacityManagerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String capacityManagerStatus;
        private Boolean organizationsAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableCapacityManagerResponse model) {
            super(model);
            this.capacityManagerStatus(model.capacityManagerStatus);
            this.organizationsAccess(model.organizationsAccess);
        }

        public final String getCapacityManagerStatus() {
            return this.capacityManagerStatus;
        }

        public final void setCapacityManagerStatus(String capacityManagerStatus) {
            this.capacityManagerStatus = capacityManagerStatus;
        }

        @Override
        public final Builder capacityManagerStatus(String capacityManagerStatus) {
            this.capacityManagerStatus = capacityManagerStatus;
            return this;
        }

        @Override
        public final Builder capacityManagerStatus(CapacityManagerStatus capacityManagerStatus) {
            this.capacityManagerStatus(capacityManagerStatus == null ? null : capacityManagerStatus.toString());
            return this;
        }

        public final Boolean getOrganizationsAccess() {
            return this.organizationsAccess;
        }

        public final void setOrganizationsAccess(Boolean organizationsAccess) {
            this.organizationsAccess = organizationsAccess;
        }

        @Override
        public final Builder organizationsAccess(Boolean organizationsAccess) {
            this.organizationsAccess = organizationsAccess;
            return this;
        }

        @Override
        public EnableCapacityManagerResponse build() {
            return new EnableCapacityManagerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EnableCapacityManagerResponse> {
        public Builder capacityManagerStatus(String var1);

        public Builder capacityManagerStatus(CapacityManagerStatus var1);

        public Builder organizationsAccess(Boolean var1);
    }
}

