/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesRequest;
import software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesResponse;
import software.amazon.awssdk.services.ec2.model.TransitGatewayRoute;

public class SearchTransitGatewayRoutesPublisher
implements SdkPublisher<SearchTransitGatewayRoutesResponse> {
    private final Ec2AsyncClient client;
    private final SearchTransitGatewayRoutesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchTransitGatewayRoutesPublisher(Ec2AsyncClient client, SearchTransitGatewayRoutesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchTransitGatewayRoutesPublisher(Ec2AsyncClient client, SearchTransitGatewayRoutesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchTransitGatewayRoutesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchTransitGatewayRoutesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TransitGatewayRoute> routes() {
        return this.flatMapIterable(response -> response.routes());
    }

    private class SearchTransitGatewayRoutesResponseFetcher
    implements AsyncPageFetcher<SearchTransitGatewayRoutesResponse> {
        private SearchTransitGatewayRoutesResponseFetcher() {
        }

        public boolean hasNextPage(SearchTransitGatewayRoutesResponse previousPage) {
            return previousPage.additionalRoutesAvailable() != null && previousPage.additionalRoutesAvailable() != false;
        }

        public CompletableFuture<SearchTransitGatewayRoutesResponse> nextPage(SearchTransitGatewayRoutesResponse previousPage) {
            if (previousPage == null) {
                return SearchTransitGatewayRoutesPublisher.this.client.searchTransitGatewayRoutes(SearchTransitGatewayRoutesPublisher.this.firstRequest);
            }
            return SearchTransitGatewayRoutesPublisher.this.client.searchTransitGatewayRoutes((SearchTransitGatewayRoutesRequest)((Object)SearchTransitGatewayRoutesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

