/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeRouteServersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeRouteServersResponse;
import software.amazon.awssdk.services.ec2.model.RouteServer;

public class DescribeRouteServersPublisher
implements SdkPublisher<DescribeRouteServersResponse> {
    private final Ec2AsyncClient client;
    private final DescribeRouteServersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeRouteServersPublisher(Ec2AsyncClient client, DescribeRouteServersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeRouteServersPublisher(Ec2AsyncClient client, DescribeRouteServersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeRouteServersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeRouteServersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RouteServer> routeServers() {
        return this.flatMapIterable(response -> response.routeServers());
    }

    private class DescribeRouteServersResponseFetcher
    implements AsyncPageFetcher<DescribeRouteServersResponse> {
        private DescribeRouteServersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRouteServersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeRouteServersResponse> nextPage(DescribeRouteServersResponse previousPage) {
            if (previousPage == null) {
                return DescribeRouteServersPublisher.this.client.describeRouteServers(DescribeRouteServersPublisher.this.firstRequest);
            }
            return DescribeRouteServersPublisher.this.client.describeRouteServers((DescribeRouteServersRequest)((Object)DescribeRouteServersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

