/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverRule;
import software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverRuleSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIpamPrefixListResolverRulesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetIpamPrefixListResolverRulesResponse> {
    private static final SdkField<List<IpamPrefixListResolverRule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rules").getter(GetIpamPrefixListResolverRulesResponse.getter(GetIpamPrefixListResolverRulesResponse::rules)).setter(GetIpamPrefixListResolverRulesResponse.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSet").unmarshallLocationName("ruleSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamPrefixListResolverRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetIpamPrefixListResolverRulesResponse.getter(GetIpamPrefixListResolverRulesResponse::nextToken)).setter(GetIpamPrefixListResolverRulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetIpamPrefixListResolverRulesResponse.memberNameToFieldInitializer();
    private final List<IpamPrefixListResolverRule> rules;
    private final String nextToken;

    private GetIpamPrefixListResolverRulesResponse(BuilderImpl builder) {
        super(builder);
        this.rules = builder.rules;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<IpamPrefixListResolverRule> rules() {
        return this.rules;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIpamPrefixListResolverRulesResponse)) {
            return false;
        }
        GetIpamPrefixListResolverRulesResponse other = (GetIpamPrefixListResolverRulesResponse)((Object)obj);
        return this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetIpamPrefixListResolverRulesResponse").add("Rules", this.hasRules() ? this.rules() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RuleSet", RULES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIpamPrefixListResolverRulesResponse, T> g) {
        return obj -> g.apply((GetIpamPrefixListResolverRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<IpamPrefixListResolverRule> rules = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIpamPrefixListResolverRulesResponse model) {
            super(model);
            this.rules(model.rules);
            this.nextToken(model.nextToken);
        }

        public final List<IpamPrefixListResolverRule.Builder> getRules() {
            List<IpamPrefixListResolverRule.Builder> result = IpamPrefixListResolverRuleSetCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<IpamPrefixListResolverRule.BuilderImpl> rules) {
            this.rules = IpamPrefixListResolverRuleSetCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<IpamPrefixListResolverRule> rules) {
            this.rules = IpamPrefixListResolverRuleSetCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(IpamPrefixListResolverRule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<IpamPrefixListResolverRule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (IpamPrefixListResolverRule)((IpamPrefixListResolverRule.Builder)IpamPrefixListResolverRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetIpamPrefixListResolverRulesResponse build() {
            return new GetIpamPrefixListResolverRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIpamPrefixListResolverRulesResponse> {
        public Builder rules(Collection<IpamPrefixListResolverRule> var1);

        public Builder rules(IpamPrefixListResolverRule ... var1);

        public Builder rules(Consumer<IpamPrefixListResolverRule.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

