/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.IpamPolicyManagedBy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEnabledIpamPolicyResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetEnabledIpamPolicyResponse> {
    private static final SdkField<Boolean> IPAM_POLICY_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IpamPolicyEnabled").getter(GetEnabledIpamPolicyResponse.getter(GetEnabledIpamPolicyResponse::ipamPolicyEnabled)).setter(GetEnabledIpamPolicyResponse.setter(Builder::ipamPolicyEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPolicyEnabled").unmarshallLocationName("ipamPolicyEnabled").build()}).build();
    private static final SdkField<String> IPAM_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPolicyId").getter(GetEnabledIpamPolicyResponse.getter(GetEnabledIpamPolicyResponse::ipamPolicyId)).setter(GetEnabledIpamPolicyResponse.setter(Builder::ipamPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPolicyId").unmarshallLocationName("ipamPolicyId").build()}).build();
    private static final SdkField<String> MANAGED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagedBy").getter(GetEnabledIpamPolicyResponse.getter(GetEnabledIpamPolicyResponse::managedByAsString)).setter(GetEnabledIpamPolicyResponse.setter(Builder::managedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedBy").unmarshallLocationName("managedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_POLICY_ENABLED_FIELD, IPAM_POLICY_ID_FIELD, MANAGED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetEnabledIpamPolicyResponse.memberNameToFieldInitializer();
    private final Boolean ipamPolicyEnabled;
    private final String ipamPolicyId;
    private final String managedBy;

    private GetEnabledIpamPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.ipamPolicyEnabled = builder.ipamPolicyEnabled;
        this.ipamPolicyId = builder.ipamPolicyId;
        this.managedBy = builder.managedBy;
    }

    public final Boolean ipamPolicyEnabled() {
        return this.ipamPolicyEnabled;
    }

    public final String ipamPolicyId() {
        return this.ipamPolicyId;
    }

    public final IpamPolicyManagedBy managedBy() {
        return IpamPolicyManagedBy.fromValue(this.managedBy);
    }

    public final String managedByAsString() {
        return this.managedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPolicyEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedByAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEnabledIpamPolicyResponse)) {
            return false;
        }
        GetEnabledIpamPolicyResponse other = (GetEnabledIpamPolicyResponse)((Object)obj);
        return Objects.equals(this.ipamPolicyEnabled(), other.ipamPolicyEnabled()) && Objects.equals(this.ipamPolicyId(), other.ipamPolicyId()) && Objects.equals(this.managedByAsString(), other.managedByAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetEnabledIpamPolicyResponse").add("IpamPolicyEnabled", (Object)this.ipamPolicyEnabled()).add("IpamPolicyId", (Object)this.ipamPolicyId()).add("ManagedBy", (Object)this.managedByAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpamPolicyEnabled": {
                return Optional.ofNullable(clazz.cast(this.ipamPolicyEnabled()));
            }
            case "IpamPolicyId": {
                return Optional.ofNullable(clazz.cast(this.ipamPolicyId()));
            }
            case "ManagedBy": {
                return Optional.ofNullable(clazz.cast(this.managedByAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IpamPolicyEnabled", IPAM_POLICY_ENABLED_FIELD);
        map.put("IpamPolicyId", IPAM_POLICY_ID_FIELD);
        map.put("ManagedBy", MANAGED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEnabledIpamPolicyResponse, T> g) {
        return obj -> g.apply((GetEnabledIpamPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private Boolean ipamPolicyEnabled;
        private String ipamPolicyId;
        private String managedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEnabledIpamPolicyResponse model) {
            super(model);
            this.ipamPolicyEnabled(model.ipamPolicyEnabled);
            this.ipamPolicyId(model.ipamPolicyId);
            this.managedBy(model.managedBy);
        }

        public final Boolean getIpamPolicyEnabled() {
            return this.ipamPolicyEnabled;
        }

        public final void setIpamPolicyEnabled(Boolean ipamPolicyEnabled) {
            this.ipamPolicyEnabled = ipamPolicyEnabled;
        }

        @Override
        public final Builder ipamPolicyEnabled(Boolean ipamPolicyEnabled) {
            this.ipamPolicyEnabled = ipamPolicyEnabled;
            return this;
        }

        public final String getIpamPolicyId() {
            return this.ipamPolicyId;
        }

        public final void setIpamPolicyId(String ipamPolicyId) {
            this.ipamPolicyId = ipamPolicyId;
        }

        @Override
        public final Builder ipamPolicyId(String ipamPolicyId) {
            this.ipamPolicyId = ipamPolicyId;
            return this;
        }

        public final String getManagedBy() {
            return this.managedBy;
        }

        public final void setManagedBy(String managedBy) {
            this.managedBy = managedBy;
        }

        @Override
        public final Builder managedBy(String managedBy) {
            this.managedBy = managedBy;
            return this;
        }

        @Override
        public final Builder managedBy(IpamPolicyManagedBy managedBy) {
            this.managedBy(managedBy == null ? null : managedBy.toString());
            return this;
        }

        @Override
        public GetEnabledIpamPolicyResponse build() {
            return new GetEnabledIpamPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEnabledIpamPolicyResponse> {
        public Builder ipamPolicyEnabled(Boolean var1);

        public Builder ipamPolicyId(String var1);

        public Builder managedBy(String var1);

        public Builder managedBy(IpamPolicyManagedBy var1);
    }
}

