/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksResponse;
import software.amazon.awssdk.services.ec2.model.ImportSnapshotTask;

public class DescribeImportSnapshotTasksPublisher
implements SdkPublisher<DescribeImportSnapshotTasksResponse> {
    private final Ec2AsyncClient client;
    private final DescribeImportSnapshotTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeImportSnapshotTasksPublisher(Ec2AsyncClient client, DescribeImportSnapshotTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeImportSnapshotTasksPublisher(Ec2AsyncClient client, DescribeImportSnapshotTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeImportSnapshotTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeImportSnapshotTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ImportSnapshotTask> importSnapshotTasks() {
        return this.flatMapIterable(response -> response.importSnapshotTasks());
    }

    private class DescribeImportSnapshotTasksResponseFetcher
    implements AsyncPageFetcher<DescribeImportSnapshotTasksResponse> {
        private DescribeImportSnapshotTasksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeImportSnapshotTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeImportSnapshotTasksResponse> nextPage(DescribeImportSnapshotTasksResponse previousPage) {
            if (previousPage == null) {
                return DescribeImportSnapshotTasksPublisher.this.client.describeImportSnapshotTasks(DescribeImportSnapshotTasksPublisher.this.firstRequest);
            }
            return DescribeImportSnapshotTasksPublisher.this.client.describeImportSnapshotTasks((DescribeImportSnapshotTasksRequest)((Object)DescribeImportSnapshotTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

