/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamResourceCidrsResponse;
import software.amazon.awssdk.services.ec2.model.IpamResourceCidr;

public class GetIpamResourceCidrsPublisher
implements SdkPublisher<GetIpamResourceCidrsResponse> {
    private final Ec2AsyncClient client;
    private final GetIpamResourceCidrsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetIpamResourceCidrsPublisher(Ec2AsyncClient client, GetIpamResourceCidrsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetIpamResourceCidrsPublisher(Ec2AsyncClient client, GetIpamResourceCidrsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetIpamResourceCidrsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetIpamResourceCidrsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IpamResourceCidr> ipamResourceCidrs() {
        return this.flatMapIterable(response -> response.ipamResourceCidrs());
    }

    private class GetIpamResourceCidrsResponseFetcher
    implements AsyncPageFetcher<GetIpamResourceCidrsResponse> {
        private GetIpamResourceCidrsResponseFetcher() {
        }

        public boolean hasNextPage(GetIpamResourceCidrsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetIpamResourceCidrsResponse> nextPage(GetIpamResourceCidrsResponse previousPage) {
            if (previousPage == null) {
                return GetIpamResourceCidrsPublisher.this.client.getIpamResourceCidrs(GetIpamResourceCidrsPublisher.this.firstRequest);
            }
            return GetIpamResourceCidrsPublisher.this.client.getIpamResourceCidrs((GetIpamResourceCidrsRequest)((Object)GetIpamResourceCidrsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

