/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeFlowLogsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFlowLogsResponse;
import software.amazon.awssdk.services.ec2.model.FlowLog;

public class DescribeFlowLogsPublisher
implements SdkPublisher<DescribeFlowLogsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeFlowLogsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeFlowLogsPublisher(Ec2AsyncClient client, DescribeFlowLogsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeFlowLogsPublisher(Ec2AsyncClient client, DescribeFlowLogsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeFlowLogsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeFlowLogsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FlowLog> flowLogs() {
        return this.flatMapIterable(response -> response.flowLogs());
    }

    private class DescribeFlowLogsResponseFetcher
    implements AsyncPageFetcher<DescribeFlowLogsResponse> {
        private DescribeFlowLogsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFlowLogsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeFlowLogsResponse> nextPage(DescribeFlowLogsResponse previousPage) {
            if (previousPage == null) {
                return DescribeFlowLogsPublisher.this.client.describeFlowLogs(DescribeFlowLogsPublisher.this.firstRequest);
            }
            return DescribeFlowLogsPublisher.this.client.describeFlowLogs((DescribeFlowLogsRequest)((Object)DescribeFlowLogsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

