/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeMacModificationTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeMacModificationTasksResponse;
import software.amazon.awssdk.services.ec2.model.MacModificationTask;

public class DescribeMacModificationTasksPublisher
implements SdkPublisher<DescribeMacModificationTasksResponse> {
    private final Ec2AsyncClient client;
    private final DescribeMacModificationTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeMacModificationTasksPublisher(Ec2AsyncClient client, DescribeMacModificationTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeMacModificationTasksPublisher(Ec2AsyncClient client, DescribeMacModificationTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeMacModificationTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeMacModificationTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MacModificationTask> macModificationTasks() {
        return this.flatMapIterable(response -> response.macModificationTasks());
    }

    private class DescribeMacModificationTasksResponseFetcher
    implements AsyncPageFetcher<DescribeMacModificationTasksResponse> {
        private DescribeMacModificationTasksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMacModificationTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeMacModificationTasksResponse> nextPage(DescribeMacModificationTasksResponse previousPage) {
            if (previousPage == null) {
                return DescribeMacModificationTasksPublisher.this.client.describeMacModificationTasks(DescribeMacModificationTasksPublisher.this.firstRequest);
            }
            return DescribeMacModificationTasksPublisher.this.client.describeMacModificationTasks((DescribeMacModificationTasksRequest)((Object)DescribeMacModificationTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

