/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayVpcAttachmentsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayVpcAttachmentsResponse;
import software.amazon.awssdk.services.ec2.model.TransitGatewayVpcAttachment;

public class DescribeTransitGatewayVpcAttachmentsPublisher
implements SdkPublisher<DescribeTransitGatewayVpcAttachmentsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeTransitGatewayVpcAttachmentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTransitGatewayVpcAttachmentsPublisher(Ec2AsyncClient client, DescribeTransitGatewayVpcAttachmentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTransitGatewayVpcAttachmentsPublisher(Ec2AsyncClient client, DescribeTransitGatewayVpcAttachmentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTransitGatewayVpcAttachmentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTransitGatewayVpcAttachmentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TransitGatewayVpcAttachment> transitGatewayVpcAttachments() {
        return this.flatMapIterable(response -> response.transitGatewayVpcAttachments());
    }

    private class DescribeTransitGatewayVpcAttachmentsResponseFetcher
    implements AsyncPageFetcher<DescribeTransitGatewayVpcAttachmentsResponse> {
        private DescribeTransitGatewayVpcAttachmentsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTransitGatewayVpcAttachmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeTransitGatewayVpcAttachmentsResponse> nextPage(DescribeTransitGatewayVpcAttachmentsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTransitGatewayVpcAttachmentsPublisher.this.client.describeTransitGatewayVpcAttachments(DescribeTransitGatewayVpcAttachmentsPublisher.this.firstRequest);
            }
            return DescribeTransitGatewayVpcAttachmentsPublisher.this.client.describeTransitGatewayVpcAttachments((DescribeTransitGatewayVpcAttachmentsRequest)((Object)DescribeTransitGatewayVpcAttachmentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

