/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayMeteringPolicyRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayMeteringPolicyRule> {
    private static final SdkField<String> SOURCE_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceTransitGatewayAttachmentId").getter(TransitGatewayMeteringPolicyRule.getter(TransitGatewayMeteringPolicyRule::sourceTransitGatewayAttachmentId)).setter(TransitGatewayMeteringPolicyRule.setter(Builder::sourceTransitGatewayAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTransitGatewayAttachmentId").unmarshallLocationName("sourceTransitGatewayAttachmentId").build()}).build();
    private static final SdkField<String> SOURCE_TRANSIT_GATEWAY_ATTACHMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceTransitGatewayAttachmentType").getter(TransitGatewayMeteringPolicyRule.getter(TransitGatewayMeteringPolicyRule::sourceTransitGatewayAttachmentTypeAsString)).setter(TransitGatewayMeteringPolicyRule.setter(Builder::sourceTransitGatewayAttachmentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTransitGatewayAttachmentType").unmarshallLocationName("sourceTransitGatewayAttachmentType").build()}).build();
    private static final SdkField<String> SOURCE_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceCidrBlock").getter(TransitGatewayMeteringPolicyRule.getter(TransitGatewayMeteringPolicyRule::sourceCidrBlock)).setter(TransitGatewayMeteringPolicyRule.setter(Builder::sourceCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCidrBlock").unmarshallLocationName("sourceCidrBlock").build()}).build();
    private static final SdkField<String> SOURCE_PORT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourcePortRange").getter(TransitGatewayMeteringPolicyRule.getter(TransitGatewayMeteringPolicyRule::sourcePortRange)).setter(TransitGatewayMeteringPolicyRule.setter(Builder::sourcePortRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePortRange").unmarshallLocationName("sourcePortRange").build()}).build();
    private static final SdkField<String> DESTINATION_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationTransitGatewayAttachmentId").getter(TransitGatewayMeteringPolicyRule.getter(TransitGatewayMeteringPolicyRule::destinationTransitGatewayAttachmentId)).setter(TransitGatewayMeteringPolicyRule.setter(Builder::destinationTransitGatewayAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationTransitGatewayAttachmentId").unmarshallLocationName("destinationTransitGatewayAttachmentId").build()}).build();
    private static final SdkField<String> DESTINATION_TRANSIT_GATEWAY_ATTACHMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationTransitGatewayAttachmentType").getter(TransitGatewayMeteringPolicyRule.getter(TransitGatewayMeteringPolicyRule::destinationTransitGatewayAttachmentTypeAsString)).setter(TransitGatewayMeteringPolicyRule.setter(Builder::destinationTransitGatewayAttachmentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationTransitGatewayAttachmentType").unmarshallLocationName("destinationTransitGatewayAttachmentType").build()}).build();
    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationCidrBlock").getter(TransitGatewayMeteringPolicyRule.getter(TransitGatewayMeteringPolicyRule::destinationCidrBlock)).setter(TransitGatewayMeteringPolicyRule.setter(Builder::destinationCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock").unmarshallLocationName("destinationCidrBlock").build()}).build();
    private static final SdkField<String> DESTINATION_PORT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationPortRange").getter(TransitGatewayMeteringPolicyRule.getter(TransitGatewayMeteringPolicyRule::destinationPortRange)).setter(TransitGatewayMeteringPolicyRule.setter(Builder::destinationPortRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPortRange").unmarshallLocationName("destinationPortRange").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(TransitGatewayMeteringPolicyRule.getter(TransitGatewayMeteringPolicyRule::protocol)).setter(TransitGatewayMeteringPolicyRule.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").unmarshallLocationName("protocol").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, SOURCE_TRANSIT_GATEWAY_ATTACHMENT_TYPE_FIELD, SOURCE_CIDR_BLOCK_FIELD, SOURCE_PORT_RANGE_FIELD, DESTINATION_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, DESTINATION_TRANSIT_GATEWAY_ATTACHMENT_TYPE_FIELD, DESTINATION_CIDR_BLOCK_FIELD, DESTINATION_PORT_RANGE_FIELD, PROTOCOL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TransitGatewayMeteringPolicyRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sourceTransitGatewayAttachmentId;
    private final String sourceTransitGatewayAttachmentType;
    private final String sourceCidrBlock;
    private final String sourcePortRange;
    private final String destinationTransitGatewayAttachmentId;
    private final String destinationTransitGatewayAttachmentType;
    private final String destinationCidrBlock;
    private final String destinationPortRange;
    private final String protocol;

    private TransitGatewayMeteringPolicyRule(BuilderImpl builder) {
        this.sourceTransitGatewayAttachmentId = builder.sourceTransitGatewayAttachmentId;
        this.sourceTransitGatewayAttachmentType = builder.sourceTransitGatewayAttachmentType;
        this.sourceCidrBlock = builder.sourceCidrBlock;
        this.sourcePortRange = builder.sourcePortRange;
        this.destinationTransitGatewayAttachmentId = builder.destinationTransitGatewayAttachmentId;
        this.destinationTransitGatewayAttachmentType = builder.destinationTransitGatewayAttachmentType;
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.destinationPortRange = builder.destinationPortRange;
        this.protocol = builder.protocol;
    }

    public final String sourceTransitGatewayAttachmentId() {
        return this.sourceTransitGatewayAttachmentId;
    }

    public final TransitGatewayAttachmentResourceType sourceTransitGatewayAttachmentType() {
        return TransitGatewayAttachmentResourceType.fromValue(this.sourceTransitGatewayAttachmentType);
    }

    public final String sourceTransitGatewayAttachmentTypeAsString() {
        return this.sourceTransitGatewayAttachmentType;
    }

    public final String sourceCidrBlock() {
        return this.sourceCidrBlock;
    }

    public final String sourcePortRange() {
        return this.sourcePortRange;
    }

    public final String destinationTransitGatewayAttachmentId() {
        return this.destinationTransitGatewayAttachmentId;
    }

    public final TransitGatewayAttachmentResourceType destinationTransitGatewayAttachmentType() {
        return TransitGatewayAttachmentResourceType.fromValue(this.destinationTransitGatewayAttachmentType);
    }

    public final String destinationTransitGatewayAttachmentTypeAsString() {
        return this.destinationTransitGatewayAttachmentType;
    }

    public final String destinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    public final String destinationPortRange() {
        return this.destinationPortRange;
    }

    public final String protocol() {
        return this.protocol;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTransitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTransitGatewayAttachmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePortRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationTransitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationTransitGatewayAttachmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPortRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayMeteringPolicyRule)) {
            return false;
        }
        TransitGatewayMeteringPolicyRule other = (TransitGatewayMeteringPolicyRule)obj;
        return Objects.equals(this.sourceTransitGatewayAttachmentId(), other.sourceTransitGatewayAttachmentId()) && Objects.equals(this.sourceTransitGatewayAttachmentTypeAsString(), other.sourceTransitGatewayAttachmentTypeAsString()) && Objects.equals(this.sourceCidrBlock(), other.sourceCidrBlock()) && Objects.equals(this.sourcePortRange(), other.sourcePortRange()) && Objects.equals(this.destinationTransitGatewayAttachmentId(), other.destinationTransitGatewayAttachmentId()) && Objects.equals(this.destinationTransitGatewayAttachmentTypeAsString(), other.destinationTransitGatewayAttachmentTypeAsString()) && Objects.equals(this.destinationCidrBlock(), other.destinationCidrBlock()) && Objects.equals(this.destinationPortRange(), other.destinationPortRange()) && Objects.equals(this.protocol(), other.protocol());
    }

    public final String toString() {
        return ToString.builder((String)"TransitGatewayMeteringPolicyRule").add("SourceTransitGatewayAttachmentId", (Object)this.sourceTransitGatewayAttachmentId()).add("SourceTransitGatewayAttachmentType", (Object)this.sourceTransitGatewayAttachmentTypeAsString()).add("SourceCidrBlock", (Object)this.sourceCidrBlock()).add("SourcePortRange", (Object)this.sourcePortRange()).add("DestinationTransitGatewayAttachmentId", (Object)this.destinationTransitGatewayAttachmentId()).add("DestinationTransitGatewayAttachmentType", (Object)this.destinationTransitGatewayAttachmentTypeAsString()).add("DestinationCidrBlock", (Object)this.destinationCidrBlock()).add("DestinationPortRange", (Object)this.destinationPortRange()).add("Protocol", (Object)this.protocol()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceTransitGatewayAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.sourceTransitGatewayAttachmentId()));
            }
            case "SourceTransitGatewayAttachmentType": {
                return Optional.ofNullable(clazz.cast(this.sourceTransitGatewayAttachmentTypeAsString()));
            }
            case "SourceCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.sourceCidrBlock()));
            }
            case "SourcePortRange": {
                return Optional.ofNullable(clazz.cast(this.sourcePortRange()));
            }
            case "DestinationTransitGatewayAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.destinationTransitGatewayAttachmentId()));
            }
            case "DestinationTransitGatewayAttachmentType": {
                return Optional.ofNullable(clazz.cast(this.destinationTransitGatewayAttachmentTypeAsString()));
            }
            case "DestinationCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.destinationCidrBlock()));
            }
            case "DestinationPortRange": {
                return Optional.ofNullable(clazz.cast(this.destinationPortRange()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("SourceTransitGatewayAttachmentId", SOURCE_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD);
        map.put("SourceTransitGatewayAttachmentType", SOURCE_TRANSIT_GATEWAY_ATTACHMENT_TYPE_FIELD);
        map.put("SourceCidrBlock", SOURCE_CIDR_BLOCK_FIELD);
        map.put("SourcePortRange", SOURCE_PORT_RANGE_FIELD);
        map.put("DestinationTransitGatewayAttachmentId", DESTINATION_TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD);
        map.put("DestinationTransitGatewayAttachmentType", DESTINATION_TRANSIT_GATEWAY_ATTACHMENT_TYPE_FIELD);
        map.put("DestinationCidrBlock", DESTINATION_CIDR_BLOCK_FIELD);
        map.put("DestinationPortRange", DESTINATION_PORT_RANGE_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayMeteringPolicyRule, T> g) {
        return obj -> g.apply((TransitGatewayMeteringPolicyRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceTransitGatewayAttachmentId;
        private String sourceTransitGatewayAttachmentType;
        private String sourceCidrBlock;
        private String sourcePortRange;
        private String destinationTransitGatewayAttachmentId;
        private String destinationTransitGatewayAttachmentType;
        private String destinationCidrBlock;
        private String destinationPortRange;
        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayMeteringPolicyRule model) {
            this.sourceTransitGatewayAttachmentId(model.sourceTransitGatewayAttachmentId);
            this.sourceTransitGatewayAttachmentType(model.sourceTransitGatewayAttachmentType);
            this.sourceCidrBlock(model.sourceCidrBlock);
            this.sourcePortRange(model.sourcePortRange);
            this.destinationTransitGatewayAttachmentId(model.destinationTransitGatewayAttachmentId);
            this.destinationTransitGatewayAttachmentType(model.destinationTransitGatewayAttachmentType);
            this.destinationCidrBlock(model.destinationCidrBlock);
            this.destinationPortRange(model.destinationPortRange);
            this.protocol(model.protocol);
        }

        public final String getSourceTransitGatewayAttachmentId() {
            return this.sourceTransitGatewayAttachmentId;
        }

        public final void setSourceTransitGatewayAttachmentId(String sourceTransitGatewayAttachmentId) {
            this.sourceTransitGatewayAttachmentId = sourceTransitGatewayAttachmentId;
        }

        @Override
        public final Builder sourceTransitGatewayAttachmentId(String sourceTransitGatewayAttachmentId) {
            this.sourceTransitGatewayAttachmentId = sourceTransitGatewayAttachmentId;
            return this;
        }

        public final String getSourceTransitGatewayAttachmentType() {
            return this.sourceTransitGatewayAttachmentType;
        }

        public final void setSourceTransitGatewayAttachmentType(String sourceTransitGatewayAttachmentType) {
            this.sourceTransitGatewayAttachmentType = sourceTransitGatewayAttachmentType;
        }

        @Override
        public final Builder sourceTransitGatewayAttachmentType(String sourceTransitGatewayAttachmentType) {
            this.sourceTransitGatewayAttachmentType = sourceTransitGatewayAttachmentType;
            return this;
        }

        @Override
        public final Builder sourceTransitGatewayAttachmentType(TransitGatewayAttachmentResourceType sourceTransitGatewayAttachmentType) {
            this.sourceTransitGatewayAttachmentType(sourceTransitGatewayAttachmentType == null ? null : sourceTransitGatewayAttachmentType.toString());
            return this;
        }

        public final String getSourceCidrBlock() {
            return this.sourceCidrBlock;
        }

        public final void setSourceCidrBlock(String sourceCidrBlock) {
            this.sourceCidrBlock = sourceCidrBlock;
        }

        @Override
        public final Builder sourceCidrBlock(String sourceCidrBlock) {
            this.sourceCidrBlock = sourceCidrBlock;
            return this;
        }

        public final String getSourcePortRange() {
            return this.sourcePortRange;
        }

        public final void setSourcePortRange(String sourcePortRange) {
            this.sourcePortRange = sourcePortRange;
        }

        @Override
        public final Builder sourcePortRange(String sourcePortRange) {
            this.sourcePortRange = sourcePortRange;
            return this;
        }

        public final String getDestinationTransitGatewayAttachmentId() {
            return this.destinationTransitGatewayAttachmentId;
        }

        public final void setDestinationTransitGatewayAttachmentId(String destinationTransitGatewayAttachmentId) {
            this.destinationTransitGatewayAttachmentId = destinationTransitGatewayAttachmentId;
        }

        @Override
        public final Builder destinationTransitGatewayAttachmentId(String destinationTransitGatewayAttachmentId) {
            this.destinationTransitGatewayAttachmentId = destinationTransitGatewayAttachmentId;
            return this;
        }

        public final String getDestinationTransitGatewayAttachmentType() {
            return this.destinationTransitGatewayAttachmentType;
        }

        public final void setDestinationTransitGatewayAttachmentType(String destinationTransitGatewayAttachmentType) {
            this.destinationTransitGatewayAttachmentType = destinationTransitGatewayAttachmentType;
        }

        @Override
        public final Builder destinationTransitGatewayAttachmentType(String destinationTransitGatewayAttachmentType) {
            this.destinationTransitGatewayAttachmentType = destinationTransitGatewayAttachmentType;
            return this;
        }

        @Override
        public final Builder destinationTransitGatewayAttachmentType(TransitGatewayAttachmentResourceType destinationTransitGatewayAttachmentType) {
            this.destinationTransitGatewayAttachmentType(destinationTransitGatewayAttachmentType == null ? null : destinationTransitGatewayAttachmentType.toString());
            return this;
        }

        public final String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final String getDestinationPortRange() {
            return this.destinationPortRange;
        }

        public final void setDestinationPortRange(String destinationPortRange) {
            this.destinationPortRange = destinationPortRange;
        }

        @Override
        public final Builder destinationPortRange(String destinationPortRange) {
            this.destinationPortRange = destinationPortRange;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public TransitGatewayMeteringPolicyRule build() {
            return new TransitGatewayMeteringPolicyRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayMeteringPolicyRule> {
        public Builder sourceTransitGatewayAttachmentId(String var1);

        public Builder sourceTransitGatewayAttachmentType(String var1);

        public Builder sourceTransitGatewayAttachmentType(TransitGatewayAttachmentResourceType var1);

        public Builder sourceCidrBlock(String var1);

        public Builder sourcePortRange(String var1);

        public Builder destinationTransitGatewayAttachmentId(String var1);

        public Builder destinationTransitGatewayAttachmentType(String var1);

        public Builder destinationTransitGatewayAttachmentType(TransitGatewayAttachmentResourceType var1);

        public Builder destinationCidrBlock(String var1);

        public Builder destinationPortRange(String var1);

        public Builder protocol(String var1);
    }
}

