/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverTargetState;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpamPrefixListResolverTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpamPrefixListResolverTarget> {
    private static final SdkField<String> IPAM_PREFIX_LIST_RESOLVER_TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPrefixListResolverTargetId").getter(IpamPrefixListResolverTarget.getter(IpamPrefixListResolverTarget::ipamPrefixListResolverTargetId)).setter(IpamPrefixListResolverTarget.setter(Builder::ipamPrefixListResolverTargetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPrefixListResolverTargetId").unmarshallLocationName("ipamPrefixListResolverTargetId").build()}).build();
    private static final SdkField<String> IPAM_PREFIX_LIST_RESOLVER_TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPrefixListResolverTargetArn").getter(IpamPrefixListResolverTarget.getter(IpamPrefixListResolverTarget::ipamPrefixListResolverTargetArn)).setter(IpamPrefixListResolverTarget.setter(Builder::ipamPrefixListResolverTargetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPrefixListResolverTargetArn").unmarshallLocationName("ipamPrefixListResolverTargetArn").build()}).build();
    private static final SdkField<String> IPAM_PREFIX_LIST_RESOLVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPrefixListResolverId").getter(IpamPrefixListResolverTarget.getter(IpamPrefixListResolverTarget::ipamPrefixListResolverId)).setter(IpamPrefixListResolverTarget.setter(Builder::ipamPrefixListResolverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPrefixListResolverId").unmarshallLocationName("ipamPrefixListResolverId").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(IpamPrefixListResolverTarget.getter(IpamPrefixListResolverTarget::ownerId)).setter(IpamPrefixListResolverTarget.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrefixListId").getter(IpamPrefixListResolverTarget.getter(IpamPrefixListResolverTarget::prefixListId)).setter(IpamPrefixListResolverTarget.setter(Builder::prefixListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId").unmarshallLocationName("prefixListId").build()}).build();
    private static final SdkField<String> PREFIX_LIST_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrefixListRegion").getter(IpamPrefixListResolverTarget.getter(IpamPrefixListResolverTarget::prefixListRegion)).setter(IpamPrefixListResolverTarget.setter(Builder::prefixListRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListRegion").unmarshallLocationName("prefixListRegion").build()}).build();
    private static final SdkField<Long> DESIRED_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DesiredVersion").getter(IpamPrefixListResolverTarget.getter(IpamPrefixListResolverTarget::desiredVersion)).setter(IpamPrefixListResolverTarget.setter(Builder::desiredVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredVersion").unmarshallLocationName("desiredVersion").build()}).build();
    private static final SdkField<Long> LAST_SYNCED_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LastSyncedVersion").getter(IpamPrefixListResolverTarget.getter(IpamPrefixListResolverTarget::lastSyncedVersion)).setter(IpamPrefixListResolverTarget.setter(Builder::lastSyncedVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSyncedVersion").unmarshallLocationName("lastSyncedVersion").build()}).build();
    private static final SdkField<Boolean> TRACK_LATEST_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TrackLatestVersion").getter(IpamPrefixListResolverTarget.getter(IpamPrefixListResolverTarget::trackLatestVersion)).setter(IpamPrefixListResolverTarget.setter(Builder::trackLatestVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackLatestVersion").unmarshallLocationName("trackLatestVersion").build()}).build();
    private static final SdkField<String> STATE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateMessage").getter(IpamPrefixListResolverTarget.getter(IpamPrefixListResolverTarget::stateMessage)).setter(IpamPrefixListResolverTarget.setter(Builder::stateMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateMessage").unmarshallLocationName("stateMessage").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(IpamPrefixListResolverTarget.getter(IpamPrefixListResolverTarget::stateAsString)).setter(IpamPrefixListResolverTarget.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(IpamPrefixListResolverTarget.getter(IpamPrefixListResolverTarget::tags)).setter(IpamPrefixListResolverTarget.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_PREFIX_LIST_RESOLVER_TARGET_ID_FIELD, IPAM_PREFIX_LIST_RESOLVER_TARGET_ARN_FIELD, IPAM_PREFIX_LIST_RESOLVER_ID_FIELD, OWNER_ID_FIELD, PREFIX_LIST_ID_FIELD, PREFIX_LIST_REGION_FIELD, DESIRED_VERSION_FIELD, LAST_SYNCED_VERSION_FIELD, TRACK_LATEST_VERSION_FIELD, STATE_MESSAGE_FIELD, STATE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IpamPrefixListResolverTarget.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ipamPrefixListResolverTargetId;
    private final String ipamPrefixListResolverTargetArn;
    private final String ipamPrefixListResolverId;
    private final String ownerId;
    private final String prefixListId;
    private final String prefixListRegion;
    private final Long desiredVersion;
    private final Long lastSyncedVersion;
    private final Boolean trackLatestVersion;
    private final String stateMessage;
    private final String state;
    private final List<Tag> tags;

    private IpamPrefixListResolverTarget(BuilderImpl builder) {
        this.ipamPrefixListResolverTargetId = builder.ipamPrefixListResolverTargetId;
        this.ipamPrefixListResolverTargetArn = builder.ipamPrefixListResolverTargetArn;
        this.ipamPrefixListResolverId = builder.ipamPrefixListResolverId;
        this.ownerId = builder.ownerId;
        this.prefixListId = builder.prefixListId;
        this.prefixListRegion = builder.prefixListRegion;
        this.desiredVersion = builder.desiredVersion;
        this.lastSyncedVersion = builder.lastSyncedVersion;
        this.trackLatestVersion = builder.trackLatestVersion;
        this.stateMessage = builder.stateMessage;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    public final String ipamPrefixListResolverTargetId() {
        return this.ipamPrefixListResolverTargetId;
    }

    public final String ipamPrefixListResolverTargetArn() {
        return this.ipamPrefixListResolverTargetArn;
    }

    public final String ipamPrefixListResolverId() {
        return this.ipamPrefixListResolverId;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String prefixListId() {
        return this.prefixListId;
    }

    public final String prefixListRegion() {
        return this.prefixListRegion;
    }

    public final Long desiredVersion() {
        return this.desiredVersion;
    }

    public final Long lastSyncedVersion() {
        return this.lastSyncedVersion;
    }

    public final Boolean trackLatestVersion() {
        return this.trackLatestVersion;
    }

    public final String stateMessage() {
        return this.stateMessage;
    }

    public final IpamPrefixListResolverTargetState state() {
        return IpamPrefixListResolverTargetState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPrefixListResolverTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPrefixListResolverTargetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPrefixListResolverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixListRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSyncedVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackLatestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamPrefixListResolverTarget)) {
            return false;
        }
        IpamPrefixListResolverTarget other = (IpamPrefixListResolverTarget)obj;
        return Objects.equals(this.ipamPrefixListResolverTargetId(), other.ipamPrefixListResolverTargetId()) && Objects.equals(this.ipamPrefixListResolverTargetArn(), other.ipamPrefixListResolverTargetArn()) && Objects.equals(this.ipamPrefixListResolverId(), other.ipamPrefixListResolverId()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.prefixListId(), other.prefixListId()) && Objects.equals(this.prefixListRegion(), other.prefixListRegion()) && Objects.equals(this.desiredVersion(), other.desiredVersion()) && Objects.equals(this.lastSyncedVersion(), other.lastSyncedVersion()) && Objects.equals(this.trackLatestVersion(), other.trackLatestVersion()) && Objects.equals(this.stateMessage(), other.stateMessage()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"IpamPrefixListResolverTarget").add("IpamPrefixListResolverTargetId", (Object)this.ipamPrefixListResolverTargetId()).add("IpamPrefixListResolverTargetArn", (Object)this.ipamPrefixListResolverTargetArn()).add("IpamPrefixListResolverId", (Object)this.ipamPrefixListResolverId()).add("OwnerId", (Object)this.ownerId()).add("PrefixListId", (Object)this.prefixListId()).add("PrefixListRegion", (Object)this.prefixListRegion()).add("DesiredVersion", (Object)this.desiredVersion()).add("LastSyncedVersion", (Object)this.lastSyncedVersion()).add("TrackLatestVersion", (Object)this.trackLatestVersion()).add("StateMessage", (Object)this.stateMessage()).add("State", (Object)this.stateAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpamPrefixListResolverTargetId": {
                return Optional.ofNullable(clazz.cast(this.ipamPrefixListResolverTargetId()));
            }
            case "IpamPrefixListResolverTargetArn": {
                return Optional.ofNullable(clazz.cast(this.ipamPrefixListResolverTargetArn()));
            }
            case "IpamPrefixListResolverId": {
                return Optional.ofNullable(clazz.cast(this.ipamPrefixListResolverId()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "PrefixListId": {
                return Optional.ofNullable(clazz.cast(this.prefixListId()));
            }
            case "PrefixListRegion": {
                return Optional.ofNullable(clazz.cast(this.prefixListRegion()));
            }
            case "DesiredVersion": {
                return Optional.ofNullable(clazz.cast(this.desiredVersion()));
            }
            case "LastSyncedVersion": {
                return Optional.ofNullable(clazz.cast(this.lastSyncedVersion()));
            }
            case "TrackLatestVersion": {
                return Optional.ofNullable(clazz.cast(this.trackLatestVersion()));
            }
            case "StateMessage": {
                return Optional.ofNullable(clazz.cast(this.stateMessage()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IpamPrefixListResolverTargetId", IPAM_PREFIX_LIST_RESOLVER_TARGET_ID_FIELD);
        map.put("IpamPrefixListResolverTargetArn", IPAM_PREFIX_LIST_RESOLVER_TARGET_ARN_FIELD);
        map.put("IpamPrefixListResolverId", IPAM_PREFIX_LIST_RESOLVER_ID_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("PrefixListId", PREFIX_LIST_ID_FIELD);
        map.put("PrefixListRegion", PREFIX_LIST_REGION_FIELD);
        map.put("DesiredVersion", DESIRED_VERSION_FIELD);
        map.put("LastSyncedVersion", LAST_SYNCED_VERSION_FIELD);
        map.put("TrackLatestVersion", TRACK_LATEST_VERSION_FIELD);
        map.put("StateMessage", STATE_MESSAGE_FIELD);
        map.put("State", STATE_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpamPrefixListResolverTarget, T> g) {
        return obj -> g.apply((IpamPrefixListResolverTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipamPrefixListResolverTargetId;
        private String ipamPrefixListResolverTargetArn;
        private String ipamPrefixListResolverId;
        private String ownerId;
        private String prefixListId;
        private String prefixListRegion;
        private Long desiredVersion;
        private Long lastSyncedVersion;
        private Boolean trackLatestVersion;
        private String stateMessage;
        private String state;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IpamPrefixListResolverTarget model) {
            this.ipamPrefixListResolverTargetId(model.ipamPrefixListResolverTargetId);
            this.ipamPrefixListResolverTargetArn(model.ipamPrefixListResolverTargetArn);
            this.ipamPrefixListResolverId(model.ipamPrefixListResolverId);
            this.ownerId(model.ownerId);
            this.prefixListId(model.prefixListId);
            this.prefixListRegion(model.prefixListRegion);
            this.desiredVersion(model.desiredVersion);
            this.lastSyncedVersion(model.lastSyncedVersion);
            this.trackLatestVersion(model.trackLatestVersion);
            this.stateMessage(model.stateMessage);
            this.state(model.state);
            this.tags(model.tags);
        }

        public final String getIpamPrefixListResolverTargetId() {
            return this.ipamPrefixListResolverTargetId;
        }

        public final void setIpamPrefixListResolverTargetId(String ipamPrefixListResolverTargetId) {
            this.ipamPrefixListResolverTargetId = ipamPrefixListResolverTargetId;
        }

        @Override
        public final Builder ipamPrefixListResolverTargetId(String ipamPrefixListResolverTargetId) {
            this.ipamPrefixListResolverTargetId = ipamPrefixListResolverTargetId;
            return this;
        }

        public final String getIpamPrefixListResolverTargetArn() {
            return this.ipamPrefixListResolverTargetArn;
        }

        public final void setIpamPrefixListResolverTargetArn(String ipamPrefixListResolverTargetArn) {
            this.ipamPrefixListResolverTargetArn = ipamPrefixListResolverTargetArn;
        }

        @Override
        public final Builder ipamPrefixListResolverTargetArn(String ipamPrefixListResolverTargetArn) {
            this.ipamPrefixListResolverTargetArn = ipamPrefixListResolverTargetArn;
            return this;
        }

        public final String getIpamPrefixListResolverId() {
            return this.ipamPrefixListResolverId;
        }

        public final void setIpamPrefixListResolverId(String ipamPrefixListResolverId) {
            this.ipamPrefixListResolverId = ipamPrefixListResolverId;
        }

        @Override
        public final Builder ipamPrefixListResolverId(String ipamPrefixListResolverId) {
            this.ipamPrefixListResolverId = ipamPrefixListResolverId;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getPrefixListId() {
            return this.prefixListId;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final String getPrefixListRegion() {
            return this.prefixListRegion;
        }

        public final void setPrefixListRegion(String prefixListRegion) {
            this.prefixListRegion = prefixListRegion;
        }

        @Override
        public final Builder prefixListRegion(String prefixListRegion) {
            this.prefixListRegion = prefixListRegion;
            return this;
        }

        public final Long getDesiredVersion() {
            return this.desiredVersion;
        }

        public final void setDesiredVersion(Long desiredVersion) {
            this.desiredVersion = desiredVersion;
        }

        @Override
        public final Builder desiredVersion(Long desiredVersion) {
            this.desiredVersion = desiredVersion;
            return this;
        }

        public final Long getLastSyncedVersion() {
            return this.lastSyncedVersion;
        }

        public final void setLastSyncedVersion(Long lastSyncedVersion) {
            this.lastSyncedVersion = lastSyncedVersion;
        }

        @Override
        public final Builder lastSyncedVersion(Long lastSyncedVersion) {
            this.lastSyncedVersion = lastSyncedVersion;
            return this;
        }

        public final Boolean getTrackLatestVersion() {
            return this.trackLatestVersion;
        }

        public final void setTrackLatestVersion(Boolean trackLatestVersion) {
            this.trackLatestVersion = trackLatestVersion;
        }

        @Override
        public final Builder trackLatestVersion(Boolean trackLatestVersion) {
            this.trackLatestVersion = trackLatestVersion;
            return this;
        }

        public final String getStateMessage() {
            return this.stateMessage;
        }

        public final void setStateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
        }

        @Override
        public final Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(IpamPrefixListResolverTargetState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public IpamPrefixListResolverTarget build() {
            return new IpamPrefixListResolverTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpamPrefixListResolverTarget> {
        public Builder ipamPrefixListResolverTargetId(String var1);

        public Builder ipamPrefixListResolverTargetArn(String var1);

        public Builder ipamPrefixListResolverId(String var1);

        public Builder ownerId(String var1);

        public Builder prefixListId(String var1);

        public Builder prefixListRegion(String var1);

        public Builder desiredVersion(Long var1);

        public Builder lastSyncedVersion(Long var1);

        public Builder trackLatestVersion(Boolean var1);

        public Builder stateMessage(String var1);

        public Builder state(String var1);

        public Builder state(IpamPrefixListResolverTargetState var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

