/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.IpamDiscoveryFailureReason;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpamDiscoveredAccount
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpamDiscoveredAccount> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(IpamDiscoveredAccount.getter(IpamDiscoveredAccount::accountId)).setter(IpamDiscoveredAccount.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").unmarshallLocationName("accountId").build()}).build();
    private static final SdkField<String> DISCOVERY_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiscoveryRegion").getter(IpamDiscoveredAccount.getter(IpamDiscoveredAccount::discoveryRegion)).setter(IpamDiscoveredAccount.setter(Builder::discoveryRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryRegion").unmarshallLocationName("discoveryRegion").build()}).build();
    private static final SdkField<IpamDiscoveryFailureReason> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FailureReason").getter(IpamDiscoveredAccount.getter(IpamDiscoveredAccount::failureReason)).setter(IpamDiscoveredAccount.setter(Builder::failureReason)).constructor(IpamDiscoveryFailureReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").unmarshallLocationName("failureReason").build()}).build();
    private static final SdkField<Instant> LAST_ATTEMPTED_DISCOVERY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastAttemptedDiscoveryTime").getter(IpamDiscoveredAccount.getter(IpamDiscoveredAccount::lastAttemptedDiscoveryTime)).setter(IpamDiscoveredAccount.setter(Builder::lastAttemptedDiscoveryTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAttemptedDiscoveryTime").unmarshallLocationName("lastAttemptedDiscoveryTime").build()}).build();
    private static final SdkField<Instant> LAST_SUCCESSFUL_DISCOVERY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastSuccessfulDiscoveryTime").getter(IpamDiscoveredAccount.getter(IpamDiscoveredAccount::lastSuccessfulDiscoveryTime)).setter(IpamDiscoveredAccount.setter(Builder::lastSuccessfulDiscoveryTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulDiscoveryTime").unmarshallLocationName("lastSuccessfulDiscoveryTime").build()}).build();
    private static final SdkField<String> ORGANIZATIONAL_UNIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationalUnitId").getter(IpamDiscoveredAccount.getter(IpamDiscoveredAccount::organizationalUnitId)).setter(IpamDiscoveredAccount.setter(Builder::organizationalUnitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitId").unmarshallLocationName("organizationalUnitId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, DISCOVERY_REGION_FIELD, FAILURE_REASON_FIELD, LAST_ATTEMPTED_DISCOVERY_TIME_FIELD, LAST_SUCCESSFUL_DISCOVERY_TIME_FIELD, ORGANIZATIONAL_UNIT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IpamDiscoveredAccount.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String discoveryRegion;
    private final IpamDiscoveryFailureReason failureReason;
    private final Instant lastAttemptedDiscoveryTime;
    private final Instant lastSuccessfulDiscoveryTime;
    private final String organizationalUnitId;

    private IpamDiscoveredAccount(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.discoveryRegion = builder.discoveryRegion;
        this.failureReason = builder.failureReason;
        this.lastAttemptedDiscoveryTime = builder.lastAttemptedDiscoveryTime;
        this.lastSuccessfulDiscoveryTime = builder.lastSuccessfulDiscoveryTime;
        this.organizationalUnitId = builder.organizationalUnitId;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String discoveryRegion() {
        return this.discoveryRegion;
    }

    public final IpamDiscoveryFailureReason failureReason() {
        return this.failureReason;
    }

    public final Instant lastAttemptedDiscoveryTime() {
        return this.lastAttemptedDiscoveryTime;
    }

    public final Instant lastSuccessfulDiscoveryTime() {
        return this.lastSuccessfulDiscoveryTime;
    }

    public final String organizationalUnitId() {
        return this.organizationalUnitId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.discoveryRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAttemptedDiscoveryTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfulDiscoveryTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationalUnitId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamDiscoveredAccount)) {
            return false;
        }
        IpamDiscoveredAccount other = (IpamDiscoveredAccount)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.discoveryRegion(), other.discoveryRegion()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.lastAttemptedDiscoveryTime(), other.lastAttemptedDiscoveryTime()) && Objects.equals(this.lastSuccessfulDiscoveryTime(), other.lastSuccessfulDiscoveryTime()) && Objects.equals(this.organizationalUnitId(), other.organizationalUnitId());
    }

    public final String toString() {
        return ToString.builder((String)"IpamDiscoveredAccount").add("AccountId", (Object)this.accountId()).add("DiscoveryRegion", (Object)this.discoveryRegion()).add("FailureReason", (Object)this.failureReason()).add("LastAttemptedDiscoveryTime", (Object)this.lastAttemptedDiscoveryTime()).add("LastSuccessfulDiscoveryTime", (Object)this.lastSuccessfulDiscoveryTime()).add("OrganizationalUnitId", (Object)this.organizationalUnitId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "DiscoveryRegion": {
                return Optional.ofNullable(clazz.cast(this.discoveryRegion()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "LastAttemptedDiscoveryTime": {
                return Optional.ofNullable(clazz.cast(this.lastAttemptedDiscoveryTime()));
            }
            case "LastSuccessfulDiscoveryTime": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessfulDiscoveryTime()));
            }
            case "OrganizationalUnitId": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnitId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("DiscoveryRegion", DISCOVERY_REGION_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("LastAttemptedDiscoveryTime", LAST_ATTEMPTED_DISCOVERY_TIME_FIELD);
        map.put("LastSuccessfulDiscoveryTime", LAST_SUCCESSFUL_DISCOVERY_TIME_FIELD);
        map.put("OrganizationalUnitId", ORGANIZATIONAL_UNIT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpamDiscoveredAccount, T> g) {
        return obj -> g.apply((IpamDiscoveredAccount)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String discoveryRegion;
        private IpamDiscoveryFailureReason failureReason;
        private Instant lastAttemptedDiscoveryTime;
        private Instant lastSuccessfulDiscoveryTime;
        private String organizationalUnitId;

        private BuilderImpl() {
        }

        private BuilderImpl(IpamDiscoveredAccount model) {
            this.accountId(model.accountId);
            this.discoveryRegion(model.discoveryRegion);
            this.failureReason(model.failureReason);
            this.lastAttemptedDiscoveryTime(model.lastAttemptedDiscoveryTime);
            this.lastSuccessfulDiscoveryTime(model.lastSuccessfulDiscoveryTime);
            this.organizationalUnitId(model.organizationalUnitId);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getDiscoveryRegion() {
            return this.discoveryRegion;
        }

        public final void setDiscoveryRegion(String discoveryRegion) {
            this.discoveryRegion = discoveryRegion;
        }

        @Override
        public final Builder discoveryRegion(String discoveryRegion) {
            this.discoveryRegion = discoveryRegion;
            return this;
        }

        public final IpamDiscoveryFailureReason.Builder getFailureReason() {
            return this.failureReason != null ? this.failureReason.toBuilder() : null;
        }

        public final void setFailureReason(IpamDiscoveryFailureReason.BuilderImpl failureReason) {
            this.failureReason = failureReason != null ? failureReason.build() : null;
        }

        @Override
        public final Builder failureReason(IpamDiscoveryFailureReason failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final Instant getLastAttemptedDiscoveryTime() {
            return this.lastAttemptedDiscoveryTime;
        }

        public final void setLastAttemptedDiscoveryTime(Instant lastAttemptedDiscoveryTime) {
            this.lastAttemptedDiscoveryTime = lastAttemptedDiscoveryTime;
        }

        @Override
        public final Builder lastAttemptedDiscoveryTime(Instant lastAttemptedDiscoveryTime) {
            this.lastAttemptedDiscoveryTime = lastAttemptedDiscoveryTime;
            return this;
        }

        public final Instant getLastSuccessfulDiscoveryTime() {
            return this.lastSuccessfulDiscoveryTime;
        }

        public final void setLastSuccessfulDiscoveryTime(Instant lastSuccessfulDiscoveryTime) {
            this.lastSuccessfulDiscoveryTime = lastSuccessfulDiscoveryTime;
        }

        @Override
        public final Builder lastSuccessfulDiscoveryTime(Instant lastSuccessfulDiscoveryTime) {
            this.lastSuccessfulDiscoveryTime = lastSuccessfulDiscoveryTime;
            return this;
        }

        public final String getOrganizationalUnitId() {
            return this.organizationalUnitId;
        }

        public final void setOrganizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
        }

        @Override
        public final Builder organizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
            return this;
        }

        public IpamDiscoveredAccount build() {
            return new IpamDiscoveredAccount(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpamDiscoveredAccount> {
        public Builder accountId(String var1);

        public Builder discoveryRegion(String var1);

        public Builder failureReason(IpamDiscoveryFailureReason var1);

        default public Builder failureReason(Consumer<IpamDiscoveryFailureReason.Builder> failureReason) {
            return this.failureReason((IpamDiscoveryFailureReason)((IpamDiscoveryFailureReason.Builder)IpamDiscoveryFailureReason.builder().applyMutation(failureReason)).build());
        }

        public Builder lastAttemptedDiscoveryTime(Instant var1);

        public Builder lastSuccessfulDiscoveryTime(Instant var1);

        public Builder organizationalUnitId(String var1);
    }
}

