/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableIpamPolicyRequest extends Ec2Request implements
        ToCopyableBuilder<EnableIpamPolicyRequest.Builder, EnableIpamPolicyRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(EnableIpamPolicyRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> IPAM_POLICY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamPolicyId")
            .getter(getter(EnableIpamPolicyRequest::ipamPolicyId))
            .setter(setter(Builder::ipamPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPolicyId")
                    .unmarshallLocationName("IpamPolicyId").build()).build();

    private static final SdkField<String> ORGANIZATION_TARGET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OrganizationTargetId")
            .getter(getter(EnableIpamPolicyRequest::organizationTargetId))
            .setter(setter(Builder::organizationTargetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationTargetId")
                    .unmarshallLocationName("OrganizationTargetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            IPAM_POLICY_ID_FIELD, ORGANIZATION_TARGET_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean dryRun;

    private final String ipamPolicyId;

    private final String organizationTargetId;

    private EnableIpamPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.ipamPolicyId = builder.ipamPolicyId;
        this.organizationTargetId = builder.organizationTargetId;
    }

    /**
     * <p>
     * A check for whether you have the required permissions for the action without actually making the request and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return A check for whether you have the required permissions for the action without actually making the request
     *         and provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the IPAM policy to enable.
     * </p>
     * 
     * @return The ID of the IPAM policy to enable.
     */
    public final String ipamPolicyId() {
        return ipamPolicyId;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services Organizations target for which to enable the IPAM policy. This parameter is
     * required only when IPAM is integrated with Amazon Web Services Organizations. When IPAM is not integrated with
     * Amazon Web Services Organizations, omit this parameter and the policy will apply to the current account.
     * </p>
     * <p>
     * A target can be an individual Amazon Web Services account or an entity within an Amazon Web Services Organization
     * to which an IPAM policy can be applied.
     * </p>
     * 
     * @return The ID of the Amazon Web Services Organizations target for which to enable the IPAM policy. This
     *         parameter is required only when IPAM is integrated with Amazon Web Services Organizations. When IPAM is
     *         not integrated with Amazon Web Services Organizations, omit this parameter and the policy will apply to
     *         the current account.</p>
     *         <p>
     *         A target can be an individual Amazon Web Services account or an entity within an Amazon Web Services
     *         Organization to which an IPAM policy can be applied.
     */
    public final String organizationTargetId() {
        return organizationTargetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(ipamPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(organizationTargetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableIpamPolicyRequest)) {
            return false;
        }
        EnableIpamPolicyRequest other = (EnableIpamPolicyRequest) obj;
        return Objects.equals(dryRun(), other.dryRun()) && Objects.equals(ipamPolicyId(), other.ipamPolicyId())
                && Objects.equals(organizationTargetId(), other.organizationTargetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableIpamPolicyRequest").add("DryRun", dryRun()).add("IpamPolicyId", ipamPolicyId())
                .add("OrganizationTargetId", organizationTargetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "IpamPolicyId":
            return Optional.ofNullable(clazz.cast(ipamPolicyId()));
        case "OrganizationTargetId":
            return Optional.ofNullable(clazz.cast(organizationTargetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("IpamPolicyId", IPAM_POLICY_ID_FIELD);
        map.put("OrganizationTargetId", ORGANIZATION_TARGET_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableIpamPolicyRequest, T> g) {
        return obj -> g.apply((EnableIpamPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, EnableIpamPolicyRequest> {
        /**
         * <p>
         * A check for whether you have the required permissions for the action without actually making the request and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        A check for whether you have the required permissions for the action without actually making the
         *        request and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the IPAM policy to enable.
         * </p>
         * 
         * @param ipamPolicyId
         *        The ID of the IPAM policy to enable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPolicyId(String ipamPolicyId);

        /**
         * <p>
         * The ID of the Amazon Web Services Organizations target for which to enable the IPAM policy. This parameter is
         * required only when IPAM is integrated with Amazon Web Services Organizations. When IPAM is not integrated
         * with Amazon Web Services Organizations, omit this parameter and the policy will apply to the current account.
         * </p>
         * <p>
         * A target can be an individual Amazon Web Services account or an entity within an Amazon Web Services
         * Organization to which an IPAM policy can be applied.
         * </p>
         * 
         * @param organizationTargetId
         *        The ID of the Amazon Web Services Organizations target for which to enable the IPAM policy. This
         *        parameter is required only when IPAM is integrated with Amazon Web Services Organizations. When IPAM
         *        is not integrated with Amazon Web Services Organizations, omit this parameter and the policy will
         *        apply to the current account.</p>
         *        <p>
         *        A target can be an individual Amazon Web Services account or an entity within an Amazon Web Services
         *        Organization to which an IPAM policy can be applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationTargetId(String organizationTargetId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String ipamPolicyId;

        private String organizationTargetId;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableIpamPolicyRequest model) {
            super(model);
            dryRun(model.dryRun);
            ipamPolicyId(model.ipamPolicyId);
            organizationTargetId(model.organizationTargetId);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getIpamPolicyId() {
            return ipamPolicyId;
        }

        public final void setIpamPolicyId(String ipamPolicyId) {
            this.ipamPolicyId = ipamPolicyId;
        }

        @Override
        public final Builder ipamPolicyId(String ipamPolicyId) {
            this.ipamPolicyId = ipamPolicyId;
            return this;
        }

        public final String getOrganizationTargetId() {
            return organizationTargetId;
        }

        public final void setOrganizationTargetId(String organizationTargetId) {
            this.organizationTargetId = organizationTargetId;
        }

        @Override
        public final Builder organizationTargetId(String organizationTargetId) {
            this.organizationTargetId = organizationTargetId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableIpamPolicyRequest build() {
            return new EnableIpamPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
