/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.GetCapacityManagerMetricDataRequest;
import software.amazon.awssdk.services.ec2.model.GetCapacityManagerMetricDataResponse;
import software.amazon.awssdk.services.ec2.model.MetricDataResult;

public class GetCapacityManagerMetricDataIterable
implements SdkIterable<GetCapacityManagerMetricDataResponse> {
    private final Ec2Client client;
    private final GetCapacityManagerMetricDataRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetCapacityManagerMetricDataIterable(Ec2Client client, GetCapacityManagerMetricDataRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetCapacityManagerMetricDataResponseFetcher();
    }

    public Iterator<GetCapacityManagerMetricDataResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MetricDataResult> metricDataResults() {
        Function<GetCapacityManagerMetricDataResponse, Iterator> getIterator = response -> {
            if (response != null && response.metricDataResults() != null) {
                return response.metricDataResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetCapacityManagerMetricDataResponseFetcher
    implements SyncPageFetcher<GetCapacityManagerMetricDataResponse> {
        private GetCapacityManagerMetricDataResponseFetcher() {
        }

        public boolean hasNextPage(GetCapacityManagerMetricDataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetCapacityManagerMetricDataResponse nextPage(GetCapacityManagerMetricDataResponse previousPage) {
            if (previousPage == null) {
                return GetCapacityManagerMetricDataIterable.this.client.getCapacityManagerMetricData(GetCapacityManagerMetricDataIterable.this.firstRequest);
            }
            return GetCapacityManagerMetricDataIterable.this.client.getCapacityManagerMetricData((GetCapacityManagerMetricDataRequest)((Object)GetCapacityManagerMetricDataIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

