/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.CapacityBlockStatus;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockStatusResponse;

public class DescribeCapacityBlockStatusIterable
implements SdkIterable<DescribeCapacityBlockStatusResponse> {
    private final Ec2Client client;
    private final DescribeCapacityBlockStatusRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCapacityBlockStatusIterable(Ec2Client client, DescribeCapacityBlockStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeCapacityBlockStatusResponseFetcher();
    }

    public Iterator<DescribeCapacityBlockStatusResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CapacityBlockStatus> capacityBlockStatuses() {
        Function<DescribeCapacityBlockStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.capacityBlockStatuses() != null) {
                return response.capacityBlockStatuses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeCapacityBlockStatusResponseFetcher
    implements SyncPageFetcher<DescribeCapacityBlockStatusResponse> {
        private DescribeCapacityBlockStatusResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCapacityBlockStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeCapacityBlockStatusResponse nextPage(DescribeCapacityBlockStatusResponse previousPage) {
            if (previousPage == null) {
                return DescribeCapacityBlockStatusIterable.this.client.describeCapacityBlockStatus(DescribeCapacityBlockStatusIterable.this.firstRequest);
            }
            return DescribeCapacityBlockStatusIterable.this.client.describeCapacityBlockStatus((DescribeCapacityBlockStatusRequest)((Object)DescribeCapacityBlockStatusIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

