/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RouteOrigin {
    CREATE_ROUTE_TABLE("CreateRouteTable"),
    CREATE_ROUTE("CreateRoute"),
    ENABLE_VGW_ROUTE_PROPAGATION("EnableVgwRoutePropagation"),
    ADVERTISEMENT("Advertisement"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RouteOrigin> VALUE_MAP;
    private final String value;

    private RouteOrigin(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RouteOrigin fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RouteOrigin> knownValues() {
        EnumSet<RouteOrigin> knownValues = EnumSet.allOf(RouteOrigin.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RouteOrigin.class, RouteOrigin::toString);
    }
}

