/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayAttachmentPropagationsRequest;
import software.amazon.awssdk.services.ec2.model.GetTransitGatewayAttachmentPropagationsResponse;
import software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentPropagation;

public class GetTransitGatewayAttachmentPropagationsIterable
implements SdkIterable<GetTransitGatewayAttachmentPropagationsResponse> {
    private final Ec2Client client;
    private final GetTransitGatewayAttachmentPropagationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetTransitGatewayAttachmentPropagationsIterable(Ec2Client client, GetTransitGatewayAttachmentPropagationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetTransitGatewayAttachmentPropagationsResponseFetcher();
    }

    public Iterator<GetTransitGatewayAttachmentPropagationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TransitGatewayAttachmentPropagation> transitGatewayAttachmentPropagations() {
        Function<GetTransitGatewayAttachmentPropagationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.transitGatewayAttachmentPropagations() != null) {
                return response.transitGatewayAttachmentPropagations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetTransitGatewayAttachmentPropagationsResponseFetcher
    implements SyncPageFetcher<GetTransitGatewayAttachmentPropagationsResponse> {
        private GetTransitGatewayAttachmentPropagationsResponseFetcher() {
        }

        public boolean hasNextPage(GetTransitGatewayAttachmentPropagationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetTransitGatewayAttachmentPropagationsResponse nextPage(GetTransitGatewayAttachmentPropagationsResponse previousPage) {
            if (previousPage == null) {
                return GetTransitGatewayAttachmentPropagationsIterable.this.client.getTransitGatewayAttachmentPropagations(GetTransitGatewayAttachmentPropagationsIterable.this.firstRequest);
            }
            return GetTransitGatewayAttachmentPropagationsIterable.this.client.getTransitGatewayAttachmentPropagations((GetTransitGatewayAttachmentPropagationsRequest)((Object)GetTransitGatewayAttachmentPropagationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

