/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.auth.scheme;

import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeProvider;
import software.amazon.awssdk.services.ec2.auth.scheme.Ec2AuthSchemeParams;
import software.amazon.awssdk.services.ec2.auth.scheme.internal.DefaultEc2AuthSchemeProvider;
import software.amazon.awssdk.services.ec2.auth.scheme.internal.PreferredEc2AuthSchemeProvider;

@SdkPublicApi
public interface Ec2AuthSchemeProvider
extends AuthSchemeProvider {
    public List<AuthSchemeOption> resolveAuthScheme(Ec2AuthSchemeParams var1);

    default public List<AuthSchemeOption> resolveAuthScheme(Consumer<Ec2AuthSchemeParams.Builder> consumer) {
        Ec2AuthSchemeParams.Builder builder = Ec2AuthSchemeParams.builder();
        consumer.accept(builder);
        return this.resolveAuthScheme(builder.build());
    }

    public static Ec2AuthSchemeProvider defaultProvider() {
        return DefaultEc2AuthSchemeProvider.create();
    }

    public static Ec2AuthSchemeProvider defaultProvider(List<String> authSchemePreference) {
        return new PreferredEc2AuthSchemeProvider(Ec2AuthSchemeProvider.defaultProvider(), authSchemePreference);
    }
}

