/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OfferingTypeValues {
    HEAVY_UTILIZATION("Heavy Utilization"),
    MEDIUM_UTILIZATION("Medium Utilization"),
    LIGHT_UTILIZATION("Light Utilization"),
    NO_UPFRONT("No Upfront"),
    PARTIAL_UPFRONT("Partial Upfront"),
    ALL_UPFRONT("All Upfront"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OfferingTypeValues> VALUE_MAP;
    private final String value;

    private OfferingTypeValues(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OfferingTypeValues fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OfferingTypeValues> knownValues() {
        EnumSet<OfferingTypeValues> knownValues = EnumSet.allOf(OfferingTypeValues.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OfferingTypeValues.class, OfferingTypeValues::toString);
    }
}

