/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeImageUsageReportEntriesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImageUsageReportEntriesResponse;
import software.amazon.awssdk.services.ec2.model.ImageUsageReportEntry;

public class DescribeImageUsageReportEntriesIterable
implements SdkIterable<DescribeImageUsageReportEntriesResponse> {
    private final Ec2Client client;
    private final DescribeImageUsageReportEntriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeImageUsageReportEntriesIterable(Ec2Client client, DescribeImageUsageReportEntriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeImageUsageReportEntriesResponseFetcher();
    }

    public Iterator<DescribeImageUsageReportEntriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImageUsageReportEntry> imageUsageReportEntries() {
        Function<DescribeImageUsageReportEntriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.imageUsageReportEntries() != null) {
                return response.imageUsageReportEntries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeImageUsageReportEntriesResponseFetcher
    implements SyncPageFetcher<DescribeImageUsageReportEntriesResponse> {
        private DescribeImageUsageReportEntriesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeImageUsageReportEntriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeImageUsageReportEntriesResponse nextPage(DescribeImageUsageReportEntriesResponse previousPage) {
            if (previousPage == null) {
                return DescribeImageUsageReportEntriesIterable.this.client.describeImageUsageReportEntries(DescribeImageUsageReportEntriesIterable.this.firstRequest);
            }
            return DescribeImageUsageReportEntriesIterable.this.client.describeImageUsageReportEntries((DescribeImageUsageReportEntriesRequest)((Object)DescribeImageUsageReportEntriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

