/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ReportState {
    RUNNING("running"),
    CANCELLED("cancelled"),
    COMPLETE("complete"),
    ERROR("error"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReportState> VALUE_MAP;
    private final String value;

    private ReportState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReportState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReportState> knownValues() {
        EnumSet<ReportState> knownValues = EnumSet.allOf(ReportState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ReportState.class, ReportState::toString);
    }
}

