/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a resource group to which a Capacity Reservation has been added.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityReservationGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityReservationGroup.Builder, CapacityReservationGroup> {
    private static final SdkField<String> GROUP_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupArn")
            .getter(getter(CapacityReservationGroup::groupArn))
            .setter(setter(Builder::groupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupArn")
                    .unmarshallLocationName("groupArn").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(CapacityReservationGroup::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ARN_FIELD,
            OWNER_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String groupArn;

    private final String ownerId;

    private CapacityReservationGroup(BuilderImpl builder) {
        this.groupArn = builder.groupArn;
        this.ownerId = builder.ownerId;
    }

    /**
     * <p>
     * The ARN of the resource group.
     * </p>
     * 
     * @return The ARN of the resource group.
     */
    public final String groupArn() {
        return groupArn;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the resource group.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the resource group.
     */
    public final String ownerId() {
        return ownerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupArn());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityReservationGroup)) {
            return false;
        }
        CapacityReservationGroup other = (CapacityReservationGroup) obj;
        return Objects.equals(groupArn(), other.groupArn()) && Objects.equals(ownerId(), other.ownerId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityReservationGroup").add("GroupArn", groupArn()).add("OwnerId", ownerId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupArn":
            return Optional.ofNullable(clazz.cast(groupArn()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupArn", GROUP_ARN_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityReservationGroup, T> g) {
        return obj -> g.apply((CapacityReservationGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityReservationGroup> {
        /**
         * <p>
         * The ARN of the resource group.
         * </p>
         * 
         * @param groupArn
         *        The ARN of the resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupArn(String groupArn);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the resource group.
         * </p>
         * 
         * @param ownerId
         *        The ID of the Amazon Web Services account that owns the resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);
    }

    static final class BuilderImpl implements Builder {
        private String groupArn;

        private String ownerId;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityReservationGroup model) {
            groupArn(model.groupArn);
            ownerId(model.ownerId);
        }

        public final String getGroupArn() {
            return groupArn;
        }

        public final void setGroupArn(String groupArn) {
            this.groupArn = groupArn;
        }

        @Override
        public final Builder groupArn(String groupArn) {
            this.groupArn = groupArn;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        @Override
        public CapacityReservationGroup build() {
            return new CapacityReservationGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
