/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAllowedImagesSettingsResponse extends Ec2Response implements
        ToCopyableBuilder<GetAllowedImagesSettingsResponse.Builder, GetAllowedImagesSettingsResponse> {
    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(GetAllowedImagesSettingsResponse::state))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<List<ImageCriterion>> IMAGE_CRITERIA_FIELD = SdkField
            .<List<ImageCriterion>> builder(MarshallingType.LIST)
            .memberName("ImageCriteria")
            .getter(getter(GetAllowedImagesSettingsResponse::imageCriteria))
            .setter(setter(Builder::imageCriteria))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageCriterionSet")
                    .unmarshallLocationName("imageCriterionSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ImageCriterion> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImageCriterion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> MANAGED_BY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ManagedBy")
            .getter(getter(GetAllowedImagesSettingsResponse::managedByAsString))
            .setter(setter(Builder::managedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedBy")
                    .unmarshallLocationName("managedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD,
            IMAGE_CRITERIA_FIELD, MANAGED_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String state;

    private final List<ImageCriterion> imageCriteria;

    private final String managedBy;

    private GetAllowedImagesSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.state = builder.state;
        this.imageCriteria = builder.imageCriteria;
        this.managedBy = builder.managedBy;
    }

    /**
     * <p>
     * The current state of the Allowed AMIs setting at the account level in the specified Amazon Web Services Region.
     * </p>
     * <p>
     * Possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>disabled</code>: All AMIs are allowed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>audit-mode</code>: All AMIs are allowed, but the <code>ImageAllowed</code> field is set to
     * <code>true</code> if the AMI would be allowed with the current list of criteria if allowed AMIs was enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>enabled</code>: Only AMIs matching the image criteria are discoverable and available for use.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The current state of the Allowed AMIs setting at the account level in the specified Amazon Web Services
     *         Region.</p>
     *         <p>
     *         Possible values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>disabled</code>: All AMIs are allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>audit-mode</code>: All AMIs are allowed, but the <code>ImageAllowed</code> field is set to
     *         <code>true</code> if the AMI would be allowed with the current list of criteria if allowed AMIs was
     *         enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>enabled</code>: Only AMIs matching the image criteria are discoverable and available for use.
     *         </p>
     *         </li>
     */
    public final String state() {
        return state;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImageCriteria property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasImageCriteria() {
        return imageCriteria != null && !(imageCriteria instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of criteria for images that are discoverable and usable in the account in the specified Amazon Web
     * Services Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImageCriteria} method.
     * </p>
     * 
     * @return The list of criteria for images that are discoverable and usable in the account in the specified Amazon
     *         Web Services Region.
     */
    public final List<ImageCriterion> imageCriteria() {
        return imageCriteria;
    }

    /**
     * <p>
     * The entity that manages the Allowed AMIs settings. Possible values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>account</code> - The Allowed AMIs settings is managed by the account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>declarative-policy</code> - The Allowed AMIs settings is managed by a declarative policy and can't be
     * modified by the account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #managedBy} will
     * return {@link ManagedBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #managedByAsString}.
     * </p>
     * 
     * @return The entity that manages the Allowed AMIs settings. Possible values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>account</code> - The Allowed AMIs settings is managed by the account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>declarative-policy</code> - The Allowed AMIs settings is managed by a declarative policy and can't
     *         be modified by the account.
     *         </p>
     *         </li>
     * @see ManagedBy
     */
    public final ManagedBy managedBy() {
        return ManagedBy.fromValue(managedBy);
    }

    /**
     * <p>
     * The entity that manages the Allowed AMIs settings. Possible values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>account</code> - The Allowed AMIs settings is managed by the account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>declarative-policy</code> - The Allowed AMIs settings is managed by a declarative policy and can't be
     * modified by the account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #managedBy} will
     * return {@link ManagedBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #managedByAsString}.
     * </p>
     * 
     * @return The entity that manages the Allowed AMIs settings. Possible values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>account</code> - The Allowed AMIs settings is managed by the account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>declarative-policy</code> - The Allowed AMIs settings is managed by a declarative policy and can't
     *         be modified by the account.
     *         </p>
     *         </li>
     * @see ManagedBy
     */
    public final String managedByAsString() {
        return managedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(hasImageCriteria() ? imageCriteria() : null);
        hashCode = 31 * hashCode + Objects.hashCode(managedByAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAllowedImagesSettingsResponse)) {
            return false;
        }
        GetAllowedImagesSettingsResponse other = (GetAllowedImagesSettingsResponse) obj;
        return Objects.equals(state(), other.state()) && hasImageCriteria() == other.hasImageCriteria()
                && Objects.equals(imageCriteria(), other.imageCriteria())
                && Objects.equals(managedByAsString(), other.managedByAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAllowedImagesSettingsResponse").add("State", state())
                .add("ImageCriteria", hasImageCriteria() ? imageCriteria() : null).add("ManagedBy", managedByAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "ImageCriteria":
            return Optional.ofNullable(clazz.cast(imageCriteria()));
        case "ManagedBy":
            return Optional.ofNullable(clazz.cast(managedByAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("State", STATE_FIELD);
        map.put("ImageCriterionSet", IMAGE_CRITERIA_FIELD);
        map.put("ManagedBy", MANAGED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAllowedImagesSettingsResponse, T> g) {
        return obj -> g.apply((GetAllowedImagesSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetAllowedImagesSettingsResponse> {
        /**
         * <p>
         * The current state of the Allowed AMIs setting at the account level in the specified Amazon Web Services
         * Region.
         * </p>
         * <p>
         * Possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>disabled</code>: All AMIs are allowed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>audit-mode</code>: All AMIs are allowed, but the <code>ImageAllowed</code> field is set to
         * <code>true</code> if the AMI would be allowed with the current list of criteria if allowed AMIs was enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>enabled</code>: Only AMIs matching the image criteria are discoverable and available for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param state
         *        The current state of the Allowed AMIs setting at the account level in the specified Amazon Web
         *        Services Region.</p>
         *        <p>
         *        Possible values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>disabled</code>: All AMIs are allowed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>audit-mode</code>: All AMIs are allowed, but the <code>ImageAllowed</code> field is set to
         *        <code>true</code> if the AMI would be allowed with the current list of criteria if allowed AMIs was
         *        enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>enabled</code>: Only AMIs matching the image criteria are discoverable and available for use.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The list of criteria for images that are discoverable and usable in the account in the specified Amazon Web
         * Services Region.
         * </p>
         * 
         * @param imageCriteria
         *        The list of criteria for images that are discoverable and usable in the account in the specified
         *        Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageCriteria(Collection<ImageCriterion> imageCriteria);

        /**
         * <p>
         * The list of criteria for images that are discoverable and usable in the account in the specified Amazon Web
         * Services Region.
         * </p>
         * 
         * @param imageCriteria
         *        The list of criteria for images that are discoverable and usable in the account in the specified
         *        Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageCriteria(ImageCriterion... imageCriteria);

        /**
         * <p>
         * The list of criteria for images that are discoverable and usable in the account in the specified Amazon Web
         * Services Region.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.ImageCriterion.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.ImageCriterion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.ImageCriterion.Builder#build()} is called immediately and
         * its result is passed to {@link #imageCriteria(List<ImageCriterion>)}.
         * 
         * @param imageCriteria
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.ImageCriterion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageCriteria(java.util.Collection<ImageCriterion>)
         */
        Builder imageCriteria(Consumer<ImageCriterion.Builder>... imageCriteria);

        /**
         * <p>
         * The entity that manages the Allowed AMIs settings. Possible values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>account</code> - The Allowed AMIs settings is managed by the account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>declarative-policy</code> - The Allowed AMIs settings is managed by a declarative policy and can't be
         * modified by the account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param managedBy
         *        The entity that manages the Allowed AMIs settings. Possible values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>account</code> - The Allowed AMIs settings is managed by the account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>declarative-policy</code> - The Allowed AMIs settings is managed by a declarative policy and
         *        can't be modified by the account.
         *        </p>
         *        </li>
         * @see ManagedBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedBy
         */
        Builder managedBy(String managedBy);

        /**
         * <p>
         * The entity that manages the Allowed AMIs settings. Possible values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>account</code> - The Allowed AMIs settings is managed by the account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>declarative-policy</code> - The Allowed AMIs settings is managed by a declarative policy and can't be
         * modified by the account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param managedBy
         *        The entity that manages the Allowed AMIs settings. Possible values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>account</code> - The Allowed AMIs settings is managed by the account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>declarative-policy</code> - The Allowed AMIs settings is managed by a declarative policy and
         *        can't be modified by the account.
         *        </p>
         *        </li>
         * @see ManagedBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedBy
         */
        Builder managedBy(ManagedBy managedBy);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String state;

        private List<ImageCriterion> imageCriteria = DefaultSdkAutoConstructList.getInstance();

        private String managedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAllowedImagesSettingsResponse model) {
            super(model);
            state(model.state);
            imageCriteria(model.imageCriteria);
            managedBy(model.managedBy);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final List<ImageCriterion.Builder> getImageCriteria() {
            List<ImageCriterion.Builder> result = ImageCriterionListCopier.copyToBuilder(this.imageCriteria);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageCriteria(Collection<ImageCriterion.BuilderImpl> imageCriteria) {
            this.imageCriteria = ImageCriterionListCopier.copyFromBuilder(imageCriteria);
        }

        @Override
        public final Builder imageCriteria(Collection<ImageCriterion> imageCriteria) {
            this.imageCriteria = ImageCriterionListCopier.copy(imageCriteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageCriteria(ImageCriterion... imageCriteria) {
            imageCriteria(Arrays.asList(imageCriteria));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageCriteria(Consumer<ImageCriterion.Builder>... imageCriteria) {
            imageCriteria(Stream.of(imageCriteria).map(c -> ImageCriterion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getManagedBy() {
            return managedBy;
        }

        public final void setManagedBy(String managedBy) {
            this.managedBy = managedBy;
        }

        @Override
        public final Builder managedBy(String managedBy) {
            this.managedBy = managedBy;
            return this;
        }

        @Override
        public final Builder managedBy(ManagedBy managedBy) {
            this.managedBy(managedBy == null ? null : managedBy.toString());
            return this;
        }

        @Override
        public GetAllowedImagesSettingsResponse build() {
            return new GetAllowedImagesSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
