/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The current status of Client Route Enforcement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClientRouteEnforcementResponseOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<ClientRouteEnforcementResponseOptions.Builder, ClientRouteEnforcementResponseOptions> {
    private static final SdkField<Boolean> ENFORCED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enforced")
            .getter(getter(ClientRouteEnforcementResponseOptions::enforced))
            .setter(setter(Builder::enforced))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enforced")
                    .unmarshallLocationName("enforced").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENFORCED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enforced;

    private ClientRouteEnforcementResponseOptions(BuilderImpl builder) {
        this.enforced = builder.enforced;
    }

    /**
     * <p>
     * Status of the client route enforcement feature, indicating whether Client Route Enforcement is <code>true</code>
     * (enabled) or <code>false</code> (disabled).
     * </p>
     * <p>
     * Valid values: <code>true | false</code>
     * </p>
     * <p>
     * Default value: <code>false</code>
     * </p>
     * 
     * @return Status of the client route enforcement feature, indicating whether Client Route Enforcement is
     *         <code>true</code> (enabled) or <code>false</code> (disabled).</p>
     *         <p>
     *         Valid values: <code>true | false</code>
     *         </p>
     *         <p>
     *         Default value: <code>false</code>
     */
    public final Boolean enforced() {
        return enforced;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enforced());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientRouteEnforcementResponseOptions)) {
            return false;
        }
        ClientRouteEnforcementResponseOptions other = (ClientRouteEnforcementResponseOptions) obj;
        return Objects.equals(enforced(), other.enforced());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClientRouteEnforcementResponseOptions").add("Enforced", enforced()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enforced":
            return Optional.ofNullable(clazz.cast(enforced()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Enforced", ENFORCED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClientRouteEnforcementResponseOptions, T> g) {
        return obj -> g.apply((ClientRouteEnforcementResponseOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClientRouteEnforcementResponseOptions> {
        /**
         * <p>
         * Status of the client route enforcement feature, indicating whether Client Route Enforcement is
         * <code>true</code> (enabled) or <code>false</code> (disabled).
         * </p>
         * <p>
         * Valid values: <code>true | false</code>
         * </p>
         * <p>
         * Default value: <code>false</code>
         * </p>
         * 
         * @param enforced
         *        Status of the client route enforcement feature, indicating whether Client Route Enforcement is
         *        <code>true</code> (enabled) or <code>false</code> (disabled).</p>
         *        <p>
         *        Valid values: <code>true | false</code>
         *        </p>
         *        <p>
         *        Default value: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enforced(Boolean enforced);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enforced;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientRouteEnforcementResponseOptions model) {
            enforced(model.enforced);
        }

        public final Boolean getEnforced() {
            return enforced;
        }

        public final void setEnforced(Boolean enforced) {
            this.enforced = enforced;
        }

        @Override
        public final Builder enforced(Boolean enforced) {
            this.enforced = enforced;
            return this;
        }

        @Override
        public ClientRouteEnforcementResponseOptions build() {
            return new ClientRouteEnforcementResponseOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
