/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesOffering;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesOfferingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReservedInstancesOfferingsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeReservedInstancesOfferingsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeReservedInstancesOfferingsResponse.getter(DescribeReservedInstancesOfferingsResponse::nextToken)).setter(DescribeReservedInstancesOfferingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<List<ReservedInstancesOffering>> RESERVED_INSTANCES_OFFERINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReservedInstancesOfferings").getter(DescribeReservedInstancesOfferingsResponse.getter(DescribeReservedInstancesOfferingsResponse::reservedInstancesOfferings)).setter(DescribeReservedInstancesOfferingsResponse.setter(Builder::reservedInstancesOfferings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesOfferingsSet").unmarshallLocationName("reservedInstancesOfferingsSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservedInstancesOffering::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RESERVED_INSTANCES_OFFERINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeReservedInstancesOfferingsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ReservedInstancesOffering> reservedInstancesOfferings;

    private DescribeReservedInstancesOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.reservedInstancesOfferings = builder.reservedInstancesOfferings;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasReservedInstancesOfferings() {
        return this.reservedInstancesOfferings != null && !(this.reservedInstancesOfferings instanceof SdkAutoConstructList);
    }

    public final List<ReservedInstancesOffering> reservedInstancesOfferings() {
        return this.reservedInstancesOfferings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReservedInstancesOfferings() ? this.reservedInstancesOfferings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesOfferingsResponse)) {
            return false;
        }
        DescribeReservedInstancesOfferingsResponse other = (DescribeReservedInstancesOfferingsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasReservedInstancesOfferings() == other.hasReservedInstancesOfferings() && Objects.equals(this.reservedInstancesOfferings(), other.reservedInstancesOfferings());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeReservedInstancesOfferingsResponse").add("NextToken", (Object)this.nextToken()).add("ReservedInstancesOfferings", this.hasReservedInstancesOfferings() ? this.reservedInstancesOfferings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ReservedInstancesOfferings": {
                return Optional.ofNullable(clazz.cast(this.reservedInstancesOfferings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ReservedInstancesOfferingsSet", RESERVED_INSTANCES_OFFERINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedInstancesOfferingsResponse, T> g) {
        return obj -> g.apply((DescribeReservedInstancesOfferingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ReservedInstancesOffering> reservedInstancesOfferings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesOfferingsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.reservedInstancesOfferings(model.reservedInstancesOfferings);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ReservedInstancesOffering.Builder> getReservedInstancesOfferings() {
            List<ReservedInstancesOffering.Builder> result = ReservedInstancesOfferingListCopier.copyToBuilder(this.reservedInstancesOfferings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReservedInstancesOfferings(Collection<ReservedInstancesOffering.BuilderImpl> reservedInstancesOfferings) {
            this.reservedInstancesOfferings = ReservedInstancesOfferingListCopier.copyFromBuilder(reservedInstancesOfferings);
        }

        @Override
        public final Builder reservedInstancesOfferings(Collection<ReservedInstancesOffering> reservedInstancesOfferings) {
            this.reservedInstancesOfferings = ReservedInstancesOfferingListCopier.copy(reservedInstancesOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesOfferings(ReservedInstancesOffering ... reservedInstancesOfferings) {
            this.reservedInstancesOfferings(Arrays.asList(reservedInstancesOfferings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesOfferings(Consumer<ReservedInstancesOffering.Builder> ... reservedInstancesOfferings) {
            this.reservedInstancesOfferings(Stream.of(reservedInstancesOfferings).map(c -> (ReservedInstancesOffering)((ReservedInstancesOffering.Builder)ReservedInstancesOffering.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeReservedInstancesOfferingsResponse build() {
            return new DescribeReservedInstancesOfferingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReservedInstancesOfferingsResponse> {
        public Builder nextToken(String var1);

        public Builder reservedInstancesOfferings(Collection<ReservedInstancesOffering> var1);

        public Builder reservedInstancesOfferings(ReservedInstancesOffering ... var1);

        public Builder reservedInstancesOfferings(Consumer<ReservedInstancesOffering.Builder> ... var1);
    }
}

