/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.RouteServer;
import software.amazon.awssdk.services.ec2.model.RouteServersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRouteServersResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeRouteServersResponse> {
    private static final SdkField<List<RouteServer>> ROUTE_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RouteServers").getter(DescribeRouteServersResponse.getter(DescribeRouteServersResponse::routeServers)).setter(DescribeRouteServersResponse.setter(Builder::routeServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteServerSet").unmarshallLocationName("routeServerSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteServer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeRouteServersResponse.getter(DescribeRouteServersResponse::nextToken)).setter(DescribeRouteServersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_SERVERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeRouteServersResponse.memberNameToFieldInitializer();
    private final List<RouteServer> routeServers;
    private final String nextToken;

    private DescribeRouteServersResponse(BuilderImpl builder) {
        super(builder);
        this.routeServers = builder.routeServers;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRouteServers() {
        return this.routeServers != null && !(this.routeServers instanceof SdkAutoConstructList);
    }

    public final List<RouteServer> routeServers() {
        return this.routeServers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRouteServers() ? this.routeServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRouteServersResponse)) {
            return false;
        }
        DescribeRouteServersResponse other = (DescribeRouteServersResponse)((Object)obj);
        return this.hasRouteServers() == other.hasRouteServers() && Objects.equals(this.routeServers(), other.routeServers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRouteServersResponse").add("RouteServers", this.hasRouteServers() ? this.routeServers() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RouteServers": {
                return Optional.ofNullable(clazz.cast(this.routeServers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RouteServerSet", ROUTE_SERVERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRouteServersResponse, T> g) {
        return obj -> g.apply((DescribeRouteServersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<RouteServer> routeServers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRouteServersResponse model) {
            super(model);
            this.routeServers(model.routeServers);
            this.nextToken(model.nextToken);
        }

        public final List<RouteServer.Builder> getRouteServers() {
            List<RouteServer.Builder> result = RouteServersListCopier.copyToBuilder(this.routeServers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouteServers(Collection<RouteServer.BuilderImpl> routeServers) {
            this.routeServers = RouteServersListCopier.copyFromBuilder(routeServers);
        }

        @Override
        public final Builder routeServers(Collection<RouteServer> routeServers) {
            this.routeServers = RouteServersListCopier.copy(routeServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeServers(RouteServer ... routeServers) {
            this.routeServers(Arrays.asList(routeServers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeServers(Consumer<RouteServer.Builder> ... routeServers) {
            this.routeServers(Stream.of(routeServers).map(c -> (RouteServer)((RouteServer.Builder)RouteServer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeRouteServersResponse build() {
            return new DescribeRouteServersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRouteServersResponse> {
        public Builder routeServers(Collection<RouteServer> var1);

        public Builder routeServers(RouteServer ... var1);

        public Builder routeServers(Consumer<RouteServer.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

