/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TokenState {
    VALID("valid"),
    EXPIRED("expired"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TokenState> VALUE_MAP;
    private final String value;

    private TokenState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TokenState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TokenState> knownValues() {
        EnumSet<TokenState> knownValues = EnumSet.allOf(TokenState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TokenState.class, TokenState::toString);
    }
}

