/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationsResponse;
import software.amazon.awssdk.services.ec2.model.HostReservation;

public class DescribeHostReservationsPublisher
implements SdkPublisher<DescribeHostReservationsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeHostReservationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeHostReservationsPublisher(Ec2AsyncClient client, DescribeHostReservationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeHostReservationsPublisher(Ec2AsyncClient client, DescribeHostReservationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeHostReservationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeHostReservationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<HostReservation> hostReservationSet() {
        Function<DescribeHostReservationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.hostReservationSet() != null) {
                return response.hostReservationSet().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeHostReservationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeHostReservationsResponseFetcher
    implements AsyncPageFetcher<DescribeHostReservationsResponse> {
        private DescribeHostReservationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeHostReservationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeHostReservationsResponse> nextPage(DescribeHostReservationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeHostReservationsPublisher.this.client.describeHostReservations(DescribeHostReservationsPublisher.this.firstRequest);
            }
            return DescribeHostReservationsPublisher.this.client.describeHostReservations((DescribeHostReservationsRequest)((Object)DescribeHostReservationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

