/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkInterfaceAttachmentChanges
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkInterfaceAttachmentChanges> {
    private static final SdkField<Boolean> DEFAULT_ENA_QUEUE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DefaultEnaQueueCount").getter(NetworkInterfaceAttachmentChanges.getter(NetworkInterfaceAttachmentChanges::defaultEnaQueueCount)).setter(NetworkInterfaceAttachmentChanges.setter(Builder::defaultEnaQueueCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultEnaQueueCount").unmarshallLocationName("DefaultEnaQueueCount").build()}).build();
    private static final SdkField<Integer> ENA_QUEUE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EnaQueueCount").getter(NetworkInterfaceAttachmentChanges.getter(NetworkInterfaceAttachmentChanges::enaQueueCount)).setter(NetworkInterfaceAttachmentChanges.setter(Builder::enaQueueCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaQueueCount").unmarshallLocationName("EnaQueueCount").build()}).build();
    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttachmentId").getter(NetworkInterfaceAttachmentChanges.getter(NetworkInterfaceAttachmentChanges::attachmentId)).setter(NetworkInterfaceAttachmentChanges.setter(Builder::attachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentId").unmarshallLocationName("attachmentId").build()}).build();
    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteOnTermination").getter(NetworkInterfaceAttachmentChanges.getter(NetworkInterfaceAttachmentChanges::deleteOnTermination)).setter(NetworkInterfaceAttachmentChanges.setter(Builder::deleteOnTermination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination").unmarshallLocationName("deleteOnTermination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_ENA_QUEUE_COUNT_FIELD, ENA_QUEUE_COUNT_FIELD, ATTACHMENT_ID_FIELD, DELETE_ON_TERMINATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NetworkInterfaceAttachmentChanges.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean defaultEnaQueueCount;
    private final Integer enaQueueCount;
    private final String attachmentId;
    private final Boolean deleteOnTermination;

    private NetworkInterfaceAttachmentChanges(BuilderImpl builder) {
        this.defaultEnaQueueCount = builder.defaultEnaQueueCount;
        this.enaQueueCount = builder.enaQueueCount;
        this.attachmentId = builder.attachmentId;
        this.deleteOnTermination = builder.deleteOnTermination;
    }

    public final Boolean defaultEnaQueueCount() {
        return this.defaultEnaQueueCount;
    }

    public final Integer enaQueueCount() {
        return this.enaQueueCount;
    }

    public final String attachmentId() {
        return this.attachmentId;
    }

    public final Boolean deleteOnTermination() {
        return this.deleteOnTermination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultEnaQueueCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.enaQueueCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteOnTermination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterfaceAttachmentChanges)) {
            return false;
        }
        NetworkInterfaceAttachmentChanges other = (NetworkInterfaceAttachmentChanges)obj;
        return Objects.equals(this.defaultEnaQueueCount(), other.defaultEnaQueueCount()) && Objects.equals(this.enaQueueCount(), other.enaQueueCount()) && Objects.equals(this.attachmentId(), other.attachmentId()) && Objects.equals(this.deleteOnTermination(), other.deleteOnTermination());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkInterfaceAttachmentChanges").add("DefaultEnaQueueCount", (Object)this.defaultEnaQueueCount()).add("EnaQueueCount", (Object)this.enaQueueCount()).add("AttachmentId", (Object)this.attachmentId()).add("DeleteOnTermination", (Object)this.deleteOnTermination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultEnaQueueCount": {
                return Optional.ofNullable(clazz.cast(this.defaultEnaQueueCount()));
            }
            case "EnaQueueCount": {
                return Optional.ofNullable(clazz.cast(this.enaQueueCount()));
            }
            case "AttachmentId": {
                return Optional.ofNullable(clazz.cast(this.attachmentId()));
            }
            case "DeleteOnTermination": {
                return Optional.ofNullable(clazz.cast(this.deleteOnTermination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DefaultEnaQueueCount", DEFAULT_ENA_QUEUE_COUNT_FIELD);
        map.put("EnaQueueCount", ENA_QUEUE_COUNT_FIELD);
        map.put("AttachmentId", ATTACHMENT_ID_FIELD);
        map.put("DeleteOnTermination", DELETE_ON_TERMINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkInterfaceAttachmentChanges, T> g) {
        return obj -> g.apply((NetworkInterfaceAttachmentChanges)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean defaultEnaQueueCount;
        private Integer enaQueueCount;
        private String attachmentId;
        private Boolean deleteOnTermination;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterfaceAttachmentChanges model) {
            this.defaultEnaQueueCount(model.defaultEnaQueueCount);
            this.enaQueueCount(model.enaQueueCount);
            this.attachmentId(model.attachmentId);
            this.deleteOnTermination(model.deleteOnTermination);
        }

        public final Boolean getDefaultEnaQueueCount() {
            return this.defaultEnaQueueCount;
        }

        public final void setDefaultEnaQueueCount(Boolean defaultEnaQueueCount) {
            this.defaultEnaQueueCount = defaultEnaQueueCount;
        }

        @Override
        public final Builder defaultEnaQueueCount(Boolean defaultEnaQueueCount) {
            this.defaultEnaQueueCount = defaultEnaQueueCount;
            return this;
        }

        public final Integer getEnaQueueCount() {
            return this.enaQueueCount;
        }

        public final void setEnaQueueCount(Integer enaQueueCount) {
            this.enaQueueCount = enaQueueCount;
        }

        @Override
        public final Builder enaQueueCount(Integer enaQueueCount) {
            this.enaQueueCount = enaQueueCount;
            return this;
        }

        public final String getAttachmentId() {
            return this.attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final Boolean getDeleteOnTermination() {
            return this.deleteOnTermination;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public NetworkInterfaceAttachmentChanges build() {
            return new NetworkInterfaceAttachmentChanges(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkInterfaceAttachmentChanges> {
        public Builder defaultEnaQueueCount(Boolean var1);

        public Builder enaQueueCount(Integer var1);

        public Builder attachmentId(String var1);

        public Builder deleteOnTermination(Boolean var1);
    }
}

